/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.filter;

import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.filter.FilterModifiers;
import com.agfa.pacs.data.shared.filter.IFilter;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.util.PatientKeyUtils;
import com.agfa.pacs.listtext.integration.Messages;
import com.agfa.pacs.listtext.lta.filter.FilterEntryCriterion;
import com.agfa.pacs.listtext.lta.filter.FilterEntryTypes;
import com.agfa.pacs.listtext.lta.filter.IFilterEntryType;
import com.agfa.pacs.listtext.lta.filter.IFilterSelectionSet;
import com.agfa.pacs.listtext.lta.filter.IFilterSelectionSetItem;
import com.agfa.pacs.listtext.lta.filter.IPersistantFilter;
import com.agfa.pacs.listtext.lta.filter.ISimpleFilterEntry;
import com.agfa.pacs.listtext.lta.filter.SimpleFilter;
import com.agfa.pacs.listtext.lta.filter.SimpleFilterEntry;
import com.agfa.pacs.listtext.lta.filter.advanced.AdvancedFilter;
import com.agfa.pacs.listtext.lta.filter.advanced.IAdvancedFilterEntry;
import com.agfa.pacs.listtext.lta.filter.dicom.DicomSearchCriterionFactory;
import com.agfa.pacs.listtext.lta.util.DicomTagDictionaryFactory;
import com.agfa.pacs.tools.DateUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.DateRange;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.PersonName;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;

public class FilterUtilities {
    public static final FilterModifiers.IFilterModifier<Boolean> NoMatchForNoValue = new FilterModifiers.IFilterModifier<Boolean>(){};
    public static final FilterModifiers.IFilterModifier<Date> ReferenceDate = new FilterModifiers.IFilterModifier<Date>(){};
    public static final FilterModifiers.IFilterModifier<Date> PreviousDemoDate = new FilterModifiers.IFilterModifier<Date>(){};
    public static final FilterModifiers.IFilterModifier<Boolean> OrMatchesSupported = new FilterModifiers.IFilterModifier<Boolean>(){};
    public static final FilterModifiers.IFilterModifier<Boolean> SemanticPNMatchingRequestedSystemOverride = new FilterModifiers.IFilterModifier<Boolean>(){};

    public static IFilterSelectionSetItem findItemForValue(IFilterSelectionSet iFilterSelectionSet, String string) {
        IFilterSelectionSetItem[] iFilterSelectionSetItemArray = iFilterSelectionSet.getSelectionItems();
        int n = iFilterSelectionSetItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFilterSelectionSetItem iFilterSelectionSetItem = iFilterSelectionSetItemArray[n2];
            if (iFilterSelectionSetItem.getValue().equals(string)) {
                return iFilterSelectionSetItem;
            }
            ++n2;
        }
        return null;
    }

    public static IPersistantFilter getEverythingForPatient(IPatientInfo iPatientInfo) {
        AdvancedFilter advancedFilter = new AdvancedFilter("PATIENT");
        String string = iPatientInfo.getAttributes().getString(0x100020, null);
        String string2 = iPatientInfo.getAttributes().getString(0x100010, null);
        advancedFilter.setFilterName("Everything for Patient " + string + " " + string2);
        FilterUtilities.initPatientFilter(iPatientInfo, advancedFilter);
        return advancedFilter;
    }

    public static IPersistantFilter getEverythingForPatient(String string, String string2) {
        AdvancedFilter advancedFilter = new AdvancedFilter("PATIENT");
        advancedFilter.setFilterName("Everything for Patient " + string);
        FilterEntryCriterion filterEntryCriterion = DicomSearchCriterionFactory.getInstance().createSearchCriterion(0x100020);
        advancedFilter.addEntry(new SimpleFilterEntry(Level.Patient, filterEntryCriterion, FilterEntryTypes.instanceEquals, new String[]{string}));
        if (string2 != null) {
            FilterEntryCriterion filterEntryCriterion2 = DicomSearchCriterionFactory.getInstance().createSearchCriterion(0x100021);
            advancedFilter.addEntry(new SimpleFilterEntry(Level.Patient, filterEntryCriterion2, FilterEntryTypes.instanceEquals, new String[]{string2}));
        }
        return advancedFilter;
    }

    private static Collection<SimpleFilterEntry> getPatientFilterEntries(String string) {
        FilterEntryCriterion filterEntryCriterion;
        ArrayList<SimpleFilterEntry> arrayList = new ArrayList<SimpleFilterEntry>();
        String string2 = PatientKeyUtils.extractPatientName((String)string);
        String string3 = PatientKeyUtils.extractIssuerOfPatientId((String)string);
        String string4 = PatientKeyUtils.extractPatientId((String)string);
        if (string4 != null && !string4.isEmpty()) {
            filterEntryCriterion = DicomSearchCriterionFactory.getInstance().createSearchCriterion(0x100020);
            arrayList.add(new SimpleFilterEntry(Level.Patient, filterEntryCriterion, FilterEntryTypes.instanceEquals, new String[]{string4}));
        }
        if (string3 != null && !string3.isEmpty()) {
            filterEntryCriterion = DicomSearchCriterionFactory.getInstance().createSearchCriterion(0x100021);
            arrayList.add(new SimpleFilterEntry(Level.Patient, filterEntryCriterion, FilterEntryTypes.instanceEquals, new String[]{string3}));
        }
        if (string2 != null && !string2.isEmpty()) {
            filterEntryCriterion = DicomSearchCriterionFactory.getInstance().createSearchCriterion(0x100010);
            arrayList.add(new SimpleFilterEntry(Level.Patient, filterEntryCriterion, FilterEntryTypes.instanceEquals, new String[]{string2}));
        }
        return arrayList;
    }

    public static IPersistantFilter getPatient(String string) {
        AdvancedFilter advancedFilter = new AdvancedFilter("PATIENT");
        advancedFilter.setFilterName("Everything for Patient " + string);
        advancedFilter.putModifierValue(FilterModifiers.SemanticPNMatchingRequested, false);
        Collection<SimpleFilterEntry> collection = FilterUtilities.getPatientFilterEntries(string);
        if (collection != null) {
            for (SimpleFilterEntry simpleFilterEntry : collection) {
                advancedFilter.addEntry(simpleFilterEntry);
            }
        }
        return advancedFilter;
    }

    public static IPersistantFilter getInstance(String string) {
        AdvancedFilter advancedFilter = new AdvancedFilter();
        advancedFilter.setFilterName("Search for instance");
        FilterEntryCriterion filterEntryCriterion = DicomSearchCriterionFactory.getInstance().createSearchCriterion(524312);
        advancedFilter.addEntry(new SimpleFilterEntry(Level.Object, filterEntryCriterion, FilterEntryTypes.instanceEquals, new String[]{string}));
        return advancedFilter;
    }

    public static IPersistantFilter getInstances(Collection<String> collection) {
        return FilterUtilities.getInstancesByKeys(collection, null);
    }

    public static IPersistantFilter getInstancesByKeys(Collection<String> collection, String string) {
        AdvancedFilter advancedFilter = new AdvancedFilter();
        String[] stringArray = collection.toArray(new String[collection.size()]);
        advancedFilter.setFilterName("Search for instances");
        FilterEntryCriterion filterEntryCriterion = DicomSearchCriterionFactory.getInstance().createSearchCriterion(524312);
        advancedFilter.addEntry(new SimpleFilterEntry(Level.Object, filterEntryCriterion, FilterEntryTypes.instanceEquals, stringArray));
        if (string != null) {
            for (SimpleFilterEntry simpleFilterEntry : FilterUtilities.getPatientFilterEntries(string)) {
                advancedFilter.addEntry(simpleFilterEntry);
            }
        }
        return advancedFilter;
    }

    public static SimpleFilter getInstancesAsInfos(List<IObjectInfo> list) {
        SimpleFilter simpleFilter = new SimpleFilter();
        FilterEntryCriterion filterEntryCriterion = DicomSearchCriterionFactory.getInstance().createSearchCriterion(524312);
        StringBuilder stringBuilder = new StringBuilder();
        for (IObjectInfo iObjectInfo : list) {
            stringBuilder.append(String.valueOf(iObjectInfo.getKey()) + "\\");
        }
        simpleFilter.setFilterName("Search for instances");
        simpleFilter.addEntry(new SimpleFilterEntry(Level.Object, filterEntryCriterion, FilterEntryTypes.instanceEquals, new String[]{stringBuilder.toString()}));
        return simpleFilter;
    }

    public static IPersistantFilter getStudyForUID(String string) {
        AdvancedFilter advancedFilter = new AdvancedFilter();
        advancedFilter.setFilterName("Search for StudyUID " + string);
        FilterEntryCriterion filterEntryCriterion = DicomSearchCriterionFactory.getInstance().createSearchCriterion(0x20000D);
        advancedFilter.addEntry(new SimpleFilterEntry(Level.Study, filterEntryCriterion, FilterEntryTypes.instanceEquals, new String[]{string}));
        return advancedFilter;
    }

    public static IPersistantFilter getStudyForUID(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Search for StudyUID ");
        stringBuilder.append(string);
        if (string2 != null) {
            stringBuilder.append(" of patient ");
            stringBuilder.append(string2);
        }
        AdvancedFilter advancedFilter = new AdvancedFilter();
        advancedFilter.setFilterName(stringBuilder.toString());
        FilterEntryCriterion filterEntryCriterion = DicomSearchCriterionFactory.getInstance().createSearchCriterion(0x20000D);
        advancedFilter.addEntry(new SimpleFilterEntry(Level.Study, filterEntryCriterion, FilterEntryTypes.instanceEquals, new String[]{string}));
        if (string2 != null) {
            for (SimpleFilterEntry simpleFilterEntry : FilterUtilities.getPatientFilterEntries(string2)) {
                advancedFilter.addEntry(simpleFilterEntry);
            }
        }
        return advancedFilter;
    }

    public static SimpleFilter getStudies(Iterable<IStudyInfo> iterable) {
        SimpleFilter simpleFilter = new SimpleFilter();
        simpleFilter.setFilterName("Search for StudyUID's");
        FilterEntryCriterion filterEntryCriterion = DicomSearchCriterionFactory.getInstance().createSearchCriterion(0x20000D);
        StringBuilder stringBuilder = new StringBuilder();
        for (IStudyInfo iStudyInfo : iterable) {
            stringBuilder.append(iStudyInfo.getKey()).append('\\');
        }
        simpleFilter.addEntry(new SimpleFilterEntry(Level.Study, filterEntryCriterion, FilterEntryTypes.instanceEquals, new String[]{stringBuilder.toString()}));
        return simpleFilter;
    }

    public static SimpleFilter getStudiesByKeys(Collection<String> collection) {
        SimpleFilter simpleFilter = new SimpleFilter();
        simpleFilter.setFilterName("Search for StudyUID's");
        if (collection != null && collection.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator<String> iterator = collection.iterator();
            stringBuilder.append(iterator.next());
            while (iterator.hasNext()) {
                stringBuilder.append("\\");
                stringBuilder.append(iterator.next());
            }
            FilterEntryCriterion filterEntryCriterion = DicomSearchCriterionFactory.getInstance().createSearchCriterion(0x20000D);
            simpleFilter.addEntry(new SimpleFilterEntry(Level.Study, filterEntryCriterion, FilterEntryTypes.instanceEquals, new String[]{stringBuilder.toString()}));
        }
        return simpleFilter;
    }

    public static SimpleFilter getSeries(List<ISeriesInfo> list) {
        SimpleFilter simpleFilter = new SimpleFilter();
        simpleFilter.setFilterName("Search for Series UID's");
        FilterEntryCriterion filterEntryCriterion = DicomSearchCriterionFactory.getInstance().createSearchCriterion(0x20000E);
        StringBuilder stringBuilder = new StringBuilder();
        for (ISeriesInfo iSeriesInfo : list) {
            stringBuilder.append(iSeriesInfo.getKey()).append('\\');
        }
        simpleFilter.addEntry(new SimpleFilterEntry(Level.Series, filterEntryCriterion, FilterEntryTypes.instanceEquals, new String[]{stringBuilder.toString()}));
        return simpleFilter;
    }

    public static IPersistantFilter getSeriesByKeys(Collection<String> collection) {
        AdvancedFilter advancedFilter = new AdvancedFilter();
        advancedFilter.setFilterName("Search for SeriesUID's");
        if (collection != null && collection.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator<String> iterator = collection.iterator();
            stringBuilder.append(iterator.next());
            while (iterator.hasNext()) {
                stringBuilder.append("\\");
                stringBuilder.append(iterator.next());
            }
            FilterEntryCriterion filterEntryCriterion = DicomSearchCriterionFactory.getInstance().createSearchCriterion(0x20000E);
            advancedFilter.addEntry(new SimpleFilterEntry(Level.Series, filterEntryCriterion, FilterEntryTypes.instanceEquals, new String[]{stringBuilder.toString()}));
        }
        return advancedFilter;
    }

    public static IPersistantFilter createKeyObjectsFilter(IDataInfo iDataInfo) {
        AdvancedFilter advancedFilter = new AdvancedFilter();
        FilterEntryCriterion filterEntryCriterion = DicomSearchCriterionFactory.getInstance().createSearchCriterion(524310);
        advancedFilter.addEntry(new SimpleFilterEntry(Level.Object, filterEntryCriterion, FilterEntryTypes.instanceEquals, new String[]{"1.2.840.10008.5.1.4.1.1.88.59"}));
        if (iDataInfo instanceof IPatientInfo) {
            FilterUtilities.initPatientFilter((IPatientInfo)iDataInfo, advancedFilter);
        } else if (iDataInfo instanceof IStudyInfo) {
            FilterEntryCriterion filterEntryCriterion2 = DicomSearchCriterionFactory.getInstance().createSearchCriterion(0x20000D);
            advancedFilter.addEntry(new SimpleFilterEntry(Level.Study, filterEntryCriterion2, FilterEntryTypes.instanceEquals, new String[]{iDataInfo.getAttributes().getString(0x20000D, null)}));
        } else if (iDataInfo instanceof ISeriesInfo) {
            FilterEntryCriterion filterEntryCriterion3 = DicomSearchCriterionFactory.getInstance().createSearchCriterion(0x20000E);
            advancedFilter.addEntry(new SimpleFilterEntry(Level.Series, filterEntryCriterion3, FilterEntryTypes.instanceEquals, new String[]{iDataInfo.getAttributes().getString(0x20000E, null)}));
        } else if (iDataInfo instanceof IObjectInfo) {
            FilterEntryCriterion filterEntryCriterion4 = DicomSearchCriterionFactory.getInstance().createSearchCriterion(524312);
            advancedFilter.addEntry(new SimpleFilterEntry(Level.Object, filterEntryCriterion4, FilterEntryTypes.instanceEquals, new String[]{iDataInfo.getAttributes().getString(524312, null)}));
        }
        return advancedFilter;
    }

    public static IPersistantFilter createPresentationStatesFilter(IDataInfo iDataInfo) {
        AdvancedFilter advancedFilter = new AdvancedFilter();
        FilterEntryCriterion filterEntryCriterion = DicomSearchCriterionFactory.getInstance().createSearchCriterion(524310);
        List list = UIDUtilities.getSOPClassUIDs((UIDType)UIDType.Presentation);
        StringBuilder stringBuilder = new StringBuilder();
        if (list != null && !list.isEmpty()) {
            stringBuilder.append((String)list.get(0));
            int n = 1;
            while (n < list.size()) {
                stringBuilder.append("\\" + (String)list.get(n));
                ++n;
            }
        }
        advancedFilter.addEntry(new SimpleFilterEntry(Level.Object, filterEntryCriterion, FilterEntryTypes.instanceEquals, new String[]{stringBuilder.toString()}));
        if (iDataInfo instanceof IPatientInfo) {
            FilterUtilities.initPatientFilter((IPatientInfo)iDataInfo, advancedFilter);
        } else if (iDataInfo instanceof IStudyInfo) {
            FilterEntryCriterion filterEntryCriterion2 = DicomSearchCriterionFactory.getInstance().createSearchCriterion(0x20000D);
            advancedFilter.addEntry(new SimpleFilterEntry(Level.Study, filterEntryCriterion2, FilterEntryTypes.instanceEquals, new String[]{iDataInfo.getAttributes().getString(0x20000D, null)}));
        } else if (iDataInfo instanceof ISeriesInfo) {
            FilterEntryCriterion filterEntryCriterion3 = DicomSearchCriterionFactory.getInstance().createSearchCriterion(0x20000E);
            advancedFilter.addEntry(new SimpleFilterEntry(Level.Series, filterEntryCriterion3, FilterEntryTypes.instanceEquals, new String[]{iDataInfo.getAttributes().getString(0x20000E, null)}));
        } else if (iDataInfo instanceof IObjectInfo) {
            FilterEntryCriterion filterEntryCriterion4 = DicomSearchCriterionFactory.getInstance().createSearchCriterion(524312);
            advancedFilter.addEntry(new SimpleFilterEntry(Level.Study, filterEntryCriterion4, FilterEntryTypes.instanceEquals, new String[]{iDataInfo.getAttributes().getString(524312, null)}));
        }
        return advancedFilter;
    }

    public static String evaluateToHtmlString(IFilter iFilter) {
        return FilterUtilities.evaluateToHtmlString(Collections.singletonList(iFilter));
    }

    public static String evaluateToHtmlString(List<IFilter> list) {
        StringBuilder stringBuilder = new StringBuilder();
        if (list != null) {
            stringBuilder.append("<html>");
            boolean bl = true;
            for (IFilter iFilter : list) {
                if (!(iFilter instanceof IPersistantFilter) || ((IPersistantFilter)iFilter).isEmpty()) continue;
                bl = false;
                break;
            }
            if (bl) {
                stringBuilder.append(Messages.getString("FilterEvaluate.Empty"));
            } else {
                boolean bl2 = true;
                for (IFilter iFilter : list) {
                    if (iFilter instanceof IPersistantFilter && ((IPersistantFilter)iFilter).isEmpty()) continue;
                    if (!bl2) {
                        stringBuilder.append("<p align='center'><b>");
                        stringBuilder.append(Messages.getString("FilterEvaluate.Or"));
                        stringBuilder.append("</b></p>");
                    }
                    if (iFilter instanceof AdvancedFilter) {
                        int n = 1;
                        List<IAdvancedFilterEntry> list2 = ((AdvancedFilter)iFilter).getEntries();
                        for (IAdvancedFilterEntry iAdvancedFilterEntry : list2) {
                            if (!iAdvancedFilterEntry.isEnabled()) continue;
                            n *= iAdvancedFilterEntry.getEntries().size();
                        }
                        int n2 = 0;
                        while (n2 < n) {
                            int n3 = 1;
                            ArrayList<ISimpleFilterEntry> arrayList = new ArrayList<ISimpleFilterEntry>();
                            for (IAdvancedFilterEntry iAdvancedFilterEntry : list2) {
                                if (!iAdvancedFilterEntry.isEnabled()) continue;
                                List<ISimpleFilterEntry> list3 = iAdvancedFilterEntry.getEntries();
                                arrayList.add(list3.get(n2 / n3 % list3.size()));
                                n3 *= list3.size();
                            }
                            if (n2 > 0) {
                                stringBuilder.append("<p align='center'><b>");
                                stringBuilder.append(Messages.getString("FilterEvaluate.Or"));
                                stringBuilder.append("</b></p>");
                            }
                            stringBuilder.append(FilterUtilities.toHtmlSubstring(iFilter, arrayList));
                            ++n2;
                        }
                    } else if (iFilter instanceof SimpleFilter) {
                        stringBuilder.append(FilterUtilities.toHtmlSubstring(iFilter, ((SimpleFilter)iFilter).getEntries()));
                    }
                    bl2 = false;
                }
            }
            stringBuilder.append("</html>");
        }
        return stringBuilder.toString();
    }

    private static String toHtmlSubstring(IFilter iFilter, List<ISimpleFilterEntry> list) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (ISimpleFilterEntry iSimpleFilterEntry : list) {
            List<String> list2 = FilterUtilities.toStrings(iFilter, iSimpleFilterEntry);
            if (list2 == null || list2.isEmpty()) continue;
            if (!bl) {
                stringBuilder.append(" <b>");
                stringBuilder.append(Messages.getString("FilterEvaluate.And"));
                stringBuilder.append("</b> ");
            }
            stringBuilder.append(list2.get(0));
            int n = 1;
            while (n < list2.size()) {
                stringBuilder.append(" <b>");
                stringBuilder.append(Messages.getString("FilterEvaluate.And"));
                stringBuilder.append("</b> ");
                stringBuilder.append(list2.get(n));
                ++n;
            }
            bl = false;
        }
        return stringBuilder.toString();
    }

    private static List<String> toStrings(IFilter iFilter, ISimpleFilterEntry iSimpleFilterEntry) {
        VR vR = iSimpleFilterEntry.getCriterion().getVR();
        IFilterEntryType iFilterEntryType = iSimpleFilterEntry.getType();
        if (VR.TM.equals((Object)vR) || VR.DA.equals((Object)vR) || VR.DT.equals((Object)vR)) {
            Attributes attributes = new Attributes();
            iFilterEntryType.modifyDataset(iSimpleFilterEntry, attributes, iFilter instanceof AdvancedFilter ? ((AdvancedFilter)iFilter).getModifiers() : null);
            int[] nArray = attributes.tags();
            if (nArray != null && nArray.length > 0) {
                ArrayList<String> arrayList = new ArrayList<String>(nArray.length);
                int[] nArray2 = nArray;
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int n3 = nArray2[n2];
                    DateRange dateRange = attributes.getDateRange(n3);
                    Date date = dateRange.getStartDate();
                    Date date2 = dateRange.getEndDate();
                    VR vR2 = ElementDictionary.vrOf((int)n3, null);
                    if (VR.DA.equals((Object)vR2)) {
                        date = DateUtilities.resetTime((Date)date);
                        date2 = DateUtilities.resetTime((Date)date2);
                    } else if (VR.TM.equals((Object)vR2)) {
                        date = DateUtilities.resetDate((Date)date);
                        date2 = DateUtilities.resetDate((Date)date2);
                    }
                    boolean bl = !date.equals(date2);
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(DicomTagDictionaryFactory.getLocaleDictionary().getNameForTag(n3));
                    if (bl) {
                        stringBuilder.append(" (");
                        stringBuilder.append(FilterUtilities.formatDate(n3, date));
                        stringBuilder.append(" ").append(Messages.getString("FilterEvaluate.Until")).append(" ");
                        stringBuilder.append(FilterUtilities.formatDate(n3, date2));
                        stringBuilder.append(")");
                    } else {
                        stringBuilder.append(" ").append(Messages.getString("FilterTypes.Is")).append(" ");
                        stringBuilder.append(FilterUtilities.formatDate(n3, date));
                    }
                    arrayList.add(stringBuilder.toString());
                    ++n2;
                }
                return arrayList;
            }
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(DicomTagDictionaryFactory.getLocaleDictionary().getNameForTag(iSimpleFilterEntry.getCriterion().getTag()));
            stringBuilder.append(" ");
            stringBuilder.append(iSimpleFilterEntry.getType().toString());
            stringBuilder.append(" ");
            String[] stringArray = iSimpleFilterEntry.getSearchStrings();
            if (stringArray != null && stringArray.length > 0) {
                if (stringArray.length > 1) {
                    stringBuilder.append(" ('");
                } else {
                    stringBuilder.append(" '");
                }
                int n = 0;
                while (n < stringArray.length) {
                    if (n > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(stringArray[n]);
                    ++n;
                }
                stringBuilder.append("'");
                if (stringArray.length > 1) {
                    stringBuilder.append(")");
                }
            }
            return Collections.singletonList(stringBuilder.toString());
        }
        return null;
    }

    private static String formatDate(int n, Date date) {
        VR vR = ElementDictionary.vrOf((int)n, null);
        if (VR.TM.equals((Object)vR)) {
            return DateTimeUtils.time2String((Date)date);
        }
        if (VR.DA.equals((Object)vR)) {
            return DateTimeUtils.date2ShortString((Date)date);
        }
        return DateTimeUtils.dateTime2String((Date)date);
    }

    private static void initPatientFilter(IPatientInfo iPatientInfo, AdvancedFilter advancedFilter) {
        FilterEntryCriterion filterEntryCriterion;
        String string = iPatientInfo.getAttributes().getString(0x100020, null);
        String string2 = iPatientInfo.getAttributes().getString(0x100010, null);
        String string3 = iPatientInfo.getAttributes().getString(0x100021, null);
        if (string != null) {
            filterEntryCriterion = DicomSearchCriterionFactory.getInstance().createSearchCriterion(0x100020);
            advancedFilter.addEntry(new SimpleFilterEntry(Level.Patient, filterEntryCriterion, FilterEntryTypes.instanceEquals, new String[]{string}));
        }
        if (string2 != null) {
            filterEntryCriterion = DicomSearchCriterionFactory.getInstance().createSearchCriterion(0x100010);
            advancedFilter.addEntry(new SimpleFilterEntry(Level.Patient, filterEntryCriterion, FilterEntryTypes.instanceEquals, new String[]{string2}));
        }
        if (string3 != null) {
            filterEntryCriterion = DicomSearchCriterionFactory.getInstance().createSearchCriterion(0x100021);
            advancedFilter.addEntry(new SimpleFilterEntry(Level.Patient, filterEntryCriterion, FilterEntryTypes.instanceEquals, new String[]{string3}));
        }
    }

    public static void putValue(Object object, int n, Attributes attributes) {
        if (object instanceof String) {
            attributes.setString(n, ElementDictionary.vrOf((int)n, null), (String)object);
            return;
        }
        if (object instanceof String[]) {
            attributes.setString(n, ElementDictionary.vrOf((int)n, null), (String[])object);
            return;
        }
        if (object instanceof Date) {
            attributes.setDate(n, ElementDictionary.vrOf((int)n, null), new Date[]{(Date)object});
            return;
        }
        if (object instanceof Integer) {
            attributes.setInt(n, ElementDictionary.vrOf((int)n, null), new int[]{(Integer)object});
            return;
        }
        if (object instanceof Float) {
            attributes.setFloat(n, ElementDictionary.vrOf((int)n, null), new float[]{((Float)object).floatValue()});
            return;
        }
        if (object instanceof Double) {
            attributes.setDouble(n, ElementDictionary.vrOf((int)n, null), new double[]{(Double)object});
            return;
        }
        if (object instanceof PersonName) {
            attributes.setString(n, VR.PN, ((PersonName)object).toString());
            return;
        }
    }

    public static void putValue(Object object, int[] nArray, Attributes attributes) {
        int n = 0;
        while (n + 2 <= nArray.length) {
            if (!attributes.contains(nArray[n])) {
                Sequence sequence = attributes.newSequence(nArray[n], 2);
                attributes = new Attributes();
                sequence.add(attributes);
            } else {
                attributes = attributes.getNestedDataset(nArray[n]);
            }
            n += 2;
        }
        int n2 = nArray[nArray.length - 1];
        if (object instanceof String) {
            attributes.setString(n2, ElementDictionary.vrOf((int)n2, null), (String)object);
            return;
        }
        if (object instanceof String[]) {
            attributes.setString(n2, ElementDictionary.vrOf((int)n2, null), (String[])object);
            return;
        }
        if (object instanceof Date) {
            attributes.setDate(n2, ElementDictionary.vrOf((int)n2, null), new Date[]{(Date)object});
            return;
        }
        if (object instanceof Integer) {
            attributes.setInt(n2, ElementDictionary.vrOf((int)n2, null), new int[]{(Integer)object});
            return;
        }
        if (object instanceof Float) {
            attributes.setFloat(n2, ElementDictionary.vrOf((int)n2, null), new float[]{((Float)object).floatValue()});
            return;
        }
        if (object instanceof Double) {
            attributes.setDouble(n2, ElementDictionary.vrOf((int)n2, null), new double[]{(Double)object});
            return;
        }
        if (object instanceof PersonName) {
            attributes.setString(n2, VR.PN, ((PersonName)object).toString());
            return;
        }
    }
}

