/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.filter;

import com.agfa.pacs.config.ConfigUtilities;
import com.agfa.pacs.listtext.lta.filter.FilterEntryTypes;
import com.agfa.pacs.listtext.lta.filter.IFilterEntryType;
import com.agfa.pacs.listtext.lta.filter.advanced.AdvancedFilterEntryTypes;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.VR;

public class FilterEntryTypesFactory {
    public static IFilterEntryType getFilterEntryTypeForCode(String string) {
        for (IFilterEntryType iFilterEntryType : FilterEntryTypes.types) {
            if (!string.equals(iFilterEntryType.getCode())) continue;
            return iFilterEntryType;
        }
        for (IFilterEntryType iFilterEntryType : AdvancedFilterEntryTypes.types) {
            if (!string.equals(iFilterEntryType.getCode())) continue;
            return iFilterEntryType;
        }
        return null;
    }

    public static List<IFilterEntryType> getFilterEntryTypes(VR vR, int n) {
        return FilterEntryTypesFactory.getFilterEntryTypes(vR, n, false);
    }

    public static List<IFilterEntryType> getFilterEntryTypes(VR vR, int n, boolean bl) {
        int n2 = vR.code();
        ArrayList<IFilterEntryType> arrayList = new ArrayList<IFilterEntryType>();
        if (n == 0x400009) {
            arrayList.add(FilterEntryTypes.instanceEquals);
            return arrayList;
        }
        if (n == 4390932) {
            arrayList.add(FilterEntryTypes.instanceCallingAETEquals);
            return arrayList;
        }
        if (n == 3276810) {
            arrayList.add(FilterEntryTypes.instanceDicomStatusEquals);
            arrayList.add(AdvancedFilterEntryTypes.instanceDicomStatusEqualsNot);
            return arrayList;
        }
        if (n == 3280946) {
            arrayList.add(FilterEntryTypes.instanceNamed);
            if (!ConfigUtilities.isGerman() || ConfigUtilities.isDebug()) {
                arrayList.add(FilterEntryTypes.instanceIdeographics);
                arrayList.add(FilterEntryTypes.instancePhonetics);
            }
            if (bl) {
                arrayList.add(AdvancedFilterEntryTypes.instanceRequestingPhysicianNotNamed);
            }
            return arrayList;
        }
        if (n == 3280947) {
            arrayList.add(FilterEntryTypes.instanceContainsIgnoreCase);
            arrayList.add(FilterEntryTypes.instanceEqualsIgnoreCase);
            if (bl) {
                arrayList.add(AdvancedFilterEntryTypes.instanceRequestingServiceNotContains);
            }
            return arrayList;
        }
        if (n == 0x100021 || n == 0x100020) {
            arrayList.add(FilterEntryTypes.instanceEquals);
            return arrayList;
        }
        if (n2 == VR.PN.code()) {
            arrayList.add(FilterEntryTypes.instanceNamed);
            if (!ConfigUtilities.isGerman() || ConfigUtilities.isDebug()) {
                arrayList.add(FilterEntryTypes.instanceIdeographics);
                arrayList.add(FilterEntryTypes.instancePhonetics);
            }
            if (bl) {
                arrayList.add(AdvancedFilterEntryTypes.instanceNotNamed);
            }
            return arrayList;
        }
        if (n2 == VR.UL.code() || n2 == VR.US.code()) {
            arrayList.add(FilterEntryTypes.instanceEquals);
            if (bl) {
                arrayList.add(AdvancedFilterEntryTypes.instanceNotEquals);
            }
        }
        if (n2 == VR.CS.code() || n2 == VR.SH.code()) {
            if (n == 524385) {
                arrayList.add(FilterEntryTypes.instanceMultiEqualsIgnoreCase);
                if (bl) {
                    arrayList.add(AdvancedFilterEntryTypes.instanceNotContains);
                }
            } else if (n == 524384) {
                arrayList.add(FilterEntryTypes.instanceEqualsIgnoreCase);
                if (bl) {
                    arrayList.add(AdvancedFilterEntryTypes.instanceNotEqualsIgnoreCase);
                }
            } else if (n == 528400) {
                arrayList.add(FilterEntryTypes.instanceEqualsIgnoreCase);
                arrayList.add(FilterEntryTypes.instanceStartsWithIgnoreCase);
                arrayList.add(FilterEntryTypes.instanceEndsWithIgnoreCase);
                arrayList.add(FilterEntryTypes.instanceContainsIgnoreCase);
            } else if (n == 0x100040) {
                arrayList.add(FilterEntryTypes.instanceEquals);
                if (bl) {
                    arrayList.add(AdvancedFilterEntryTypes.instanceNotEquals);
                }
            } else {
                arrayList.add(FilterEntryTypes.instanceEquals);
                arrayList.add(FilterEntryTypes.instanceStartsWith);
                arrayList.add(FilterEntryTypes.instanceEndsWith);
                arrayList.add(FilterEntryTypes.instanceContains);
                if (bl) {
                    arrayList.add(AdvancedFilterEntryTypes.instanceNotEquals);
                    arrayList.add(AdvancedFilterEntryTypes.instanceNotContains);
                }
            }
        }
        if (n2 == VR.AE.code() || n2 == VR.LO.code() || n2 == VR.LT.code() || n2 == VR.ST.code() || n2 == VR.UT.code() || n2 == VR.IS.code()) {
            arrayList.add(FilterEntryTypes.instanceContains);
            arrayList.add(FilterEntryTypes.instanceEquals);
            arrayList.add(FilterEntryTypes.instanceStartsWith);
            arrayList.add(FilterEntryTypes.instanceEndsWith);
            if (bl) {
                arrayList.add(AdvancedFilterEntryTypes.instanceNotContains);
                arrayList.add(AdvancedFilterEntryTypes.instanceNotEquals);
            }
        }
        if (n2 == VR.DA.code() || n2 == VR.DT.code()) {
            arrayList.add(FilterEntryTypes.instanceRange);
            arrayList.add(FilterEntryTypes.instanceEquals);
            if (n == 524320 || n == 0x404005 || 0x400244 == n) {
                arrayList.add(FilterEntryTypes.instanceToday);
                arrayList.add(FilterEntryTypes.instanceDaysOld);
                arrayList.add(AdvancedFilterEntryTypes.instanceUntilPreviousScheduledDate);
            } else if (n == 0x100030) {
                arrayList.add(FilterEntryTypes.instanceOlderThen);
                arrayList.add(FilterEntryTypes.instanceYoungerThen);
            }
        }
        if (n2 == VR.TM.code()) {
            arrayList.add(AdvancedFilterEntryTypes.instanceDateTimeRange);
            arrayList.add(AdvancedFilterEntryTypes.instanceYesterdayTodayTime);
            arrayList.add(AdvancedFilterEntryTypes.instanceYesterdayTime);
            arrayList.add(AdvancedFilterEntryTypes.instanceTodayTime);
            arrayList.add(AdvancedFilterEntryTypes.instanceNDayTime);
            arrayList.add(AdvancedFilterEntryTypes.instanceLastXHoursTime);
        }
        if (n2 == VR.SQ.code()) {
            if (n == 4210712 || n == 0x404034) {
                arrayList.add(FilterEntryTypes.instanceEquals);
            }
            arrayList.add(FilterEntryTypes.instanceCodeEquals);
        }
        if (arrayList.isEmpty()) {
            arrayList.add(FilterEntryTypes.instanceEquals);
        }
        return arrayList;
    }
}

