/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.integration.dirwatcher;

import com.agfa.pacs.data.dicom.comm.DicomCFindConst;
import com.agfa.pacs.data.shared.NodeProperty;
import com.agfa.pacs.data.shared.filter.FilterTag;
import com.agfa.pacs.data.shared.filter.IFilter;
import com.agfa.pacs.data.shared.icon.IIconProvider;
import com.agfa.pacs.data.shared.icon.impl.ImagePixelIconProvider;
import com.agfa.pacs.data.shared.instanceinfo.IInstanceInfo;
import com.agfa.pacs.data.shared.instanceinfo.impl.URIInstanceInfo;
import com.agfa.pacs.data.shared.lw.DataInfoFactoryProvider;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoFactory;
import com.agfa.pacs.data.shared.lw.IDataInfoRetriever;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IDataProviderIdentifier;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.lw.IRootInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.properties.PropertiesOwner;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.dcm4che3.data.Attributes;

public class FileDataSource
implements IDataInfoSource {
    private IRootInfo root;
    private Identifier id;
    private IIconProvider iconProvider;

    public FileDataSource(IRootInfo iRootInfo, File file, boolean bl) {
        this.root = iRootInfo;
        this.id = new Identifier(file, bl);
        this.iconProvider = new ImagePixelIconProvider();
    }

    public IRootInfo getDataInfo(IFilter iFilter) throws Exception {
        return this.root;
    }

    public String getSourceAET() {
        return null;
    }

    public IIconProvider getIconProvider() {
        return this.iconProvider;
    }

    public List<FilterTag> getResultTags() {
        return null;
    }

    public List<FilterTag> getSearchTags() {
        return null;
    }

    public IDataProviderIdentifier getIdentifier() {
        return this.id;
    }

    static IObjectInfo getDataInfo(File file, Attributes attributes, Map<String, IDataInfo> map, boolean bl) {
        IDataInfo iDataInfo;
        IDataInfo iDataInfo2;
        IRootInfo iRootInfo;
        IDataInfoSource iDataInfoSource;
        IDataInfo iDataInfo3;
        IDataInfoFactory iDataInfoFactory = DataInfoFactoryProvider.getInstance();
        String string = DataInfoUtilities.compilePatientKey((Attributes)attributes);
        if (map.containsKey(string)) {
            iDataInfo3 = map.get(string);
            iDataInfoSource = iDataInfo3.getSource();
        } else {
            iRootInfo = iDataInfoFactory.createRootInfo("File");
            iDataInfoSource = new FileDataSource(iRootInfo, file, bl);
            iDataInfo3 = iDataInfoFactory.createPatientInfo(iRootInfo, FileDataSource.createCopy(attributes, DicomCFindConst.PATIENT_TAGS), string);
            iDataInfo3.setSource(iDataInfoSource);
            map.put(string, iDataInfo3);
        }
        string = attributes.getString(0x20000D);
        if (map.containsKey(string)) {
            iDataInfo2 = map.get(string);
        } else {
            iDataInfo2 = iDataInfoFactory.createStudyInfo((IPatientInfo)iDataInfo3, FileDataSource.createCopy(attributes, DicomCFindConst.STUDIES_MERGED_TAGS), string);
            iDataInfo2.setSource(iDataInfoSource);
            map.put(string, iDataInfo2);
        }
        string = attributes.getString(0x20000E);
        if (map.containsKey(string)) {
            iDataInfo = map.get(string);
        } else {
            iDataInfo = iDataInfoFactory.createSeriesInfo((IStudyInfo)iDataInfo2, FileDataSource.createCopy(attributes, DicomCFindConst.SERIES_MERGED_TAGS), string);
            iDataInfo.setSource(iDataInfoSource);
            map.put(string, iDataInfo);
        }
        iRootInfo = iDataInfoFactory.createObjectInfo((ISeriesInfo)iDataInfo, new Attributes(attributes), attributes.getString(524312));
        iRootInfo.setSource(iDataInfoSource);
        URI uRI = file.toURI();
        iRootInfo.setInstanceInfo((IInstanceInfo)new URIInstanceInfo(uRI));
        return iRootInfo;
    }

    private static Attributes createCopy(Attributes attributes, int ... nArray) {
        return new Attributes(attributes, nArray);
    }

    public IDataInfoRetriever getRetriever() {
        return null;
    }

    public void addURL(URL uRL) {
        throw new UnsupportedOperationException();
    }

    public void setStudyDefaults(Attributes attributes) {
    }

    public List<Attributes> rawDicomSearch(Attributes attributes, String string) {
        throw new UnsupportedOperationException();
    }

    private static class FileProperty
    implements PropertiesOwner {
        private Properties p = new Properties();
        private static final String FILE_PATH = "file";

        public FileProperty(String string) {
            this.p.put(FILE_PATH, string);
        }

        public Properties properties() {
            return this.p;
        }

        public String getDefaultValue(String string) {
            return null;
        }

        public String[] getMandatoryPropertyList() {
            return new String[]{FILE_PATH};
        }

        public String[] getOptionalPropertyList() {
            return new String[0];
        }

        public String[] getValuesForProperty(String string) {
            return null;
        }

        public boolean onlyOptionalProperties() {
            return false;
        }

        public boolean requiresProperties() {
            return true;
        }
    }

    private class Identifier
    implements IDataProviderIdentifier {
        private File f;
        private FileProperty property;
        private boolean unsaved;

        public Identifier(File file, boolean bl) {
            this.property = new FileProperty(file.getAbsolutePath());
            this.f = file;
            this.unsaved = bl;
        }

        public IDataProviderIdentifier derive() {
            return new Identifier(this.f, this.unsaved);
        }

        public String getName() {
            return "File";
        }

        public PropertiesOwner getPropertiesOwner() {
            return this.property;
        }

        public String getType() {
            if (this.unsaved) {
                return "SINGLE_FILE_NOT_SAVED";
            }
            return "SINGLE_FILE";
        }

        public boolean exclusiveRetrieval() {
            return false;
        }

        public boolean isEnabled(NodeProperty nodeProperty) {
            return false;
        }

        public String getURLString() {
            throw new UnsupportedOperationException();
        }
    }
}

