/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.dicom.device;

import com.agfa.pacs.data.dicom.device.IDicomService;
import com.agfa.pacs.data.dicom.transfercapability.ITransferCapabilityProvider;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.net.pdu.ExtendedNegotiation;
import org.dcm4che3.net.service.BasicCEchoSCP;
import org.dcm4che3.net.service.DicomService;
import org.dcm4che3.net.service.DicomServiceRegistry;

public class VerificationDicomService
extends BasicCEchoSCP
implements IDicomService {
    private ALogger log = ALogger.getLogger(VerificationDicomService.class);

    public VerificationDicomService() {
        super(new String[]{"1.2.840.10008.1.1"});
    }

    @Override
    public String getInfo() {
        return "Verification SCP";
    }

    @Override
    public void registerIn(DicomServiceRegistry dicomServiceRegistry) {
        dicomServiceRegistry.addDicomService((DicomService)this);
        this.log.info(String.valueOf(this.getInfo()) + " registered");
    }

    @Override
    public void unregisterIn(DicomServiceRegistry dicomServiceRegistry) {
        dicomServiceRegistry.removeDicomService((DicomService)this);
        this.log.info(String.valueOf(this.getInfo()) + " unregistered");
    }

    public static class VerificationTransferCapabilityProvider
    implements ITransferCapabilityProvider {
        @Override
        public List<TransferCapability> getTransferCapabilities() {
            ArrayList<TransferCapability> arrayList = new ArrayList<TransferCapability>();
            arrayList.add(new TransferCapability(null, "1.2.840.10008.1.1", TransferCapability.Role.SCP, new String[]{"1.2.840.10008.1.2"}));
            return arrayList;
        }

        @Override
        public List<ExtendedNegotiation> getExtendedNegotiation() {
            return Collections.emptyList();
        }
    }
}

