/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.dicom.device;

import com.agfa.pacs.data.dicom.device.DicomDevice;
import com.agfa.pacs.data.dicom.device.config.DicomDeviceConfiguration;
import com.agfa.pacs.data.dicom.device.config.DicomDeviceConfigurationFactory;
import com.agfa.pacs.logging.ALogger;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.Device;

public class DicomDeviceFactory {
    private static final DicomDeviceFactory instance = new DicomDeviceFactory();
    private DicomDevice dicomDevice;
    private DicomDeviceConfiguration config = DicomDeviceConfigurationFactory.getConfiguration();

    private DicomDeviceFactory() {
    }

    public static DicomDeviceFactory getInstance() {
        return instance;
    }

    public boolean isDeviceCreated() {
        return this.dicomDevice != null;
    }

    public DicomDevice getDicomDevice() {
        if (this.dicomDevice == null) {
            Device device = this.config.getDevice();
            String string = this.config.getDefaultAET();
            this.dicomDevice = new DicomDevice(device, string);
        }
        return this.dicomDevice;
    }

    public static Attributes getDeviceInfo() {
        try {
            Attributes attributes = new Attributes();
            DicomDevice dicomDevice = DicomDeviceFactory.getInstance().getDicomDevice();
            Device device = dicomDevice.getDevice();
            attributes.setString(524400, VR.LO, device.getManufacturer());
            attributes.setString(528400, VR.SH, device.getStationName());
            attributes.setString(528528, VR.LO, device.getManufacturerModelName());
            attributes.setString(0x181000, VR.LO, device.getDeviceSerialNumber());
            attributes.setString(524416, VR.LO, DicomDeviceFactory.concat(device.getInstitutionNames(), "\n"));
            attributes.setString(524417, VR.ST, DicomDeviceFactory.concat(device.getInstitutionAddresses(), "\n"));
            attributes.setString(528448, VR.LO, DicomDeviceFactory.concat(device.getInstitutionalDepartmentNames(), "\n"));
            return attributes;
        }
        catch (Exception exception) {
            ALogger.getLogger(DicomDeviceFactory.class).error("Could not get device", (Throwable)exception);
            return null;
        }
    }

    private static String concat(String[] stringArray, String string) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        int n = 1;
        while (n < stringArray.length) {
            stringBuffer.append(string).append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }
}

