/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.dicom.device;

import com.agfa.pacs.data.dicom.device.config.DicomDeviceConfigurationFactory;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DimseRQHandler;

public class DicomDevice {
    private ApplicationEntity defaultAE;
    private Device device;

    public DicomDevice(Device device, String string) {
        this.device = device;
        this.defaultAE = this.findNetworkApplicationEntity(string.trim());
    }

    public Device getDevice() {
        return this.device;
    }

    public ApplicationEntity getAE(String string) {
        if (string == null) {
            return this.defaultAE;
        }
        ApplicationEntity applicationEntity = this.findNetworkApplicationEntity(string = string.trim());
        if (applicationEntity == null) {
            applicationEntity = DicomDeviceConfigurationFactory.getConfiguration().createNetworkApplicationEntity(string, false, null);
            applicationEntity.setDimseRQHandler((DimseRQHandler)DicomDeviceConfigurationFactory.getConfiguration().getRegistry());
        }
        return applicationEntity;
    }

    private ApplicationEntity findNetworkApplicationEntity(String string) {
        return this.device.getApplicationEntity(string);
    }

    public String getDefaultAET() {
        return this.defaultAE.getAETitle();
    }
}

