/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.dicom.comm;

import com.agfa.pacs.data.dicom.DicomException;
import com.agfa.pacs.data.dicom.ICMoveSCUListener;
import com.agfa.pacs.data.dicom.QueryRetrieveLevel;
import com.agfa.pacs.data.dicom.comm.DicomCMoveSCU;
import com.agfa.pacs.data.dicom.comm.QueryRetrieveInformationModel;
import com.agfa.pacs.data.dicom.transfercapability.ITransferCapabilityProvider;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.dicom.UIDMap;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.logging.ALogger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.net.pdu.ExtendedNegotiation;

public class DicomCompositeCMoveSCU
extends DicomCMoveSCU {
    private static final ALogger log = ALogger.getLogger(DicomCompositeCMoveSCU.class);
    private QueryRetrieveInformationModel queryRetrieveInformationModel;
    public static final String[] AllRetrieveClassUIDs = new String[]{"1.2.840.10008.5.1.4.1.2.2.2", "1.2.840.10008.5.1.4.1.2.1.2", "1.2.840.10008.5.1.4.1.2.3.2"};
    public static final String[] DefaultRetrieveClassUIDs = new String[]{"1.2.840.10008.5.1.4.1.2.2.2", "1.2.840.10008.5.1.4.1.2.1.2"};
    public static final String[] PatientStudyOnlyRetrieveClassUIDs = new String[]{"1.2.840.10008.5.1.4.1.2.3.2"};

    public DicomCompositeCMoveSCU(IDicomNode iDicomNode, String[] stringArray) {
        super(iDicomNode, stringArray);
    }

    @Override
    public synchronized void connect() throws DicomException {
        super.connect();
        String[] stringArray = AllRetrieveClassUIDs;
        int n = AllRetrieveClassUIDs.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            Set set = this.association.getTransferSyntaxesFor(string);
            if (set != null && !set.isEmpty()) {
                if ("1.2.840.10008.5.1.4.1.2.1.2".equals(string)) {
                    this.queryRetrieveInformationModel = QueryRetrieveInformationModel.PatientRoot;
                }
                if ("1.2.840.10008.5.1.4.1.2.2.2".equals(string)) {
                    this.queryRetrieveInformationModel = QueryRetrieveInformationModel.StudyRoot;
                }
                if ("1.2.840.10008.5.1.4.1.2.3.2".equals(string)) {
                    this.queryRetrieveInformationModel = QueryRetrieveInformationModel.PatientStudyOnly;
                }
                if (this.queryRetrieveInformationModel != null) {
                    this.qrSOPClass = string;
                    this.qrTSUID = set;
                    break;
                }
            }
            ++n2;
        }
    }

    public synchronized void move(String string, Attributes attributes, QueryRetrieveLevel queryRetrieveLevel, ICMoveSCUListener iCMoveSCUListener) throws DicomException {
        if (log.isDebugEnabled() && attributes != null) {
            log.debug("C-Move:" + attributes);
        }
        Attributes attributes2 = new Attributes(attributes);
        attributes2.setString(524370, VR.CS, queryRetrieveLevel.dicom());
        this.cMove(string, attributes2, iCMoveSCUListener);
    }

    public synchronized int move(String string, Attributes attributes, QueryRetrieveLevel queryRetrieveLevel) throws DicomException {
        if (log.isDebugEnabled() && attributes != null) {
            log.debug("C-Move:" + attributes);
        }
        Attributes attributes2 = new Attributes(attributes);
        attributes2.setString(524370, VR.CS, queryRetrieveLevel.dicom());
        return this.cMove(string, attributes2);
    }

    public QueryRetrieveInformationModel getQueryRetrieveInformationModel() {
        return this.queryRetrieveInformationModel;
    }

    public static class CMoveTransferCapabilityProvider
    implements ITransferCapabilityProvider {
        @Override
        public List<TransferCapability> getTransferCapabilities() {
            UIDMap uIDMap = new UIDMap();
            Set set = UIDUtilities.getDefaultTransferSyntaxUIDs();
            String[] stringArray = AllRetrieveClassUIDs;
            int n = AllRetrieveClassUIDs.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                uIDMap.addTransferSyntaxUIDs(string, (Collection)set);
                ++n2;
            }
            return uIDMap.getTransferCapabilities(false);
        }

        @Override
        public List<ExtendedNegotiation> getExtendedNegotiation() {
            return Collections.emptyList();
        }
    }
}

