/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.dicom.comm;

import com.agfa.pacs.data.dicom.DicomException;
import com.agfa.pacs.data.dicom.ICMoveSCU;
import com.agfa.pacs.data.dicom.ICMoveSCUListener;
import com.agfa.pacs.data.dicom.comm.DicomSCU;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.logging.ALogger;
import java.util.Set;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.DimseRSP;
import org.dcm4che3.net.DimseRSPHandler;
import org.dcm4che3.util.TagUtils;

public class DicomCMoveSCU
extends DicomSCU
implements ICMoveSCU {
    private static final ALogger log = ALogger.getLogger(DicomCMoveSCU.class);
    private DimseRSP response;
    protected Set<String> qrTSUID;
    protected String qrSOPClass;

    public DicomCMoveSCU(IDicomNode iDicomNode, String[] stringArray) {
        super(iDicomNode);
        Set set = UIDUtilities.getImageTransferSyntaxUIDs();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            this.addTransferCapability(string, set);
            ++n2;
        }
    }

    @Override
    public synchronized void cMove(String string, Attributes attributes, ICMoveSCUListener iCMoveSCUListener) throws DicomException {
        if (this.qrSOPClass == null) {
            throw new DicomException("No SOP Class");
        }
        try {
            if (string == null) {
                string = this.localAE.getAETitle();
            }
            String string2 = this.qrTSUID.iterator().next();
            log.debug("C-Move:" + attributes);
            this.association.cmove(this.qrSOPClass, 1, attributes, string2, string, (DimseRSPHandler)new CMoveDimseListener(iCMoveSCUListener, this.association.nextMessageID()));
        }
        catch (Exception exception) {
            throw new DicomException(exception);
        }
    }

    @Override
    public synchronized int cMove(String string, Attributes attributes) throws DicomException {
        try {
            if (string == null) {
                string = this.localAE.getAETitle();
            }
            String string2 = this.qrTSUID.iterator().next();
            log.debug("C-Move:" + attributes);
            this.response = this.association.cmove(this.qrSOPClass, 1, attributes, string2, string);
            while (this.response.next()) {
                Attributes attributes2 = this.response.getCommand();
                this.handleStatus(attributes2, true);
                if (this.isPending(this.response.getCommand())) continue;
                return attributes2.getInt(2304, 0);
            }
            return 0;
        }
        catch (DicomException dicomException) {
            throw dicomException;
        }
        catch (Exception exception) {
            throw new DicomException(exception);
        }
    }

    @Override
    public synchronized void cCancel() throws DicomException {
        try {
            if (this.response != null) {
                this.response.cancel(this.association);
            }
        }
        catch (Exception exception) {
            throw new DicomException(exception);
        }
    }

    @Override
    protected void handleStatus(Attributes attributes, boolean bl) throws DicomException {
        super.handleStatus(attributes, bl);
        int n = attributes.getInt(2304, 0);
        switch (n) {
            case 65280: {
                if (!log.isDebugEnabled()) break;
                log.debug("Status: " + Integer.toHexString(n));
                log.debug("PENDING: Sub-operations are continuing.");
                this.showNumbers(attributes);
                break;
            }
            case 45056: {
                log.warn("Status: " + Integer.toHexString(n));
                log.warn("WARN: Sub-operations complete - one more more failures.");
                this.showNumbers(attributes);
                break;
            }
            case 0: {
                if (!log.isDebugEnabled()) break;
                log.debug("Status: " + Integer.toHexString(n));
                log.debug("SUCCESS: Sub-operations complete - no failures.");
                this.showNumbers(attributes);
                break;
            }
            case 42753: {
                log.error("Status: " + Integer.toHexString(n));
                log.error("FAILURE: Out of Resources - unable to calculate number of matches");
                log.error("Error Comment: " + attributes.getString(2306));
                this.showTags(attributes.getInts(2305));
                this.showNumbers(attributes);
                throw new DicomException(n, "FAILURE: Out of Resources - unable to calculate number of matches");
            }
            case 42754: {
                log.error("Status: " + Integer.toHexString(n));
                log.error("FAILURE: Out of Resources - unable to perform sub-operations");
                log.error("Error Comment: " + attributes.getString(2306));
                this.showNumbers(attributes);
                throw new DicomException(n, "FAILURE: Out of Resources - unable to calculate number of matches");
            }
            case 43009: {
                log.error("Status: " + Integer.toHexString(n));
                log.error("FAILURE: Refused: Move destination unknown");
                log.error("Error Comment: " + attributes.getString(2306));
                this.showTags(attributes.getInts(2305));
                this.showNumbers(attributes);
                throw new DicomException(n, "FAILURE: Refused: Move destination unknown");
            }
            case 43264: {
                log.error("Status: " + Integer.toHexString(n));
                log.error("FAILURE: Identifier does not match SOP Class.");
                log.error("Error Comment: " + attributes.getString(2306));
                this.showTags(attributes.getInts(2305));
                this.showNumbers(attributes);
                throw new DicomException(n, "FAILURE: Identifier does not match SOP Class.");
            }
            case 65024: {
                log.info("Status: " + Integer.toHexString(n));
                log.info("CANCEL: Request was cancelled.");
                this.showNumbers(attributes);
                break;
            }
            default: {
                log.error("Status: " + Integer.toHexString(n));
                if ((n & 0xC000) != 49152) break;
                log.error("FAILURE: Unable to process.");
                log.error("Error Comment: " + attributes.getString(2306));
                this.showTags(attributes.getInts(2305));
                this.showNumbers(attributes);
                throw new DicomException(n, "FAILURE: Unable to process.");
            }
        }
    }

    private void showTags(int[] nArray) {
        if (nArray == null) {
            return;
        }
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Tag: ");
            stringBuilder.append(TagUtils.toString((int)n3));
            stringBuilder.append(" ");
            stringBuilder.append(ElementDictionary.keywordOf((int)n3, null));
            log.info(stringBuilder.toString());
            ++n2;
        }
    }

    private void showNumbers(Attributes attributes) {
        if (log.isDebugEnabled()) {
            int n;
            if (attributes.contains(4128)) {
                log.debug("Remaining Sub-operations: " + attributes.getInt(4128, 0));
            }
            if (attributes.contains(4129)) {
                log.debug("Completed Sub-operations: " + attributes.getInt(4129, 0));
            }
            if (attributes.contains(4130) && (n = attributes.getInt(4130, 0)) != 0) {
                log.debug("Failed Sub-operations: " + n);
            }
            if (attributes.contains(4131) && (n = attributes.getInt(4131, 0)) != 0) {
                log.debug("Warning Sub-operations: " + n);
            }
        }
    }

    private class CMoveDimseListener
    extends DimseRSPHandler {
        private ICMoveSCUListener listener;

        public CMoveDimseListener(ICMoveSCUListener iCMoveSCUListener, int n) {
            super(n);
            this.listener = iCMoveSCUListener;
        }

        public void onClose(Association association) {
            super.onClose(association);
        }

        public void onDimseRSP(Association association, Attributes attributes, Attributes attributes2) {
            super.onDimseRSP(association, attributes, attributes2);
            if (this.listener != null) {
                if (attributes.containsValue(4128)) {
                    if (attributes.containsValue(4129)) {
                        this.listener.cmoveFinished(attributes.getInt(2304, 0), attributes.getInt(4128, 0), attributes.getInt(4129, 0));
                    } else {
                        this.listener.cmoveFinished(attributes.getInt(2304, 0), attributes.getInt(4128, 0), null);
                    }
                } else {
                    this.listener.cmoveFinished(attributes.getInt(2304, 0), null, null);
                }
            }
            try {
                DicomCMoveSCU.this.handleStatus(attributes, true);
            }
            catch (DicomException dicomException) {
                log.error("CMoveDimseListener", (Throwable)dicomException);
            }
            if (!DicomCMoveSCU.this.isPending(attributes)) {
                DicomCMoveSCU.this.response = null;
            }
        }
    }
}

