/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.dicom;

import com.agfa.pacs.data.shared.NodeProperty;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.properties.AbstractPropertiesOwner;
import java.util.Properties;

public class DicomPropertiesOwner
extends AbstractPropertiesOwner
implements IDicomNode {
    private static final String noExtendedNegotation = "noExtendedNegotation";
    private static final String relationalQuery = "relationalQuery";
    public static final String closeImmediately = "closeImmediately";
    protected static final String multivaluedUIDs = "multivaluedUIDs";
    private static final String secureConnection = "secureConnection";

    public DicomPropertiesOwner(Properties properties) {
        super(properties);
    }

    public DicomPropertiesOwner(IDicomNode iDicomNode) {
        super(null);
        this.properties.setProperty("calledAET", iDicomNode.getCalledAET());
        if (iDicomNode.getCallingAET() != null) {
            this.properties.setProperty("callingAET", iDicomNode.getCallingAET());
        }
        this.properties.setProperty("host", iDicomNode.getHost());
        this.properties.setProperty("port", Integer.toString(iDicomNode.getPort()));
        this.properties.setProperty(closeImmediately, this.booleanToString(!iDicomNode.isEnabled(NodeProperty.KeepAlive)));
        this.properties.setProperty(secureConnection, this.booleanToString(iDicomNode.isEnabled(NodeProperty.Secure)));
        this.properties.setProperty(multivaluedUIDs, this.booleanToString(iDicomNode.isEnabled(NodeProperty.MultivaluesUIDsSupported)));
        this.properties.setProperty(noExtendedNegotation, this.booleanToString(iDicomNode.isEnabled(NodeProperty.noExtendedNegotiation)));
    }

    public DicomPropertiesOwner(String string, int n, String string2, String string3) {
        super(null);
        this.properties.setProperty("calledAET", string2);
        if (string3 != null) {
            this.properties.setProperty("callingAET", string3);
        }
        this.properties.setProperty("host", string);
        this.properties.setProperty("port", Integer.toString(n));
    }

    public String getCalledAET() {
        return this.properties.getProperty("calledAET");
    }

    public String getCallingAET() {
        return this.properties.getProperty("callingAET");
    }

    public String getHost() {
        return this.properties.getProperty("host");
    }

    public int getPort() {
        return Integer.parseInt(this.properties.getProperty("port"));
    }

    public String[] getMandatoryPropertyList() {
        return new String[]{"calledAET", "host", "port"};
    }

    public String[] getOptionalPropertyList() {
        return new String[]{"callingAET", multivaluedUIDs, closeImmediately, secureConnection, noExtendedNegotation};
    }

    public String[] getValuesForProperty(String string) {
        if (noExtendedNegotation.equals(string)) {
            return booleanValues;
        }
        if (secureConnection.equals(string)) {
            return booleanValues;
        }
        if (closeImmediately.equals(string)) {
            return booleanValues;
        }
        if (multivaluedUIDs.equals(string)) {
            return booleanValues;
        }
        return null;
    }

    public String getDefaultValue(String string) {
        if (noExtendedNegotation.equals(string)) {
            return "false";
        }
        if (secureConnection.equals(string)) {
            return "false";
        }
        if (closeImmediately.equals(string)) {
            return "false";
        }
        if (multivaluedUIDs.equals(string)) {
            return "true";
        }
        return null;
    }

    public boolean isEnabled(NodeProperty nodeProperty) {
        if (nodeProperty == NodeProperty.noExtendedNegotiation) {
            return this.resolveBoolean(noExtendedNegotation);
        }
        if (nodeProperty == NodeProperty.MultivaluesUIDsSupported) {
            return this.resolveBoolean(multivaluedUIDs);
        }
        if (nodeProperty == NodeProperty.Secure) {
            return this.resolveBoolean(secureConnection);
        }
        if (nodeProperty == NodeProperty.KeepAlive) {
            return !this.resolveBoolean(closeImmediately);
        }
        return false;
    }
}

