/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.lw.datainfo.impl;

import com.agfa.pacs.data.lw.datainfo.impl.SeriesInfo;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.data.shared.instanceinfo.Availability;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.lw.impl.IntermediateDataInfo;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.UIDUtils;

public class StudyInfo
extends IntermediateDataInfo
implements IStudyInfo {
    private Availability availability = null;
    private Set<String> modalitiesInStudy;

    public StudyInfo(IDataInfo iDataInfo, Attributes attributes, String string) {
        super(attributes, iDataInfo, string);
    }

    public StudyInfo(IDataInfo iDataInfo, String string) {
        super(iDataInfo, string);
    }

    public List<ISeriesInfo> getSeries() {
        return this.children();
    }

    public String toString() {
        return "    Study (" + this.key + "): " + this.getStudyUID() + "\n" + super.toString();
    }

    public String getStudyUID() {
        return this.getString(0x20000D);
    }

    public String getUID() {
        return this.getString(0x20000D);
    }

    public void setUID(String string) {
        this.dataset.setString(0x20000D, VR.UI, string);
    }

    public Level getLevel() {
        return Level.Study;
    }

    public Availability getAvailability() {
        if (this.availability == null) {
            if (this.childrenAvailable()) {
                Availability availability = Availability.ONLINE;
                for (IDataInfo iDataInfo : this.children()) {
                    if (iDataInfo.getAvailability() == null || availability.compareTo((Enum)iDataInfo.getAvailability()) >= 0) continue;
                    availability = iDataInfo.getAvailability();
                }
                return availability;
            }
            this.availability = Availability.get((Attributes)this.dataset, (String)this.source.getSourceAET());
            if (this.availability == null) {
                this.availability = Availability.ONLINE;
            }
        }
        return this.availability;
    }

    public void setAvailability(Availability availability) {
        this.availability = availability;
        if (availability == Availability.ONLINE) {
            IDataInfo iDataInfo = this.dataset.getStrings(524372);
            Arrays.copyOf(iDataInfo, ((String[])iDataInfo).length + 1);
            iDataInfo[((String[])iDataInfo).length - 1] = this.source.getSourceAET();
            this.dataset.setString(524372, VR.AE, (String[])iDataInfo);
            this.dataset.setString(524374, VR.CS, Availability.ONLINE.dicom());
        }
        if (this.childrenAvailable()) {
            for (IDataInfo iDataInfo : this.children()) {
                Availability availability2 = iDataInfo.getAvailability();
                if (availability.compareTo((Enum)availability2) >= 0) continue;
                ((ISeriesInfo)iDataInfo).setAvailability(availability);
            }
        }
    }

    public void duplicateData() {
        this.dataset = new Attributes(this.dataset);
    }

    public void dispose() {
    }

    public boolean isDisposed() {
        return false;
    }

    public IPatientInfo getPatient() {
        return (IPatientInfo)this.treeParent;
    }

    public ISeriesInfo createSeries(Attributes attributes) {
        return this.createSeries(attributes, UIDUtils.createUID());
    }

    public ISeriesInfo createSeries(String string) {
        SeriesInfo seriesInfo = new SeriesInfo((IDataInfo)this, UIDUtils.createUID());
        seriesInfo.getAttributes().setString(524384, VR.CS, string);
        return this.createSeries(seriesInfo);
    }

    public ISeriesInfo createSeries(Attributes attributes, String string) {
        SeriesInfo seriesInfo = new SeriesInfo((IDataInfo)this, attributes, string);
        return this.createSeries(seriesInfo);
    }

    private int getMaxSeriesNumber() {
        int n = 0;
        for (IDataInfo iDataInfo : this.children()) {
            int n2 = iDataInfo.getInt(0x200011);
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private ISeriesInfo createSeries(ISeriesInfo iSeriesInfo) {
        Date date = new Date();
        iSeriesInfo.setTreeParent((IDataInfo)this);
        iSeriesInfo.getAttributes().setString(0x20000E, VR.UI, iSeriesInfo.getKey());
        iSeriesInfo.getAttributes().setDate(524321, VR.DA, new Date[]{date});
        iSeriesInfo.getAttributes().setDate(524337, VR.TM, new Date[]{date});
        iSeriesInfo.getAttributes().setInt(0x200011, VR.IS, new int[]{this.getMaxSeriesNumber() + 1});
        this.addChild((IDataInfo)iSeriesInfo);
        return iSeriesInfo;
    }

    public Set<String> getModalitiesInStudy() {
        if (this.modalitiesInStudy == null) {
            HashSet<String> hashSet = new HashSet<String>();
            String[] stringArray = this.dataset.getStrings(524385);
            if (stringArray != null) {
                String[] stringArray2 = stringArray;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray2[n2];
                    hashSet.add(string);
                    ++n2;
                }
            }
            this.modalitiesInStudy = hashSet;
        }
        return this.modalitiesInStudy;
    }

    public void deregisterData() {
        throw new UnsupportedOperationException();
    }

    public void registerData() {
        throw new UnsupportedOperationException();
    }

    public Level getHierarchyLevel() {
        return Level.Study;
    }
}

