/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomworklists.mwl;

import com.agfa.pacs.data.dicom.config.DicomConfigurationFactory;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.listtext.dicomobject.mwl.MSPS;
import com.agfa.pacs.listtext.dicomworklists.mwl.DicomMWLCFindSCU;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;

public class ModalityWorkListAccess {
    private DicomMWLCFindSCU cfind;
    private static final ALogger log = ALogger.getLogger(ModalityWorkListAccess.class);
    private final Object lock = new Object();
    private boolean closeImmediately = false;

    public ModalityWorkListAccess(IDicomNode iDicomNode, boolean bl) {
        this.closeImmediately = bl;
        try {
            this.cfind = new DicomMWLCFindSCU(iDicomNode);
        }
        catch (Exception exception) {
            log.error("Error", (Throwable)exception);
        }
    }

    protected void finalize() throws Throwable {
        this.cfind.close();
        super.finalize();
    }

    public void close() {
        try {
            this.cfind.close();
        }
        catch (Exception exception) {
            log.error("Error", (Throwable)exception);
        }
    }

    private void checkConnection() throws Exception {
        if (this.cfind.isConnected()) {
            return;
        }
        this.cfind.connect();
    }

    private void releaseConnection() {
        if (this.closeImmediately) {
            this.close();
        }
    }

    public List<MSPS> queryObjects(MSPS mSPS) throws Exception {
        ArrayList<MSPS> arrayList = new ArrayList<MSPS>();
        List<Attributes> list = this.query(mSPS);
        for (Attributes attributes : list) {
            arrayList.add(new MSPS(attributes));
        }
        return arrayList;
    }

    public List<Attributes> query(MSPS mSPS) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            List<Attributes> list;
            try {
                this.checkConnection();
                Attributes attributes = mSPS.toDataset();
                DicomConfigurationFactory.getConfiguration().checkPutCharacterSet(attributes);
                list = this.cfind.cFind(attributes);
                this.releaseConnection();
            }
            catch (Throwable throwable) {
                this.releaseConnection();
                throw throwable;
            }
            return list;
        }
    }

    public List<MSPS> queryObjects(Attributes attributes) throws Exception {
        ArrayList<MSPS> arrayList = new ArrayList<MSPS>();
        List<Attributes> list = this.query(attributes);
        for (Attributes attributes2 : list) {
            arrayList.add(new MSPS(attributes2));
        }
        return arrayList;
    }

    public List<Attributes> query(Attributes attributes) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            List<Attributes> list;
            try {
                this.checkConnection();
                DicomConfigurationFactory.getConfiguration().checkPutCharacterSet(attributes);
                list = this.cfind.cFind(attributes);
                this.releaseConnection();
            }
            catch (Throwable throwable) {
                this.releaseConnection();
                throw throwable;
            }
            return list;
        }
    }
}

