/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.iod.sr;

import com.agfa.pacs.listtext.dicomobject.CompositeInformationObject;
import com.agfa.pacs.listtext.dicomobject.DicomInformationObject;
import com.agfa.pacs.listtext.dicomobject.DicomInformationObjectException;
import com.agfa.pacs.listtext.dicomobject.DicomInformationObjectFactory;
import com.agfa.pacs.listtext.dicomobject.module.sr.SRDocumentContentModule;
import com.agfa.pacs.listtext.dicomobject.module.sr.SRDocumentGeneralModule;
import com.agfa.pacs.listtext.dicomobject.module.sr.SRDocumentSeriesModule;
import com.agfa.pacs.listtext.dicomobject.sr.content.ContentTemplate;
import com.agfa.pacs.listtext.dicomobject.sr.content.DocumentContent;
import com.agfa.pacs.listtext.dicomobject.sr.content.DocumentRelationship;
import com.agfa.pacs.logging.ALogger;
import java.util.Date;
import org.dcm4che3.data.Attributes;

public class StructuredReportInformationObject
extends CompositeInformationObject {
    private static final ALogger LOG = ALogger.getLogger(StructuredReportInformationObject.class);
    private SRDocumentSeriesModule series;
    private SRDocumentGeneralModule general;
    private SRDocumentContentModule content;

    @Override
    public void init(boolean bl) {
        super.init(bl);
        this.series = this.getModule(SRDocumentSeriesModule.class);
        this.general = this.getModule(SRDocumentGeneralModule.class);
        this.content = this.getModule(SRDocumentContentModule.class);
        if (bl) {
            this.series.setModality("SR");
            Date date = new Date();
            this.general.setContentDate(date);
            this.general.setContentTime(date);
        }
    }

    public DocumentContent getDocumentContent() {
        return this.content.getDocumentContent();
    }

    public DocumentRelationship getDocumentRelationship() {
        return this.content.getDocumentRelationship();
    }

    public void setDocumentContent(DocumentContent documentContent) {
        this.content.setDocumentContent(documentContent);
    }

    public void setDocumentRelationship(DocumentRelationship documentRelationship) {
        this.content.setDocumentRelationship(documentRelationship);
    }

    public SRDocumentGeneralModule getGeneral() {
        return this.general;
    }

    public SRDocumentSeriesModule getSeries() {
        return this.series;
    }

    public SRDocumentContentModule getContent() {
        return this.content;
    }

    public ContentTemplate getContentTemplate() {
        return ((DocumentContent.ContainerContent)this.content.getDocumentContent()).getContentTemplate();
    }

    public static StructuredReportInformationObject createInstance(Attributes attributes) {
        try {
            return (StructuredReportInformationObject)DicomInformationObjectFactory.getInstance().createDicomInformationObject(attributes);
        }
        catch (DicomInformationObjectException dicomInformationObjectException) {
            LOG.error("Error creating instance", (Throwable)dicomInformationObjectException);
            return null;
        }
    }

    public static StructuredReportInformationObject createBasicTextSR(DicomInformationObject dicomInformationObject) {
        try {
            return (StructuredReportInformationObject)DicomInformationObjectFactory.getInstance().createDicomInformationObject("1.2.840.10008.5.1.4.1.1.88.11", dicomInformationObject);
        }
        catch (DicomInformationObjectException dicomInformationObjectException) {
            LOG.error("Error creating instance", (Throwable)dicomInformationObjectException);
            return null;
        }
    }

    public static StructuredReportInformationObject createEnhancedSR(DicomInformationObject dicomInformationObject) {
        try {
            return (StructuredReportInformationObject)DicomInformationObjectFactory.getInstance().createDicomInformationObject("1.2.840.10008.5.1.4.1.1.88.22", dicomInformationObject);
        }
        catch (DicomInformationObjectException dicomInformationObjectException) {
            LOG.error("Error creating instance", (Throwable)dicomInformationObjectException);
            return null;
        }
    }

    public static StructuredReportInformationObject createComprehensiveSR(DicomInformationObject dicomInformationObject) {
        try {
            return (StructuredReportInformationObject)DicomInformationObjectFactory.getInstance().createDicomInformationObject("1.2.840.10008.5.1.4.1.1.88.33", dicomInformationObject);
        }
        catch (DicomInformationObjectException dicomInformationObjectException) {
            LOG.error("Error creating instance", (Throwable)dicomInformationObjectException);
            return null;
        }
    }
}

