/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export.internal;

import com.agfa.pacs.data.dicom.DicomException;
import com.agfa.pacs.data.dicom.comm.DicomNServiceSCU;
import com.agfa.pacs.data.dicom.transfercapability.ITransferCapabilityProvider;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.dicom.UIDMap;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.net.pdu.ExtendedNegotiation;

public class NServiceSCU
extends DicomNServiceSCU {
    private static UIDMap initUIDMap() {
        ArrayList<String> arrayList = new ArrayList<String>(2);
        arrayList.add("1.2.840.10008.3.1.2.3.3");
        arrayList.add("1.2.840.10008.3.1.2.3.4");
        return NServiceSCU.initUIDMap(arrayList);
    }

    private static UIDMap initUIDMap(Collection<String> collection) {
        UIDMap uIDMap = new UIDMap();
        for (String string : collection) {
            uIDMap.addTransferSyntaxUIDs(string, (Collection)UIDUtilities.getDefaultTransferSyntaxUIDs());
        }
        return uIDMap;
    }

    public NServiceSCU(IDicomNode iDicomNode, Collection<String> collection) throws DicomException {
        super(iDicomNode);
        this.addTransferCapabilities(NServiceSCU.initUIDMap(collection));
    }

    public void nSet(String string, String string2, Attributes attributes) throws DicomException {
        super.nSet(null, string, string2, attributes);
    }

    public Attributes nGet(String string, String string2) throws DicomException {
        return super.nGet(null, string, string2);
    }

    public Attributes nCreate(String string, String string2, Attributes attributes) throws DicomException {
        return super.nCreate(null, string, string2, attributes);
    }

    public static class TransferCapabilityProvider
    implements ITransferCapabilityProvider {
        public List<TransferCapability> getTransferCapabilities() {
            return NServiceSCU.initUIDMap().getTransferCapabilities(false);
        }

        public List<ExtendedNegotiation> getExtendedNegotiation() {
            return Collections.emptyList();
        }
    }
}

