/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export.internal;

import com.agfa.pacs.data.dicom.DicomException;
import com.agfa.pacs.data.export.internal.NServiceSCU;
import com.agfa.pacs.data.shared.NodeProperty;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.export.IProcessingElement;
import com.agfa.pacs.data.shared.export.ProcessingProperty;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;

public abstract class NService
implements IProcessingElement {
    private static final ALogger log = ALogger.getLogger(NService.class);
    public static final String DICOM_STORE_TARGET = "DICOM_STORE_TARGET";
    protected IDicomNode dicomNode;
    protected NServiceSCU nService;
    protected Collection<String> uidMap;

    public ProcessingProperty[] queryProperties() {
        return null;
    }

    public void prepareProcessing(Properties properties, List<? extends Object> list) {
        if (!properties.containsKey(DICOM_STORE_TARGET)) {
            throw new IllegalArgumentException("No target specified");
        }
        this.dicomNode = (IDicomNode)properties.get(DICOM_STORE_TARGET);
        this.uidMap = properties.containsKey("SOPClasses") ? (Collection<Object>)properties.get("SOPClasses") : new ArrayList<String>();
    }

    public void cleanUp() {
        this.nService = null;
    }

    public void finishProcessing() {
    }

    public String getErrorMessage() {
        return null;
    }

    public boolean supportsConcurrentProcessing() {
        return false;
    }

    protected void checkConnection() throws DicomException {
        if (this.nService == null) {
            this.nService = new NServiceSCU(this.dicomNode, this.uidMap);
        }
        if (this.nService.isConnected()) {
            return;
        }
        this.nService.connect();
    }

    protected void releaseConnection() {
        if (!this.dicomNode.isEnabled(NodeProperty.KeepAlive) && this.nService != null) {
            try {
                this.nService.close();
            }
            catch (DicomException dicomException) {
                log.error("close", (Throwable)dicomException);
            }
        }
    }
}

