/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export.internal;

import com.agfa.pacs.data.export.internal.IDataSink;
import com.agfa.pacs.logging.ALogger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class FileSourceDataSink
implements IDataSink {
    private File destinationDirectory;
    private String suffix = null;
    private static final ALogger log = ALogger.getLogger(FileSourceDataSink.class);
    private Map<String, OutputStream> map;
    private Map<String, File> fileMap = null;

    public FileSourceDataSink(File file, String string, Map<String, File> map) {
        this.destinationDirectory = file;
        this.suffix = string;
        this.map = new HashMap<String, OutputStream>();
        this.fileMap = map;
    }

    @Override
    public OutputStream getOutputStream(String string, String[] stringArray) {
        File file;
        block4: {
            try {
                file = this.getFile(string, stringArray);
                file.getParentFile().mkdirs();
                if (file.getParentFile().exists()) break block4;
                return null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                log.error("Could not get Output stream", (Throwable)fileNotFoundException);
                return null;
            }
        }
        if (this.fileMap != null) {
            this.fileMap.put(string, file);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        this.map.put(string, bufferedOutputStream);
        return bufferedOutputStream;
    }

    @Override
    public void closeOutputStream(String string) {
        try {
            OutputStream outputStream = this.map.remove(string);
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            log.error("Could not close stream", (Throwable)iOException);
        }
    }

    protected File getFile(String string, String[] stringArray) {
        File file = this.destinationDirectory;
        int n = 0;
        while (n < stringArray.length - 1) {
            file = new File(file, stringArray[n]);
            ++n;
        }
        file = new File(file, String.valueOf(stringArray[stringArray.length - 1]) + (this.suffix != null ? "." + this.suffix : ""));
        return file;
    }
}

