/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export.blackening;

import com.agfa.pacs.data.export.blackening.BlackeningBox;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BlackeningInfo {
    public static final String BLACKENING_INFO = "blackeningInfo";
    protected static final String FRAME_SEPARATOR = "_";
    protected Map<String, List<BlackeningBox>> imageBlackening = new HashMap<String, List<BlackeningBox>>();
    protected Map<String, List<BlackeningBox>> seriesBlackening = new HashMap<String, List<BlackeningBox>>();

    public List<BlackeningBox> getBlackening(IObjectInfo iObjectInfo, int n) {
        List<BlackeningBox> list = this.imageBlackening.get(String.valueOf(this.getObjectKey(iObjectInfo)) + FRAME_SEPARATOR + n);
        List<BlackeningBox> list2 = this.seriesBlackening.get(iObjectInfo.getSeries().getKey());
        if (list2 == null) {
            if (list == null) {
                return Collections.emptyList();
            }
            return list;
        }
        if (list == null) {
            return list2;
        }
        ArrayList<BlackeningBox> arrayList = new ArrayList<BlackeningBox>(list.size() + list2.size());
        arrayList.addAll(list);
        arrayList.addAll(list2);
        return arrayList;
    }

    public boolean containsBlackening() {
        return this.imageBlackening.size() + this.seriesBlackening.size() > 0;
    }

    public void addBlackeningForSeries(ISeriesInfo iSeriesInfo, BlackeningBox blackeningBox) {
        List<BlackeningBox> list = this.seriesBlackening.get(iSeriesInfo.getKey());
        if (list == null) {
            list = new ArrayList<BlackeningBox>(5);
            this.seriesBlackening.put(iSeriesInfo.getKey(), list);
        }
        list.add(blackeningBox);
    }

    public void addBlackeningForObject(IObjectInfo iObjectInfo, int n, BlackeningBox blackeningBox) {
        String string = String.valueOf(this.getObjectKey(iObjectInfo)) + FRAME_SEPARATOR + n;
        List<BlackeningBox> list = this.imageBlackening.get(string);
        if (list == null) {
            list = new ArrayList<BlackeningBox>(5);
            this.imageBlackening.put(string, list);
        }
        list.add(blackeningBox);
    }

    protected String getObjectKey(IObjectInfo iObjectInfo) {
        String string = iObjectInfo.getKey();
        if (string.contains(FRAME_SEPARATOR)) {
            return string.substring(0, string.indexOf(FRAME_SEPARATOR));
        }
        return string;
    }
}

