/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export;

import com.agfa.pacs.data.export.ImageObject;
import com.agfa.pacs.data.export.ImageObjectDicomDataListener;
import com.agfa.pacs.data.export.ProcessingExceptionMessageFactory;
import com.agfa.pacs.data.shared.data.DatasetDicomDataReader;
import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.dicom.UIDMap;
import com.agfa.pacs.data.shared.export.IProcessingElement;
import com.agfa.pacs.data.shared.export.ProcessingException;
import com.agfa.pacs.data.shared.export.ProcessingProperty;
import java.util.List;
import java.util.Properties;
import org.dcm4che3.data.Attributes;

public class DicomProcessor
implements IProcessingElement {
    public void prepareProcessing(Properties properties, List<? extends Object> list) {
        UIDMap uIDMap = (UIDMap)properties.get("UID_MAP");
        if (uIDMap == null) {
            uIDMap = new UIDMap();
            properties.put("UID_MAP", uIDMap);
        }
        if (list != null) {
            for (Object object : list) {
                if (!(object instanceof Attributes)) continue;
                Attributes attributes = (Attributes)object;
                String string = attributes.getString(131088);
                if (string != null) {
                    uIDMap.addTransferSyntaxUID(attributes.getString(524310), string);
                    continue;
                }
                uIDMap.addClassUID(attributes.getString(524310));
            }
        }
    }

    public Object process(Object object) throws ProcessingException {
        if (!(object instanceof Attributes)) {
            throw new IllegalArgumentException("Wrong input type");
        }
        Attributes attributes = (Attributes)object;
        ImageObject imageObject = new ImageObject();
        DatasetDicomDataReader datasetDicomDataReader = new DatasetDicomDataReader(attributes, (IDicomDataListener)new ImageObjectDicomDataListener(imageObject));
        datasetDicomDataReader.run();
        if (imageObject.isFailed()) {
            throw new ProcessingException("Error retrieving object " + attributes.getString(524312), ProcessingExceptionMessageFactory.getProcessingExceptionMessage("export.errorLoadingData", attributes, null));
        }
        return imageObject;
    }

    public void cleanUp() {
    }

    public void finishProcessing() {
    }

    public String getErrorMessage() {
        return null;
    }

    public ProcessingProperty[] queryProperties() {
        return null;
    }

    public boolean supportsConcurrentProcessing() {
        return true;
    }
}

