/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export;

import com.agfa.pacs.auditing.Audit;
import com.agfa.pacs.base.ProgressState;
import com.agfa.pacs.data.dicom.DicomException;
import com.agfa.pacs.data.dicom.ICMoveSCU;
import com.agfa.pacs.data.dicom.ICMoveSCUListener;
import com.agfa.pacs.data.dicom.QueryRetrieveLevel;
import com.agfa.pacs.data.dicom.comm.DicomCompositeCMoveSCU;
import com.agfa.pacs.data.shared.JobState;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.util.WaitCancelable;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;

public class DicomCMove {
    private static final ALogger log = ALogger.getLogger(DicomCMove.class);
    private static final int AET_TITLE_NOT_FOUND_STATUS = 272;

    public static WaitCancelable moveInstances(IDicomNode iDicomNode, String string, List<IDataInfo> list, ProgressState progressState) throws DicomException {
        return DicomCMove.moveInstancesImpl(iDicomNode, string, list, progressState);
    }

    private static MoveListener moveInstancesImpl(IDicomNode iDicomNode, String string, List<? extends IDataInfo> list, ProgressState progressState) throws DicomException {
        DicomCompositeCMoveSCU dicomCompositeCMoveSCU = null;
        ArrayList<Attributes> arrayList = new ArrayList<Attributes>();
        for (IDataInfo iDataInfo : list) {
            arrayList.add(iDataInfo.getAttributes());
        }
        Audit.getInstance().logBeginSendDICOMInstances(iDicomNode.toString(), iDicomNode.getHost(), string, arrayList);
        list = DicomCMove.reduceDataset(list);
        dicomCompositeCMoveSCU = new DicomCompositeCMoveSCU(iDicomNode, DicomCompositeCMoveSCU.DefaultRetrieveClassUIDs);
        MoveListener moveListener = new MoveListener(progressState, (ICMoveSCU)dicomCompositeCMoveSCU);
        dicomCompositeCMoveSCU.connect();
        for (IDataInfo iDataInfo : list) {
            if (moveListener.getLastError() != 0 || moveListener.isCanceled()) break;
            if (iDataInfo instanceof IStudyInfo) {
                DicomCMove.sendStudy(dicomCompositeCMoveSCU, string, moveListener, iDataInfo);
            }
            if (iDataInfo instanceof ISeriesInfo) {
                DicomCMove.sendSerie(dicomCompositeCMoveSCU, string, moveListener, iDataInfo);
            }
            if (!(iDataInfo instanceof IObjectInfo)) continue;
            DicomCMove.sendObject(dicomCompositeCMoveSCU, string, moveListener, iDataInfo);
        }
        return moveListener;
    }

    public static MOVE_RESULT moveInstancesSync(IDicomNode iDicomNode, String string, List<? extends IDataInfo> list, ProgressState progressState) {
        MoveListener moveListener;
        try {
            moveListener = DicomCMove.moveInstancesImpl(iDicomNode, string, list, progressState);
        }
        catch (DicomException dicomException) {
            log.error("Move failed", (Throwable)dicomException);
            return MOVE_RESULT.MOVE_FAILED;
        }
        moveListener.waitUntilFinished();
        ArrayList<Attributes> arrayList = new ArrayList<Attributes>();
        for (IDataInfo iDataInfo : list) {
            arrayList.add(iDataInfo.getAttributes());
        }
        Audit.getInstance().logSendedDICOMInstances(iDicomNode.toString(), iDicomNode.getHost(), iDicomNode.getCalledAET(), arrayList);
        int n = moveListener.getLastError();
        if (n == 272) {
            return MOVE_RESULT.MOVE_NOT_CONFIGURED;
        }
        if (n != 0) {
            return MOVE_RESULT.MOVE_FAILED;
        }
        return MOVE_RESULT.MOVE_SUCCESFULL;
    }

    public static List<IDataInfo> reduceDataset(List<? extends IDataInfo> list) {
        HashMap<String, IDataInfo> hashMap = new HashMap<String, IDataInfo>();
        HashMap<String, IDataInfo> hashMap2 = new HashMap<String, IDataInfo>();
        for (IDataInfo object2 : list) {
            hashMap.put(object2.getKey(), object2);
        }
        while (hashMap.size() > 0) {
            IDataInfo iDataInfo = (IDataInfo)hashMap.values().iterator().next();
            if (iDataInfo.getHierarchyLevel() == Level.Study || iDataInfo.getHierarchyLevel() == Level.Patient) {
                hashMap2.put(iDataInfo.getKey(), iDataInfo);
                hashMap.remove(iDataInfo.getKey());
                continue;
            }
            IDataInfo iDataInfo2 = iDataInfo.getTreeParent();
            if (hashMap2.containsKey(iDataInfo2.getKey()) || hashMap.containsKey(iDataInfo2.getKey())) {
                hashMap.remove(iDataInfo.getKey());
                continue;
            }
            List list2 = iDataInfo2.children();
            int n = 0;
            for (IDataInfo iDataInfo3 : list2) {
                if (!hashMap2.containsKey(iDataInfo3.getKey()) && !hashMap.containsKey(iDataInfo3.getKey())) break;
                ++n;
            }
            if (list2.size() == n && list2.size() > 1) {
                hashMap2.put(iDataInfo2.getKey(), iDataInfo2);
                for (IDataInfo iDataInfo3 : list2) {
                    hashMap2.remove(iDataInfo3.getKey());
                    hashMap.remove(iDataInfo3.getKey());
                }
                continue;
            }
            hashMap.remove(iDataInfo.getKey());
            hashMap2.put(iDataInfo.getKey(), iDataInfo);
        }
        ArrayList<IDataInfo> arrayList = new ArrayList<IDataInfo>();
        arrayList.addAll(hashMap2.values());
        return arrayList;
    }

    private static void sendObject(DicomCompositeCMoveSCU dicomCompositeCMoveSCU, String string, MoveListener moveListener, IDataInfo iDataInfo) throws DicomException {
        Attributes attributes = new Attributes();
        attributes.setString(524312, VR.UI, iDataInfo.getString(524312));
        attributes.setString(0x20000E, VR.UI, iDataInfo.getString(0x20000E));
        attributes.setString(0x20000D, VR.UI, iDataInfo.getString(0x20000D));
        dicomCompositeCMoveSCU.move(string, attributes, QueryRetrieveLevel.Image, (ICMoveSCUListener)moveListener);
    }

    private static void sendSerie(DicomCompositeCMoveSCU dicomCompositeCMoveSCU, String string, MoveListener moveListener, IDataInfo iDataInfo) throws DicomException {
        Attributes attributes = new Attributes();
        attributes.setString(0x20000E, VR.UI, iDataInfo.getString(0x20000E));
        attributes.setString(0x20000D, VR.UI, iDataInfo.getString(0x20000D));
        dicomCompositeCMoveSCU.move(string, attributes, QueryRetrieveLevel.Series, (ICMoveSCUListener)moveListener);
    }

    private static void sendStudy(DicomCompositeCMoveSCU dicomCompositeCMoveSCU, String string, MoveListener moveListener, IDataInfo iDataInfo) throws DicomException {
        Attributes attributes = new Attributes();
        attributes.setString(0x20000D, VR.UI, iDataInfo.getString(0x20000D));
        dicomCompositeCMoveSCU.move(string, attributes, QueryRetrieveLevel.Study, (ICMoveSCUListener)moveListener);
    }

    public static enum MOVE_RESULT {
        MOVE_SUCCESFULL,
        MOVE_FAILED,
        MOVE_NOT_CONFIGURED;

    }

    private static class MoveListener
    implements ICMoveSCUListener,
    WaitCancelable {
        private int count = Integer.MAX_VALUE;
        private int allCount;
        private Object mutex = new Object();
        private int lastError = 0;
        private boolean canceled = false;
        private ProgressState ps;
        private ICMoveSCU cmove = null;

        public MoveListener(ProgressState progressState, ICMoveSCU iCMoveSCU) {
            this.cmove = iCMoveSCU;
            this.ps = progressState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cmoveFinished(int n, Integer n2, Integer n3) {
            if (n != 0 && n != 65280) {
                this.lastError = n;
                if (this.cmove != null) {
                    try {
                        this.cmove.close();
                    }
                    catch (DicomException dicomException) {
                        log.warn("DICOM Closing:", (Throwable)dicomException);
                    }
                }
                this.count = 0;
                if (this.ps != null) {
                    this.ps.setState(JobState.FAILED);
                }
            } else {
                if (n == 0) {
                    n2 = 0;
                }
                if (n2 != null) {
                    this.count = n2;
                    if (n3 != null) {
                        this.allCount = n3 + n2;
                    }
                } else {
                    --this.count;
                }
            }
            if (this.ps != null) {
                this.ps.setProgress((float)(this.allCount - this.count) / (float)this.allCount);
            }
            if (this.count <= 0) {
                if (this.cmove != null) {
                    try {
                        this.cmove.close();
                    }
                    catch (DicomException dicomException) {
                        log.warn("DICOM Closing:", (Throwable)dicomException);
                    }
                }
                if (this.ps != null) {
                    this.ps.setProgress(1.0f);
                    this.ps.setState(JobState.FINISHED);
                }
                Object object = this.mutex;
                synchronized (object) {
                    this.mutex.notifyAll();
                }
            }
        }

        public int getLastError() {
            return this.lastError;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitUntilFinished() {
            while (this.count > 0 && !this.canceled) {
                Object object = this.mutex;
                synchronized (object) {
                    try {
                        this.mutex.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        log.error("Interrupted", (Throwable)interruptedException);
                    }
                }
            }
            return;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitUntilFinished(int n) {
            while (this.count > 0 && !this.canceled) {
                Object object = this.mutex;
                synchronized (object) {
                    try {
                        this.mutex.wait(n);
                    }
                    catch (InterruptedException interruptedException) {
                        log.error("Interrupted:", (Throwable)interruptedException);
                    }
                }
            }
            return;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public void cancel() {
            this.canceled = true;
        }

        public boolean isRunning() {
            return this.count > 0;
        }
    }
}

