/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export;

import com.agfa.pacs.background.BackgroundTaskEngineFactory;
import com.agfa.pacs.background.IBackgroundProgress;
import com.agfa.pacs.background.IBackgroundTask;
import com.agfa.pacs.background.IProgressListener;
import com.agfa.pacs.background.IScheduledBackgroundTask;
import com.agfa.pacs.base.ProgressState;
import com.agfa.pacs.base.ProgressState2Task;
import com.agfa.pacs.data.export.DicomCMove;
import com.agfa.pacs.data.export.Messages;
import com.agfa.pacs.data.shared.NodeProperty;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.export.IFollowUpTaskRegistry;
import com.agfa.pacs.data.shared.export.IProcessingElement;
import com.agfa.pacs.data.shared.export.ProcessingException;
import com.agfa.pacs.data.shared.export.ProcessingProperty;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import org.dcm4che3.util.UIDUtils;

public class CMove
implements IProcessingElement,
IBackgroundTask {
    private static final ALogger LOG = ALogger.getLogger(CMove.class);
    public static final String FOLLOW_UP_TASK_REGISTRY = "FOLLOW_UP_TASK_REGISTRY";
    private final String uid = UIDUtils.createUID();
    private final Queue<IDataInfo> toProcess = new ArrayDeque<IDataInfo>();
    private final Object notification = new Object();
    private final Set<String> toBeProcessed = Collections.synchronizedSet(new HashSet());
    private String targetAE;
    private final Semaphore toStart = new Semaphore(1);
    private final CountDownLatch started = new CountDownLatch(1);
    private IBackgroundProgress progress;
    private String error = null;
    private volatile boolean canceled = false;
    IDicomNode dicomNode;
    private IFollowUpTaskRegistry followUpTaskRegistry = null;

    public void prepareProcessing(Properties properties, List<? extends Object> list) {
        Object object2;
        List list22;
        ArrayList<? extends Object> arrayList = new ArrayList<Object>(list);
        List list3 = DataInfoUtilities.getLevel(list, IStudyInfo.class);
        for (List list22 : list3) {
            int n = DataInfoUtilities.extractChildrenBelongingToParent((IDataInfo)list22, arrayList).size();
            if (list22.getInt(2101768) != n) continue;
            this.toProcess.add((IDataInfo)list22);
            arrayList.removeAll(DataInfoUtilities.extractChildrenBelongingToParent((IDataInfo)list22, arrayList));
        }
        list22 = DataInfoUtilities.getLevel(arrayList, ISeriesInfo.class);
        for (Object object2 : list22) {
            int n = DataInfoUtilities.extractChildrenBelongingToParent((IDataInfo)object2, arrayList).size();
            if (object2.getInt(2101769) != n) {
                this.toProcess.addAll(DataInfoUtilities.extractChildrenBelongingToParent((IDataInfo)object2, list));
                continue;
            }
            this.toProcess.add((IDataInfo)object2);
            arrayList.removeAll(DataInfoUtilities.extractChildrenBelongingToParent((IDataInfo)object2, arrayList));
        }
        this.targetAE = ((IDicomNode)properties.get("DICOM_STORE_TARGET")).getCalledAET();
        object2 = list;
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            IObjectInfo iObjectInfo = (IObjectInfo)iterator.next();
            this.toBeProcessed.add(this.getKey((IDataInfo)iObjectInfo));
        }
        if (properties.containsKey(FOLLOW_UP_TASK_REGISTRY)) {
            this.followUpTaskRegistry = (IFollowUpTaskRegistry)properties.get(FOLLOW_UP_TASK_REGISTRY);
        }
        if (properties.containsKey("DICOM_STORE_TARGET")) {
            this.dicomNode = (IDicomNode)properties.get("DICOM_STORE_TARGET");
        }
    }

    public void finishProcessing() {
    }

    public void cleanUp() {
        this.toBeProcessed.clear();
        this.toProcess.clear();
        this.dicomNode = null;
    }

    private String getKey(IDataInfo iDataInfo) {
        return String.valueOf(iDataInfo.getKey()) + iDataInfo.getHierarchyLevel().dicom();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object process(Object object) throws ProcessingException {
        if (!(object instanceof IDataInfo)) {
            throw new IllegalArgumentException("Wrong type");
        }
        if (this.toStart.tryAcquire()) {
            this.startProcessing();
            this.started.countDown();
        }
        try {
            this.started.await();
        }
        catch (InterruptedException interruptedException) {
            LOG.error("Start waiting problem", (Throwable)interruptedException);
        }
        String string = this.getKey((IDataInfo)object);
        Object object2 = this.notification;
        synchronized (object2) {
            while (this.toBeProcessed.contains(string)) {
                try {
                    this.notification.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.error != null) {
            throw new ProcessingException(this.error, Messages.getString("CStore.Fail"));
        }
        return ((IDataInfo)object).getDicomObjectMerged();
    }

    private void startProcessing() {
        IProgressListener iProgressListener = null;
        if (this.followUpTaskRegistry != null) {
            iProgressListener = this.followUpTaskRegistry.registerFollowUpTask((IBackgroundTask)this);
        }
        IScheduledBackgroundTask iScheduledBackgroundTask = BackgroundTaskEngineFactory.getInstance().placeBackgroundTask((IBackgroundTask)this, iProgressListener);
        if (this.followUpTaskRegistry != null) {
            this.followUpTaskRegistry.registerScheduledFollowUpTask(iScheduledBackgroundTask);
        }
    }

    public ProcessingProperty[] queryProperties() {
        return null;
    }

    public String getErrorMessage() {
        return this.error;
    }

    public boolean supportsConcurrentProcessing() {
        return true;
    }

    public String getUID() {
        return this.uid;
    }

    public String getInfo() {
        return "C-Move";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() {
        IDataInfo iDataInfo = this.toProcess.poll();
        while (iDataInfo != null) {
            if (this.canceled) break;
            ProgressState2Task progressState2Task = new ProgressState2Task(this.progress, null);
            CallingDicomNode callingDicomNode = new CallingDicomNode((IDicomNode)iDataInfo.getSource().getIdentifier(), this.dicomNode != null ? this.dicomNode.getCallingAET() : null);
            DicomCMove.MOVE_RESULT mOVE_RESULT = DicomCMove.moveInstancesSync(callingDicomNode, this.targetAE, Collections.singletonList(iDataInfo), (ProgressState)progressState2Task);
            if (mOVE_RESULT != DicomCMove.MOVE_RESULT.MOVE_SUCCESFULL) {
                this.error = "C-Move fails for:" + iDataInfo.getKey() + " " + (Object)((Object)mOVE_RESULT);
                LOG.error(this.error);
            }
            Object object = this.notification;
            synchronized (object) {
                for (IObjectInfo iObjectInfo : DataInfoUtilities.getLevel((IDataInfo)iDataInfo, IObjectInfo.class)) {
                    this.toBeProcessed.remove(this.getKey((IDataInfo)iObjectInfo));
                }
                this.notification.notifyAll();
            }
            iDataInfo = this.toProcess.poll();
        }
        if (this.canceled) {
            return false;
        }
        return this.error == null;
    }

    public void terminate() {
        this.canceled = true;
    }

    public void take(IBackgroundProgress iBackgroundProgress) {
        this.progress = iBackgroundProgress;
    }

    private static class CallingDicomNode
    implements IDicomNode {
        private final IDicomNode deligate;
        private final String callingAET;

        public CallingDicomNode(IDicomNode iDicomNode, String string) {
            this.deligate = iDicomNode;
            this.callingAET = string;
        }

        public String getCalledAET() {
            return this.deligate.getCalledAET();
        }

        public String getCallingAET() {
            if (this.callingAET != null) {
                return this.callingAET;
            }
            return this.deligate.getCallingAET();
        }

        public String getHost() {
            return this.deligate.getHost();
        }

        public int getPort() {
            return this.deligate.getPort();
        }

        public boolean isEnabled(NodeProperty nodeProperty) {
            return this.deligate.isEnabled(nodeProperty);
        }
    }
}

