/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.export;

import com.agfa.pacs.auditing.Audit;
import com.agfa.pacs.core.ApplicationManagement;
import com.agfa.pacs.core.ApplicationType;
import com.agfa.pacs.data.export.ImageObject;
import com.agfa.pacs.data.shared.code.CodeDictionary;
import com.agfa.pacs.data.shared.export.IProcessingElement;
import com.agfa.pacs.data.shared.export.ProcessingProperty;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.store.ISendNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.dcm4che3.audit.AuditMessage;
import org.dcm4che3.audit.AuditMessages;
import org.dcm4che3.data.Attributes;

public class AuditProcessor
implements IProcessingElement {
    public static final String AUDIT_OPERATION = "AUDIT_OPERATION";
    public static final String AUDIT_IMPORT_SOURCE = "AUDIT_IMPORT_SOURCE";
    public static final String AUDIT_EXPORT_TARGET = "AUDIT_EXPORT_TARGET";
    public static final String SECONDARY_CAPTURE_INCLUDED_IN_ANONYMIZED_EXPORT = "SECONDARY_CAPTURE_INCLUDED_IN_ANONYMIZED_EXPORT";
    private static final AuditMessages.EventTypeCode SECONDARY_CAPTURE_INCLUDED_IN_ANONYMIZED_EXPORT_TYPE_CODE = new AuditMessages.EventTypeCode(CodeDictionary.AgfaAuditEventTypeCodes.IncludeSecondaryCapturesInAnonymizedExport.getCodeValue(), CodeDictionary.AgfaAuditEventTypeCodes.IncludeSecondaryCapturesInAnonymizedExport.getCodingSchemeDesignator(), CodeDictionary.AgfaAuditEventTypeCodes.IncludeSecondaryCapturesInAnonymizedExport.getCodeMeaning());
    private static final int[] TAGS_FOR_AUDITING = new int[]{524368, 0x100010, 0x100020, 0x100021, 0x20000D};
    private AuditEvent operation = null;
    private List<Attributes> instances = null;
    private ISendNode targetNode;
    private Set<String> processedStudies;
    private boolean captureInstances = false;
    private String sourceTarget;
    private boolean auditMessageSent = false;
    private boolean isSecondaryCaptureIncludedInAnonymizedExport;

    public void prepareProcessing(Properties properties, List<? extends Object> list) {
        if (properties.containsKey(AUDIT_OPERATION)) {
            this.operation = AuditEvent.valueOf(properties.getProperty(AUDIT_OPERATION));
        }
        ArrayList<IDataInfo> arrayList = new ArrayList<IDataInfo>();
        for (Object object : list) {
            if (!(object instanceof IDataInfo)) continue;
            arrayList.add((IDataInfo)object);
        }
        if (!arrayList.isEmpty()) {
            this.instances = ApplicationManagement.getInstance().getApplicationType() == ApplicationType.Agility ? DataInfoUtilities.forInstanceLevelAuditing(arrayList) : DataInfoUtilities.forAuditing(arrayList);
        } else {
            this.processedStudies = Collections.synchronizedSet(new HashSet());
            this.instances = new ArrayList<Attributes>();
            this.captureInstances = true;
        }
        if (this.operation == AuditEvent.DicomSend) {
            this.targetNode = (ISendNode)properties.get("DICOM_STORE_TARGET");
            if (this.instances == null) {
                throw new UnsupportedOperationException();
            }
            Audit.getInstance().logBeginSendDICOMInstances(this.targetNode.toString(), this.targetNode.getHost(), this.targetNode.getCalledAET(), this.instances);
        } else if (this.operation == AuditEvent.Export) {
            this.sourceTarget = properties.getProperty(AUDIT_EXPORT_TARGET, "");
        } else if (this.operation == AuditEvent.Import) {
            this.sourceTarget = properties.getProperty(AUDIT_IMPORT_SOURCE, "");
        }
        if (properties.containsKey(SECONDARY_CAPTURE_INCLUDED_IN_ANONYMIZED_EXPORT)) {
            this.isSecondaryCaptureIncludedInAnonymizedExport = (Boolean)properties.get(SECONDARY_CAPTURE_INCLUDED_IN_ANONYMIZED_EXPORT);
        }
    }

    public void finishProcessing() {
        this.sendAuditMessage("0");
    }

    private synchronized void sendAuditMessage(String string) {
        if (this.auditMessageSent) {
            return;
        }
        this.auditMessageSent = true;
        AuditMessage auditMessage = null;
        if (this.operation == AuditEvent.DicomSend) {
            auditMessage = Audit.getInstance().logSendedDICOMInstances(this.targetNode.toString(), this.targetNode.getHost(), this.targetNode.getCalledAET(), this.instances);
        } else if (this.operation == AuditEvent.Import) {
            auditMessage = Audit.getInstance().logDataImport(this.instances, this.sourceTarget);
        } else if (this.operation == AuditEvent.Export) {
            auditMessage = Audit.getInstance().logDataExport(this.instances, this.sourceTarget);
        }
        if (auditMessage != null) {
            if (this.isSecondaryCaptureIncludedInAnonymizedExport) {
                auditMessage.getEventIdentification().getEventTypeCode().add(SECONDARY_CAPTURE_INCLUDED_IN_ANONYMIZED_EXPORT_TYPE_CODE);
            }
            Audit.getInstance().logAuditMessage(auditMessage, string);
        }
    }

    public void cleanUp() {
        this.sendAuditMessage("8");
        this.instances = null;
        this.processedStudies = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object process(Object object) {
        if (this.captureInstances && object instanceof ImageObject) {
            ImageObject imageObject = (ImageObject)object;
            String string = imageObject.getDataset().getString(0x20000D);
            if (!this.processedStudies.contains(string)) {
                AuditProcessor auditProcessor = this;
                synchronized (auditProcessor) {
                    if (!this.processedStudies.contains(string)) {
                        this.instances.add(new Attributes(imageObject.getDataset(), TAGS_FOR_AUDITING));
                        this.processedStudies.add(string);
                    }
                }
            }
        } else if (this.captureInstances) {
            throw new IllegalArgumentException("Wrong input type");
        }
        return object;
    }

    public ProcessingProperty[] queryProperties() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public boolean supportsConcurrentProcessing() {
        return true;
    }

    public static enum AuditEvent {
        DicomSend,
        Export,
        Import;

    }
}

