/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.cycling.prefs;

import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.config.ConfigUtilities;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.listtext.cycling.prefs.ICycleListPreferences;
import com.agfa.pacs.listtext.lta.util.referencedobject.IReferencedObjectProvider;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferringObjectType;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class CycleListPreferences
implements ICycleListPreferences {
    private static final String CONFIG_PATH = "listtext.cyclelist.prefsXML";
    private static final ALogger log = ALogger.getLogger(CycleListPreferences.class);
    private List<ReferringObjectType> prefTypes;
    private boolean prefLoadingEnabled = true;

    public CycleListPreferences(IConfigurationProvider iConfigurationProvider) {
        this.initFromConfig(iConfigurationProvider);
    }

    @Override
    public boolean isPreferredLoadingSupported() {
        return !Product.isInOfflineModus();
    }

    @Override
    public boolean isPreferredLoadingEnabled() {
        return this.prefLoadingEnabled && this.isPreferredLoadingSupported();
    }

    @Override
    public void setPreferredLoadingEnabled(boolean bl) {
        this.prefLoadingEnabled = bl;
    }

    @Override
    public void setPreferablyLoadedTypes(ReferringObjectType ... referringObjectTypeArray) {
        this.prefTypes = referringObjectTypeArray != null ? Arrays.asList(referringObjectTypeArray) : null;
    }

    @Override
    public List<ReferringObjectType> getPreferablyLoadedTypes() {
        if (this.prefTypes != null) {
            return Collections.unmodifiableList(this.prefTypes);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean matchesPreferablyLoadedType(IDataInfo iDataInfo, IReferencedObjectProvider iReferencedObjectProvider) {
        if (this.prefTypes == null || !this.isPreferredLoadingEnabled()) {
            return true;
        }
        return iReferencedObjectProvider != null ? iReferencedObjectProvider.referencedObjectsAvailable(iDataInfo, this.prefTypes, false) : false;
    }

    private void initFromConfig(IConfigurationProvider iConfigurationProvider) {
        block6: {
            try {
                NodeList nodeList;
                Node node;
                this.prefTypes = null;
                this.prefLoadingEnabled = true;
                Document document = ConfigUtilities.loadXMLFromConfig_UTF16((IConfigurationProvider)iConfigurationProvider, (String)CONFIG_PATH);
                Node node2 = node = document.getDocumentElement().hasAttributes() ? document.getDocumentElement().getAttributes().getNamedItem("prefLoadingEnabled") : null;
                if (node != null) {
                    this.prefLoadingEnabled = Boolean.valueOf(node.getTextContent());
                }
                if ((nodeList = document.getElementsByTagName("ref-object-set")) == null || nodeList.getLength() <= 0) break block6;
                this.prefTypes = new ArrayList<ReferringObjectType>();
                int n = 0;
                while (n < nodeList.getLength()) {
                    try {
                        NamedNodeMap namedNodeMap = nodeList.item(n).getAttributes();
                        String string = namedNodeMap.getNamedItem("name") != null ? namedNodeMap.getNamedItem("name").getTextContent() : null;
                        this.prefTypes.add(ReferringObjectType.valueOf((String)string));
                    }
                    catch (Exception exception) {
                        log.warn("Reading cyclelist loading preferred type from configuration failed!");
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                log.error("Initializing cyclelist loading preferences from configuration failed!", (Throwable)exception);
            }
        }
    }

    @Override
    public void save(IConfigurationProvider iConfigurationProvider) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<prefs ");
            stringBuilder.append("prefLoadingEnabled=\"");
            stringBuilder.append(this.prefLoadingEnabled);
            stringBuilder.append("\">");
            if (this.prefTypes != null && !this.prefTypes.isEmpty()) {
                for (ReferringObjectType referringObjectType : this.prefTypes) {
                    stringBuilder.append("<ref-object-set ");
                    stringBuilder.append("name=\"");
                    stringBuilder.append(referringObjectType.name());
                    stringBuilder.append("\"/>");
                }
            }
            stringBuilder.append("</prefs>");
            ConfigUtilities.saveToConfigAsXML_UTF16((IConfigurationProvider)iConfigurationProvider, (String)CONFIG_PATH, (String)stringBuilder.toString());
        }
        catch (Exception exception) {
            log.error("Writing cyclelist loading preferences to configuration failed!", (Throwable)exception);
        }
    }
}

