/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.cycling.impl;

import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.event.ActionInfo;
import com.agfa.pacs.event.EventEngineFactory;
import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IEventEngine;
import com.agfa.pacs.listtext.base.Base;
import com.agfa.pacs.listtext.cycling.ICycleListProvider;
import com.agfa.pacs.listtext.cycling.ICycleListProviderListener;
import com.agfa.pacs.listtext.cycling.prefs.ICycleListPreferences;
import com.agfa.pacs.listtext.lta.util.Modality;
import com.agfa.pacs.listtext.lta.util.StudyList;
import com.agfa.pacs.listtext.lta.util.referencedobject.IReferencedObjectProvider;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferencedObjectProviderFactory;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferencedObjectUtilities;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferringObjectType;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public abstract class AbstractCycleListProvider
implements ICycleListProvider {
    private static final long IGNORED_DOUBLE_CLICK_TIME = 2000L;
    private static final ALogger logger = ALogger.getLogger(AbstractCycleListProvider.class);
    protected boolean syncTextArea = true;
    protected String willBeSynchronizedUID = null;
    private List<ICycleListProviderListener> listener;
    protected static final IEventEngine eventEngine = EventEngineFactory.getInstance();
    private int lastOpenedDataHashCode;
    private long lastOpenedDataTimestamp;
    private Object syncMonitor = new Object();

    public AbstractCycleListProvider() {
        this.listener = new Vector<ICycleListProviderListener>();
    }

    protected boolean areMultiplePatientsAllowed() {
        return false;
    }

    protected abstract void showMultiplePatientWarning();

    @Override
    public final boolean addToCycleList(List<? extends IDataInfo> list, boolean bl, String string) throws Exception {
        return this.addToCycleList(list, null, bl, false, string, this.areMultiplePatientsAllowed());
    }

    @Override
    public final boolean addToCycleListAndDisplay(List<? extends IDataInfo> list, boolean bl) throws Exception {
        int n = list.hashCode();
        long l = System.currentTimeMillis();
        if (this.lastOpenedDataHashCode == n && l - this.lastOpenedDataTimestamp < 2000L) {
            return false;
        }
        this.lastOpenedDataHashCode = n;
        this.lastOpenedDataTimestamp = l;
        return this.addToCycleList(list, null, bl, true, null, this.areMultiplePatientsAllowed());
    }

    @Override
    public boolean markPatientsMerged(ReferencedObjectUtilities.ReferencedResult referencedResult) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void showMessagePopup(final String string, Integer n) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(AbstractCycleListProvider.this.getAllWindows().get(0), string);
            }
        });
    }

    @Override
    public final boolean addToCycleList(List<? extends IDataInfo> list, Object object) {
        try {
            return this.addToCycleList(list, object, false, true, null, this.areMultiplePatientsAllowed());
        }
        catch (Exception exception) {
            ALogger.getLogger(AbstractCycleListProvider.class).error("Error on drop", (Throwable)exception);
            return false;
        }
    }

    @Override
    public IStudyInfo[] getSessions() {
        return new IStudyInfo[0];
    }

    @Override
    public IPatientInfo getDisplayedPatient() {
        IStudyInfo[] iStudyInfoArray = this.getDisplayedStudies();
        if (iStudyInfoArray == null || iStudyInfoArray.length == 0) {
            return null;
        }
        return iStudyInfoArray[0].getPatient();
    }

    @Override
    public final boolean addToCycleListAsPrior(IStudyInfo iStudyInfo, List<? extends IDataInfo> list) {
        return this.addToCycleListPriorImpl(iStudyInfo, list);
    }

    @Override
    public final void displayFromCycleList(List<? extends IDataInfo> list) {
        this.displayFromCycleListImpl(list);
    }

    @Override
    public final void removeFromCycleList(List<? extends IDataInfo> list) {
        this.removeFromCycleListImpl(list);
    }

    @Override
    public void removeAllFromCycleList() {
    }

    @Override
    public boolean isTextAreaSyncEnabled() {
        return this.syncTextArea;
    }

    @Override
    public boolean mergePatientsAndDisplay(IPatientInfo iPatientInfo, List<? extends IDataInfo> list) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSupportingPatientMerge() {
        return false;
    }

    @Override
    public boolean canPatientBeMerged(IPatientInfo iPatientInfo) {
        return false;
    }

    @Override
    public boolean isPatientMergedTo(IPatientInfo iPatientInfo, IPatientInfo iPatientInfo2) {
        return false;
    }

    @Override
    public final void setTextAreaSyncEnabled(boolean bl) {
        this.syncTextArea = bl;
    }

    @Override
    public void syncTextArea() {
        this.syncTextArea(this.getDisplayedStudies(), false);
    }

    @Override
    public void addCycleListProviderListener(ICycleListProviderListener iCycleListProviderListener) {
        if (iCycleListProviderListener != null && !this.listener.contains(iCycleListProviderListener)) {
            this.listener.add(iCycleListProviderListener);
        }
    }

    @Override
    public void removeCycleListProviderListener(ICycleListProviderListener iCycleListProviderListener) {
        if (iCycleListProviderListener != null) {
            this.listener.remove(iCycleListProviderListener);
        }
    }

    protected abstract void addStudy2Profiler(IStudyInfo var1);

    protected abstract boolean removeFromCycleListImpl(List<? extends IDataInfo> var1);

    protected abstract boolean addToCycleListImpl(List<List<? extends IDataInfo>> var1, Object var2, boolean var3, boolean var4, String var5, boolean var6);

    protected abstract boolean addToCycleListPriorImpl(IStudyInfo var1, List<? extends IDataInfo> var2);

    protected abstract boolean displayFromCycleListImpl(List<? extends IDataInfo> var1);

    protected boolean addToCycleList(List<? extends IDataInfo> list, Object object, boolean bl, boolean bl2, String string, boolean bl3) throws Exception {
        logger.info("Starting open a study");
        list = DataInfoUtilities.cloneData(list);
        List list2 = DataInfoUtilities.getLevel((Collection)list, (Level)Level.Patient);
        if (!bl3 && list2.size() > 1) {
            this.showMultiplePatientWarning();
            return false;
        }
        ArrayList<List<? extends IDataInfo>> arrayList = new ArrayList<List<? extends IDataInfo>>(list2.size());
        for (IPatientInfo iPatientInfo : list2) {
            List list3 = DataInfoUtilities.extractChildrenBelongingToParent((IDataInfo)iPatientInfo, (List)list);
            List<? extends IDataInfo> list4 = AbstractCycleListProvider.getDataToOpen(list3, this.getCycleListPreferences());
            List<List<IDataInfo>> list5 = AbstractCycleListProvider.checkToAddReferencedObjects(list4, this.getCycleListPreferences(), this);
            for (List<IDataInfo> list6 : list5) {
                if (list6.isEmpty()) continue;
                for (IStudyInfo iStudyInfo : DataInfoUtilities.getLevel(list6, IStudyInfo.class)) {
                    this.addStudy2Profiler(iStudyInfo);
                }
                arrayList.add(list6);
            }
        }
        return this.addToCycleListImpl(arrayList, object, bl, bl2, string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncTextArea(IStudyInfo[] iStudyInfoArray, boolean bl) {
        Object object = this.syncMonitor;
        synchronized (object) {
            if (iStudyInfoArray == null || iStudyInfoArray.length == 0) {
                IEvent iEvent = eventEngine.createInternalEvent(Base.EVENT_ID_TEXTAREA_INIT_REQUEST);
                iEvent.setDestination(null, "textarea");
                iEvent.setActionInfo(ActionInfo.SINGLE);
                iEvent.setPayload((Object)new StudyList(Collections.EMPTY_LIST, false));
                eventEngine.sendEvent(iEvent);
                return;
            }
            if (iStudyInfoArray[0].getKey().equals(this.willBeSynchronizedUID)) {
                if (bl) {
                    this.willBeSynchronizedUID = null;
                } else {
                    return;
                }
            }
            logger.debug("Synchronize textarea using study(1/" + iStudyInfoArray.length + "): " + iStudyInfoArray[0].getStudyUID());
            IEvent iEvent = eventEngine.createInternalEvent(Base.EVENT_ID_TEXTAREA_INIT_REQUEST);
            iEvent.setDestination(null, "textarea");
            iEvent.setActionInfo(ActionInfo.SINGLE);
            iEvent.setPayload((Object)new StudyList(DataInfoUtilities.cloneAndCutBelowStudies(Arrays.asList(iStudyInfoArray)), true));
            eventEngine.sendEvent(iEvent);
        }
    }

    protected void syncTextAreaDelayed(List<? extends IDataInfo> list, final boolean bl) {
        final IStudyInfo[] iStudyInfoArray = DataInfoUtilities.getLevel(list, (Level)Level.Study).toArray(new IStudyInfo[0]);
        this.willBeSynchronizedUID = iStudyInfoArray[0].getKey();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                AbstractCycleListProvider.this.syncTextArea(iStudyInfoArray, bl);
            }
        }, "SyncTextArea");
        thread.setPriority(1);
        thread.start();
    }

    protected static List<? extends IDataInfo> getDataToOpen(List<? extends IDataInfo> list, ICycleListPreferences iCycleListPreferences) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        if (!iCycleListPreferences.isPreferredLoadingEnabled()) {
            return list;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = null;
        for (IDataInfo iDataInfo : list) {
            IReferencedObjectProvider iReferencedObjectProvider;
            if (iCycleListPreferences.matchesPreferablyLoadedType(iDataInfo, iReferencedObjectProvider = ReferencedObjectProviderFactory.getInstance().getSupportedReferencedObjectProvider(iDataInfo.getSource()))) {
                if (Level.Series.compareTo((Enum)iDataInfo.getHierarchyLevel()) > 0) {
                    arrayList.addAll(AbstractCycleListProvider.getDataToOpen(iDataInfo.children(), iCycleListPreferences));
                    continue;
                }
                arrayList.add(iDataInfo);
                continue;
            }
            if (Level.Study == iDataInfo.getHierarchyLevel()) {
                arrayList.add(iDataInfo);
                continue;
            }
            if (iReferencedObjectProvider == null || !iReferencedObjectProvider.referencedObjectsAvailable(iDataInfo, Collections.singletonList(ReferringObjectType.PRESENTATION_STATE), false)) continue;
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<Object>();
            }
            if (Level.Series.compareTo((Enum)iDataInfo.getHierarchyLevel()) > 0) {
                arrayList2.addAll(AbstractCycleListProvider.getDataToOpen(iDataInfo.children(), iCycleListPreferences));
                continue;
            }
            arrayList2.add(iDataInfo);
        }
        if (arrayList.isEmpty()) {
            return list;
        }
        if (arrayList2 != null) {
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    private static boolean isCompleteStudy(IDataInfo iDataInfo) {
        if (iDataInfo.childrenAvailable()) {
            if (iDataInfo.containsValue(2101766)) {
                int n = iDataInfo.getInt(2101766);
                return iDataInfo.children().size() == n;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected static List<List<IDataInfo>> checkToAddReferencedObjects(List<? extends IDataInfo> list, ICycleListPreferences iCycleListPreferences, ICycleListProvider iCycleListProvider) throws Exception {
        void var7_21;
        ArrayList<List<IDataInfo>> arrayList;
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ReferringObjectType> arrayList2 = new ArrayList<ReferringObjectType>(ReferringObjectType.values().length);
        if (iCycleListPreferences.isPreferredLoadingEnabled()) {
            arrayList2.addAll(iCycleListPreferences.getPreferablyLoadedTypes());
            boolean bl = true;
            for (IDataInfo iDataInfo22 : list) {
                if (Level.Series.compareTo((Enum)iDataInfo22.getHierarchyLevel()) <= 0 && Modality.PR.dicom().equals(iDataInfo22.getString(524384))) continue;
                bl = false;
                break;
            }
            if (bl) {
                if (!arrayList2.contains(ReferringObjectType.PRESENTATION_STATE)) {
                    arrayList2.add(ReferringObjectType.PRESENTATION_STATE);
                }
            } else {
                IReferencedObjectProvider iReferencedObjectProvider = ReferencedObjectProviderFactory.getInstance().getSupportedReferencedObjectProvider(list.get(0).getSource());
                if (iReferencedObjectProvider != null) {
                    boolean bl2 = false;
                    for (IDataInfo iDataInfo : list) {
                        if (!iReferencedObjectProvider.referencedObjectsAvailable(iDataInfo, Collections.singletonList(ReferringObjectType.SESSION), true)) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2) {
                        arrayList2.add(ReferringObjectType.SESSION);
                    }
                }
            }
        } else {
            arrayList2.addAll(ReferencedObjectUtilities.getAllTypes());
        }
        Iterator<? extends IDataInfo> iterator = list.iterator();
        ArrayList arrayList3 = new ArrayList();
        while (iterator.hasNext()) {
            IDataInfo iDataInfo4 = iterator.next();
            if (!(iDataInfo4 instanceof IPatientInfo)) continue;
            iterator.remove();
            arrayList3.addAll(DataInfoUtilities.getLevel((IDataInfo)iDataInfo4, (Level)Level.Study));
        }
        list.addAll(arrayList3);
        boolean bl = true;
        for (IDataInfo iDataInfo : list) {
            bl = iDataInfo.getHierarchyLevel() == Level.Study ? (bl &= AbstractCycleListProvider.isCompleteStudy(iDataInfo)) : false;
            if (!bl) break;
        }
        if (bl) {
            arrayList2.remove(ReferringObjectType.PRESENTATION_STATE);
        }
        ReferencedObjectUtilities.ReferencedResult referencedResult = ReferencedObjectUtilities.getReferencedObjects(list, arrayList2, (boolean)true);
        if (iCycleListPreferences.isPreferredLoadingEnabled() && referencedResult.toOpen.size() == list.size()) {
            boolean bl2 = true;
            arrayList = DataInfoUtilities.getLevel(list, ISeriesInfo.class);
            for (ISeriesInfo iSeriesInfo : arrayList) {
                if ("KO".equals(iSeriesInfo.getString(524384))) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                ArrayList arrayList4 = new ArrayList(ReferencedObjectUtilities.getAllTypes());
                arrayList4.removeAll(arrayList2);
                ReferencedObjectUtilities.ReferencedResult referencedResult2 = ReferencedObjectUtilities.getReferencedObjects(list, arrayList4, (boolean)true);
            }
        }
        if (var7_21.containsMergedData() && iCycleListProvider.isSupportingPatientMerge()) {
            if (!iCycleListProvider.markPatientsMerged((ReferencedObjectUtilities.ReferencedResult)var7_21)) {
                return Collections.singletonList(new ArrayList());
            }
            List list2 = DataInfoUtilities.getLevel((Collection)var7_21.toOpen, IPatientInfo.class);
            arrayList = new ArrayList<List<IDataInfo>>(list2.size());
            for (IPatientInfo iPatientInfo : list2) {
                arrayList.add(DataInfoUtilities.extractChildrenBelongingToParent((IDataInfo)iPatientInfo, (List)var7_21.toOpen));
            }
            return arrayList;
        }
        return Collections.singletonList(var7_21.toOpen);
    }

    protected void fireDisplayedStudiesChanged(IStudyInfo[] iStudyInfoArray, IStudyInfo iStudyInfo) {
        for (ICycleListProviderListener iCycleListProviderListener : this.listener) {
            iCycleListProviderListener.displayedStudiesChanged(iStudyInfoArray, iStudyInfo);
        }
    }

    protected void fireStudiesRemoved(IStudyInfo[] iStudyInfoArray) {
        for (ICycleListProviderListener iCycleListProviderListener : this.listener) {
            iCycleListProviderListener.studiesRemoved(iStudyInfoArray);
        }
    }

    protected void fireStudiesAdded(IStudyInfo[] iStudyInfoArray) {
        for (ICycleListProviderListener iCycleListProviderListener : this.listener) {
            iCycleListProviderListener.studiesAdded(iStudyInfoArray);
        }
    }

    @Override
    public boolean supportsThinThickArchives() {
        return false;
    }

    protected void fireAllStudiesRemoved() {
        for (ICycleListProviderListener iCycleListProviderListener : this.listener) {
            iCycleListProviderListener.allStudiesRemoved();
        }
    }
}

