/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.cycling;

import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.node.IDataInfoNode;
import com.agfa.pacs.data.shared.util.Cancelable;
import com.agfa.pacs.listtext.base.Base;
import com.agfa.pacs.listtext.lta.priors.IPriorsHook;
import com.agfa.pacs.listtext.lta.priors.IRelevancyListener;
import com.agfa.pacs.listtext.lta.priors.PriorHooksFactory;
import com.agfa.pacs.logging.ALogger;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RelevancyManager {
    private static RelevancyManager instance = new RelevancyManager();
    private List<WeakReference<IRelevancyListener>> listeners = new ArrayList<WeakReference<IRelevancyListener>>();
    private IPriorsHook priorHook;
    private Cancelable lastSearch = null;

    public static RelevancyManager getInstance() {
        return instance;
    }

    private RelevancyManager() {
        List list = PriorHooksFactory.getInstance().getPriorsHooks();
        this.priorHook = list != null && !list.isEmpty() ? (IPriorsHook)list.get(0) : null;
    }

    private void cancelAll() {
        this.lastSearch = null;
    }

    private List<IRelevancyListener> getListeners() {
        Iterator<WeakReference<IRelevancyListener>> iterator = this.listeners.iterator();
        ArrayList<IRelevancyListener> arrayList = new ArrayList<IRelevancyListener>();
        while (iterator.hasNext()) {
            WeakReference<IRelevancyListener> weakReference = iterator.next();
            if (weakReference.get() == null) {
                iterator.remove();
                continue;
            }
            arrayList.add((IRelevancyListener)weakReference.get());
        }
        return arrayList;
    }

    public void sendAsLoaded(List<IStudyInfo> list) {
        for (IRelevancyListener iRelevancyListener : this.getListeners()) {
            iRelevancyListener.studiesLoaded(list);
        }
    }

    public void additionalStudiesFound(List<IStudyInfo> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        String string = list.get(0).getTreeParent().getKey();
        for (IRelevancyListener iRelevancyListener : this.getListeners()) {
            iRelevancyListener.studiesFound(string, list);
        }
    }

    public synchronized void startSearchRelevant(IRelevancyListener iRelevancyListener, List<IStudyInfo> list) {
        this.startSearchRelevant(iRelevancyListener, list, true);
    }

    public synchronized void findWholePatient(IPatientInfo iPatientInfo) {
        ArrayList<IRelevancyListener> arrayList = new ArrayList<IRelevancyListener>(this.getListeners());
        if (this.priorHook != null) {
            this.lastSearch = this.priorHook.findWholePatient(iPatientInfo, arrayList);
        }
    }

    public synchronized void startSearchRelevant(IRelevancyListener iRelevancyListener, List<IStudyInfo> list, boolean bl) {
        this.cancelAll();
        ArrayList<IRelevancyListener> arrayList = new ArrayList<IRelevancyListener>();
        if (bl) {
            arrayList.addAll(this.getListeners());
        }
        if (iRelevancyListener != null) {
            arrayList.add(iRelevancyListener);
        }
        if (list.get(0).getTreeParent().getAttributes().getProperty("MPI_QUERY", null) != null) {
            arrayList.add(RelevancyManager.getMPITrigger(list.get(0)));
        }
        if (this.priorHook != null) {
            this.lastSearch = this.priorHook.startSearch(list, arrayList);
        }
    }

    public void startSearchOtherRelevant(IRelevancyListener iRelevancyListener, List<IStudyInfo> list, IDataInfoNode iDataInfoNode) {
        if (list == null || list.isEmpty()) {
            ALogger.getLogger(RelevancyManager.class).warn("No base study provided");
            return;
        }
        this.cancelAll();
        List<IRelevancyListener> list2 = this.getListeners();
        if (iRelevancyListener != null) {
            list2.add(iRelevancyListener);
        }
        if (this.priorHook != null) {
            this.lastSearch = this.priorHook.startAnotherSearch(list, list2, iDataInfoNode);
        }
    }

    public void startMPISearch(IStudyInfo iStudyInfo, IDataInfoNode iDataInfoNode) {
        List<IRelevancyListener> list = this.getListeners();
        if (this.priorHook != null) {
            this.priorHook.startMPISearch(iStudyInfo, list, iDataInfoNode);
        }
    }

    public void addRelevancyListener(IRelevancyListener iRelevancyListener) {
        this.listeners.add(new WeakReference<IRelevancyListener>(iRelevancyListener));
    }

    public static IRelevancyListener getMPITrigger(IStudyInfo iStudyInfo) {
        return new MPITrigger(iStudyInfo);
    }

    private static class MPITrigger
    implements IRelevancyListener {
        private IStudyInfo baseStudy;

        public MPITrigger(IStudyInfo iStudyInfo) {
            this.baseStudy = iStudyInfo;
        }

        public void relevantFound(String string, String string2, List<IStudyInfo> list) {
        }

        public void searchFinished(String string, String string2, boolean bl) {
            if (!bl) {
                RelevancyManager.getInstance().startMPISearch(this.baseStudy, Base.getMasterDataNode());
            }
        }

        public void studiesLoaded(List<IStudyInfo> list) {
        }

        public void studiesFound(String string, List<IStudyInfo> list) {
        }
    }
}

