/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.internal.preferences.DefaultPreferences;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.preferences.PreferencesService;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class BundleDefaultPreferences
extends EclipsePreferences {
    private static Set loadedNodes = Collections.synchronizedSet(new HashSet());
    private String qualifier;
    private int segmentCount;
    private IEclipsePreferences loadLevel;

    public BundleDefaultPreferences() {
        this(null, null);
    }

    private BundleDefaultPreferences(EclipsePreferences eclipsePreferences, String string) {
        super(eclipsePreferences, string);
        Path path = new Path(this.absolutePath());
        this.segmentCount = path.segmentCount();
        if (this.segmentCount < 2) {
            return;
        }
        String string2 = path.segment(0);
        if ("bundle_defaults".equals(string2)) {
            this.qualifier = path.segment(1);
        }
        if (this.qualifier == null) {
            return;
        }
    }

    protected IEclipsePreferences getLoadLevel() {
        if (this.loadLevel == null) {
            if (this.qualifier == null) {
                return null;
            }
            IEclipsePreferences iEclipsePreferences = this;
            int n = 2;
            while (n < this.segmentCount) {
                iEclipsePreferences = (IEclipsePreferences)iEclipsePreferences.parent();
                ++n;
            }
            this.loadLevel = iEclipsePreferences;
        }
        return this.loadLevel;
    }

    protected boolean isAlreadyLoaded(IEclipsePreferences iEclipsePreferences) {
        return loadedNodes.contains(iEclipsePreferences.name());
    }

    protected void loaded() {
        loadedNodes.add(this.name());
    }

    protected void load() {
        String string = DefaultPreferences.getScopeRelativePath(this.absolutePath());
        if (string != null) {
            PreferencesService.getDefault().getRootNode().node("default").node(string);
        }
    }

    protected EclipsePreferences internalCreate(EclipsePreferences eclipsePreferences, String string, Object object) {
        return new BundleDefaultPreferences(eclipsePreferences, string);
    }
}

