/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.cdviewer.retriever;

import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.hw.AbstractDicomRetriever;
import com.agfa.pacs.data.shared.hw.IDicomDataRequest;
import com.agfa.pacs.data.shared.instanceinfo.IInstanceInfo;
import com.agfa.pacs.data.shared.instanceinfo.impl.URIInstanceInfo;
import com.agfa.pacs.data.shared.instanceinfo.impl.URLInstanceInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.impaxee.cdviewer.retriever.CDDicomReader;
import com.agfa.pacs.logging.ALogger;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class URLCDDicomRetriever
extends AbstractDicomRetriever {
    public static final String TYPE = "URL";
    private static ALogger log = ALogger.getLogger(URLCDDicomRetriever.class);

    protected void processImpl(IDicomDataRequest iDicomDataRequest) {
        IDicomDataRequest iDicomDataRequest2 = iDicomDataRequest;
        IObjectInfo iObjectInfo = iDicomDataRequest.getObjectInfo();
        InputStream inputStream = null;
        try {
            try {
                Object object;
                IInstanceInfo iInstanceInfo = iDicomDataRequest.getLoadableInfo().getInstanceInfo();
                URL uRL = null;
                String string = null;
                if (iInstanceInfo instanceof URLInstanceInfo) {
                    object = (URLInstanceInfo)iInstanceInfo;
                    uRL = object.getURL();
                    string = object.getTransferSyntaxUID();
                } else {
                    object = (URIInstanceInfo)iDicomDataRequest.getLoadableInfo().getInstanceInfo();
                    uRL = object.getURI().toURL();
                    string = object.getTransferSyntaxUID();
                }
                if (log.isDebugEnabled()) {
                    log.debug("Loading: " + iObjectInfo.getSOPInstanceUID() + "from " + uRL);
                }
                try {
                    inputStream = uRL.openStream();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    uRL = new URL(uRL.toString().toLowerCase());
                    inputStream = uRL.openStream();
                }
                if (!inputStream.markSupported()) {
                    inputStream = new BufferedInputStream(inputStream, 65536);
                }
                object = new CDDicomReader(inputStream, uRL, iObjectInfo.getSOPInstanceUID(), string, (IDicomDataListener)iDicomDataRequest2);
                object.parse();
                inputStream.close();
            }
            catch (Exception exception) {
                iDicomDataRequest2.dicomDataError(iObjectInfo.getSOPInstanceUID(), "DICOM file read error", (Throwable)exception);
                iDicomDataRequest2.dicomDataFinished(iObjectInfo.getSOPInstanceUID(), IDicomDataListener.Status.Failed, null);
                log.error("DICOM file read error", (Throwable)exception);
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    log.error("DICOM file read error", (Throwable)iOException);
                }
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                log.error("DICOM file read error", (Throwable)iOException);
            }
        }
    }

    public boolean isOffline() {
        return false;
    }
}

