/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.cdviewer;

import com.agfa.pacs.config.ConfigLevel;
import com.agfa.pacs.config.ConfigType;
import com.agfa.pacs.impaxee.cdviewer.ConfigurationItem;
import com.agfa.pacs.impaxee.cdviewer.ConfigurationItems;
import com.agfa.pacs.logging.ALogger;
import java.io.File;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ServerConfigParser {
    public static final String ConfigurationElement = "configuration";
    public static final String ItemElement = "item";
    public static final String TypeAttribute = "type";
    public static final String NameAttribute = "name";
    public static final String LevelAttribute = "level";
    public static final String VersionAttribute = "version";
    public static final Charset USED_CHARSET = StandardCharsets.UTF_8;
    public static final String PluginDelimiter = "|";
    private static SAXParserFactory sax = null;
    private static final ALogger log = ALogger.getLogger(ServerConfigParser.class);
    private static ALogger logger;

    static {
        sax = SAXParserFactory.newInstance();
        logger = ALogger.getLogger(ServerConfigParser.class);
    }

    public static Map<String, ConfigurationItems> parseCacheFiles(List<String> list, File file, ConfigLevel configLevel) {
        return ServerConfigParser.parseGroupsInt(list, file, configLevel);
    }

    public static Map<String, ConfigurationItems> parseServerStream(List<String> list, Reader reader, ConfigLevel configLevel) {
        return ServerConfigParser.parseGroupsInt(list, reader, configLevel);
    }

    private static Map<String, ConfigurationItems> parseGroupsInt(List<String> list, Object object, ConfigLevel configLevel) {
        try {
            XMLHandler xMLHandler = new XMLHandler(list, configLevel);
            if (object instanceof File) {
                sax.newSAXParser().parse((File)object, (DefaultHandler)xMLHandler);
            } else if (object instanceof Reader) {
                sax.newSAXParser().parse(new InputSource((Reader)object), (DefaultHandler)xMLHandler);
            } else {
                throw new UnsupportedOperationException("Incorrect object");
            }
            return xMLHandler.getResult();
        }
        catch (Exception exception) {
            logger.error("Error", (Throwable)exception);
            return Collections.emptyMap();
        }
    }

    private static class XMLHandler
    extends DefaultHandler {
        private Map<String, ConfigurationItems> map = new HashMap<String, ConfigurationItems>();
        private Set<String> plugins = null;
        private String fullPathKey;
        private String type;
        private String version;
        private String level;
        private StringBuilder actualValue = null;
        private ConfigLevel defaultLevel;

        public XMLHandler(List<String> list, ConfigLevel configLevel) {
            if (list != null) {
                this.plugins = new HashSet<String>(list);
            }
            this.defaultLevel = configLevel;
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.fullPathKey == null || this.actualValue == null) {
                return;
            }
            int n = this.fullPathKey.indexOf(ServerConfigParser.PluginDelimiter);
            if (n == -1) {
                if (!this.fullPathKey.equals("com.agfa.pacs.report.format")) {
                    logger.warn("Invalid key plugin name and version separator should be |. Key is: " + this.fullPathKey);
                }
                return;
            }
            String[] stringArray = new String[]{this.fullPathKey.substring(0, n), this.fullPathKey.substring(n + 2)};
            String string4 = stringArray[0];
            String string5 = stringArray[1];
            String string6 = String.valueOf(string4) + "_" + this.version;
            if (this.plugins != null && !this.plugins.contains(string6)) {
                return;
            }
            ConfigLevel configLevel = this.defaultLevel;
            if (configLevel == null) {
                configLevel = ConfigLevel.valueOf((String)this.level);
            }
            String string7 = this.actualValue.toString();
            ConfigType configType = null;
            try {
                configType = ConfigType.valueOf((String)this.type);
            }
            catch (Exception exception) {
                log.error("No type specified for:" + string5);
                return;
            }
            if (!this.map.containsKey(string6)) {
                ConfigurationItems configurationItems = new ConfigurationItems(string4);
                this.map.put(string6, configurationItems);
            }
            this.map.get((Object)string6).items.add(new ConfigurationItem(string5, this.version, string7, configType, configLevel));
            this.actualValue = null;
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.actualValue != null) {
                this.actualValue.append(cArray, n, n2);
            }
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            log.error("SAX error", (Throwable)sAXParseException);
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            log.error("SAX Fatal error", (Throwable)sAXParseException);
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equalsIgnoreCase(ServerConfigParser.ItemElement)) {
                this.fullPathKey = attributes.getValue(ServerConfigParser.NameAttribute);
                this.version = attributes.getValue(ServerConfigParser.VersionAttribute);
                this.type = attributes.getValue(ServerConfigParser.TypeAttribute);
                this.level = attributes.getValue(ServerConfigParser.LevelAttribute);
                this.actualValue = new StringBuilder();
            } else {
                this.actualValue = null;
                this.fullPathKey = null;
            }
        }

        public Map<String, ConfigurationItems> getResult() {
            return this.map;
        }
    }
}

