/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.cdviewer;

import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.impaxee.actions.PAction;
import com.agfa.pacs.impaxee.actions.impl.AnonymousPAction;
import com.agfa.pacs.impaxee.actions.ui.ActionUIFactory;
import com.agfa.pacs.impaxee.actions.ui.ActionUIScope;
import com.agfa.pacs.impaxee.actions.ui.IActionUI;
import com.agfa.pacs.impaxee.cdviewer.IReportVisualizer;
import com.agfa.pacs.impaxee.cdviewer.Messages;
import com.agfa.pacs.impaxee.gui.ComponentFactory;
import com.agfa.pacs.impaxee.plugin.IconDefinition;
import com.agfa.pacs.listtext.lta.reports.IReport;
import com.agfa.pacs.logging.ALogger;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorCellRenderer;
import com.tiani.gui.workarounds.multimonitor.MultiMonitorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;

public class ReportPanel
extends MultiMonitorPanel {
    private static final ALogger log = ALogger.getLogger(ReportPanel.class);
    private final IReportVisualizer visualizer;
    private JComboBox<IReport> comboBox;
    private IActionUI actionUI;
    private boolean isEnabled;

    public ReportPanel(IReportVisualizer iReportVisualizer) {
        super((LayoutManager)new BorderLayout());
        this.visualizer = iReportVisualizer;
        this.initComponents();
    }

    private void initComponents() {
        this.comboBox = ComponentFactory.instance.createMultiMonitorComboBox(IReport.class);
        this.comboBox.setRenderer((ListCellRenderer<IReport>)((Object)new ReportCellRenderer()));
        this.comboBox.setToolTipText(Messages.getString("Action.SelectStructuredReport.ToolTip"));
        this.add(this.comboBox, "Center");
        try {
            this.actionUI = ActionUIFactory.createUI((PAction)new OpenStructuredReportAction(), (ActionUIScope)ActionUIScope.Other);
            if (this.actionUI != null) {
                this.add(this.actionUI.getComponent(), "East");
            }
        }
        catch (Exception exception) {
            log.error("Initializing OpenSR action failed.", (Throwable)exception);
        }
    }

    void setReports(IReport[] iReportArray) {
        DefaultComboBoxModel<Object> defaultComboBoxModel = iReportArray == null || iReportArray.length == 0 ? new DefaultComboBoxModel() : new DefaultComboBoxModel<IReport>(iReportArray);
        this.comboBox.setModel(defaultComboBoxModel);
        this.isEnabled = defaultComboBoxModel.getSize() > 0;
        this.comboBox.setEnabled(this.isEnabled);
        if (this.actionUI != null) {
            this.actionUI.getAction().fireEnabledChanged();
        }
    }

    private class OpenStructuredReportAction
    extends AnonymousPAction {
        public OpenStructuredReportAction() {
            super(new IconDefinition("openSR.svg", OpenStructuredReportAction.class));
        }

        public String getCaption() {
            return Messages.getString("Action.OpenStructuredReport.Caption");
        }

        public String getToolTipText() {
            return Messages.getString("Action.OpenStructuredReport.ToolTip");
        }

        protected boolean isEnabledImpl() {
            return ReportPanel.this.isEnabled;
        }

        public boolean perform(Component component) {
            IReport iReport = (IReport)ReportPanel.this.comboBox.getSelectedItem();
            ReportPanel.this.visualizer.selectReport(iReport);
            ReportPanel.this.visualizer.display();
            return true;
        }
    }

    private static class ReportCellRenderer
    extends MultiMonitorCellRenderer<IReport> {
        private ReportCellRenderer() {
        }

        protected String getText(IReport iReport) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(iReport.getTitle());
            if (iReport.getCreationDate() != null) {
                stringBuilder.append(" [");
                stringBuilder.append(DateTimeUtils.date2ShortString((Date)iReport.getCreationDate()));
                stringBuilder.append(']');
            }
            if (iReport.getVerificationState() != null) {
                stringBuilder.append(" (");
                stringBuilder.append(iReport.getVerificationState());
                stringBuilder.append(')');
            }
            return stringBuilder.toString();
        }

        protected String getToolTipText(IReport iReport, String string) {
            return string;
        }
    }
}

