/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.impaxee.cdviewer;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.impaxee.demographics.DemographicsXmlLoader;
import com.agfa.pacs.impaxee.hanging.HangingXmlLoader;
import com.agfa.pacs.impaxee.splitsort.SplitSortXmlLoader;
import com.agfa.pacs.login.serviceTools.IServiceTool;
import java.io.File;

public class CDViewerPreparation
implements IServiceTool {
    private static final String HANGINGS_FILE = "HANGING.AGH";
    private static final String SPLIT_SORT_FILE = "SPLTSORT.AGS";

    public void start() {
        if (new HangingXmlLoader().importFromFile(new File(HANGINGS_FILE))) {
            ConfigurationProviderFactory.getConfig().setBoolean("impaxee.jvision.HANGMAN.AutoHangup", true);
        }
        new SplitSortXmlLoader().importFromFile(new File(SPLIT_SORT_FILE));
        DemographicsXmlLoader.overloadDemographicsFromFile((File)new File("MAPPINGS.AGM"));
    }

    public static boolean hasAdvancedHangingProtocols() {
        return new File(HANGINGS_FILE).exists() || new File(SPLIT_SORT_FILE).exists();
    }

    public int getPriority() {
        return 100;
    }
}

