/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.config.provider.internal;

import com.agfa.pacs.config.ConfigLevel;
import com.agfa.pacs.config.ConfigType;
import com.agfa.pacs.config.IConfigurationCacheVisitor;
import com.agfa.pacs.config.IConfigurationList;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.config.provider.internal.ConfigIntermediateNode;
import com.agfa.pacs.config.provider.internal.ConfigLeafNode;
import com.agfa.pacs.config.provider.internal.ConfigNode;
import com.agfa.pacs.config.provider.internal.ConfigTree;
import com.agfa.pacs.config.provider.internal.ConfigTreeList;
import com.agfa.pacs.config.provider.internal.ListDirectAccessException;
import com.agfa.pacs.config.provider.internal.ValueModificationReturn;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ConfigListNode
extends ConfigNode {
    private Map<String, ConfigNode> idIndex;
    private List<ConfigNode> items = new ArrayList<ConfigNode>();

    protected ConfigListNode() {
        this.idIndex = new HashMap<String, ConfigNode>();
    }

    protected List<ConfigNode> getChildren() {
        return this.items;
    }

    protected int getSize() {
        return this.items.size();
    }

    protected synchronized void initValue(String string, ConfigLevel configLevel, String[] stringArray, int n, ConfigType configType, String string2, String string3) {
        if (stringArray.length > n) {
            ConfigIntermediateNode configIntermediateNode = (ConfigIntermediateNode)this.idIndex.get(string);
            if (configIntermediateNode == null) {
                configIntermediateNode = new ConfigIntermediateNode();
                this.items.add(configIntermediateNode);
                this.idIndex.put(string, configIntermediateNode);
            }
            configIntermediateNode.initValue(configLevel, stringArray, n, configType, string2, string3);
        } else {
            ConfigLeafNode configLeafNode = (ConfigLeafNode)this.idIndex.get(string);
            if (configLeafNode == null) {
                configLeafNode = new ConfigLeafNode(configType);
                this.items.add(configLeafNode);
                this.idIndex.put(string, configLeafNode);
            }
            configLeafNode.initValue(configLevel, stringArray, n, configType, string2, string3);
        }
    }

    @Override
    public void initValue(ConfigLevel configLevel, String[] stringArray, int n, ConfigType configType, String string, String string2) {
        throw new IllegalArgumentException("need index to build up list");
    }

    @Override
    protected Object getValue(Iterator<String> iterator) {
        throw new ListDirectAccessException("illegal access to list items:", !iterator.hasNext());
    }

    @Override
    protected String getRole(Iterator<String> iterator) {
        throw new ListDirectAccessException("illegal access to list items:", !iterator.hasNext());
    }

    @Override
    protected Map<ConfigLevel, Object> getMap(Iterator<String> iterator) {
        throw new ListDirectAccessException("illegal access to list items", !iterator.hasNext());
    }

    @Override
    protected ConfigNode getNode(Iterator<String> iterator) {
        if (!iterator.hasNext()) {
            return this;
        }
        throw new ListDirectAccessException("illegal access to list items", !iterator.hasNext());
    }

    @Override
    public IConfigurationProvider getNode(ConfigTree configTree, String string, Iterator<String> iterator) {
        if (!iterator.hasNext()) {
            return new ConfigTreeList(configTree, this, String.valueOf(configTree.prefix) + "." + string);
        }
        throw new ListDirectAccessException("illegal access to list items", false);
    }

    @Override
    public IConfigurationList getList(ConfigTree configTree, String string, Iterator<String> iterator) {
        if (!iterator.hasNext()) {
            if (configTree.prefix.length() < 1) {
                return new ConfigTreeList(configTree, this, string);
            }
            return new ConfigTreeList(configTree, this, String.valueOf(configTree.prefix) + "." + string);
        }
        throw new ListDirectAccessException("illegal access to list items", false);
    }

    @Override
    public ValueModificationReturn setValue(String[] stringArray, int n, String string, ConfigType configType, Object object, String string2) {
        throw new ListDirectAccessException("illegal access to list items", stringArray.length > n);
    }

    @Override
    public ValueModificationReturn removeValue(Iterator<String> iterator) {
        throw new ListDirectAccessException("illegal access to list items", !iterator.hasNext());
    }

    @Override
    void removeNode(Iterator<String> iterator) {
        throw new ListDirectAccessException("illegal access to list items", !iterator.hasNext());
    }

    @Override
    protected synchronized void internalScanCache(String string, IConfigurationCacheVisitor iConfigurationCacheVisitor, boolean bl, boolean bl2) {
        HashMap<ConfigNode, String> hashMap = new HashMap<ConfigNode, String>();
        for (String string2 : this.idIndex.keySet()) {
            hashMap.put(this.idIndex.get(string2), string2);
        }
        int n = 0;
        while (n < this.items.size()) {
            this.items.get(n).internalScanCache(String.valueOf(string) + "#" + (String)hashMap.get(this.items.get(n)), iConfigurationCacheVisitor, bl, bl2);
            ++n;
        }
        if (this.items.size() == 0) {
            iConfigurationCacheVisitor.visitEntry(null, 0L, String.valueOf(string) + "#", null, "");
        }
        if (bl2) {
            this.dirty = false;
        }
    }

    protected synchronized void addChild(String string, ConfigNode configNode, int n) {
        if (n < 0) {
            this.items.add(configNode);
        } else {
            this.items.add(n, configNode);
        }
        this.idIndex.put(string, configNode);
    }

    protected String getIdFromIndex(int n) {
        ConfigNode configNode = this.items.get(n);
        for (String string : this.idIndex.keySet()) {
            if (!this.idIndex.get(string).equals(configNode)) continue;
            return string;
        }
        return null;
    }

    protected Map<String, ConfigNode> getId2NodeMap() {
        return this.idIndex;
    }

    public synchronized void remove(String string, String string2) {
        ConfigNode configNode = this.idIndex.get(string);
        if (configNode == null) {
            throw new IllegalArgumentException("Item not found.Delete not possible");
        }
        this.items.remove(configNode);
        this.idIndex.remove(string);
    }

    @Override
    public IConfigurationList createList(ConfigTree configTree, String string, Iterator<String> iterator, String string2) {
        throw new ListDirectAccessException("illegal access to list elements", !iterator.hasNext());
    }

    @Override
    protected Map<String, String> getLocalizedValues(Iterator<String> iterator) {
        throw new ListDirectAccessException("Illegal access to list items", !iterator.hasNext());
    }

    ConfigNode getNodeById(String string) {
        return this.idIndex.get(string);
    }
}

