/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.pixeldata.frame;

import com.agfa.pacs.data.shared.pixel.IPixelAccessor;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.data.shared.pixel.PhotometricInterpretation;
import com.agfa.pacs.data.shared.pixel.PixelDataException;
import com.agfa.pacs.data.shared.pixel.PixelDataFrameUtilities;
import com.agfa.pacs.data.shared.pixel.encoder.IPixelDataEncoder;
import com.agfa.pacs.data.shared.pixel.encoder.PixelDataEncoderFactory;
import com.agfa.pacs.listtext.dicomobject.module.image.ImagePixel;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import org.dcm4che3.data.Attributes;

public class PixelDataUtilities {
    private static PixelDataEncoderFactory encoder = PixelDataEncoderFactory.getInstance();

    public static IPixelDataFrame<?> createShortGrayPixelDataFrame(int n, int n2, int n3, boolean bl, short[] sArray) {
        ImagePixel imagePixel = new ImagePixel();
        imagePixel.setPhotometricInterpretation(PhotometricInterpretation.Monochrome);
        imagePixel.setSamplesPerPixel(1);
        imagePixel.setBitsAllocated(16);
        imagePixel.setBitsStored(n3);
        imagePixel.setHighBit(n3 - 1);
        imagePixel.setColumns(n);
        imagePixel.setRows(n2);
        imagePixel.setPixelRepresentation(bl ? 1 : 0);
        return PixelDataFrameUtilities.createPixelDataFrame((Attributes)imagePixel.toDataset(), (Object)sArray);
    }

    public static ImagePixel createGrayImagePixel(int n, int n2, int n3, boolean bl) {
        if (n3 < 0) {
            n3 = 16;
        }
        ImagePixel imagePixel = new ImagePixel();
        imagePixel.setPhotometricInterpretation(PhotometricInterpretation.Monochrome);
        imagePixel.setSamplesPerPixel(1);
        imagePixel.setBitsAllocated(16);
        imagePixel.setBitsStored(n3);
        imagePixel.setHighBit(n3 - 1);
        imagePixel.setColumns(n);
        imagePixel.setRows(n2);
        imagePixel.setPixelRepresentation(bl ? 1 : 0);
        return imagePixel;
    }

    public static ImagePixel createIndexedImagePixel(int n, int n2, int n3, boolean bl, int[] nArray, byte[][] byArray) {
        if (n3 < 0) {
            n3 = 16;
        }
        ImagePixel imagePixel = new ImagePixel();
        imagePixel.setPhotometricInterpretation(PhotometricInterpretation.IndexedColor);
        imagePixel.setRedPaletteColorLookupTableDescriptor(nArray);
        imagePixel.setGreenPaletteColorLookupTableDescriptor(nArray);
        imagePixel.setBluePaletteColorLookupTableDescriptor(nArray);
        imagePixel.setSegmentedRedPaletteColorLookupTableData(byArray[0]);
        imagePixel.setSegmentedGreenPaletteColorLookupTableData(byArray[1]);
        imagePixel.setSegmentedBluePaletteColorLookupTableData(byArray[2]);
        imagePixel.setSmallestImagePixelValue(0);
        imagePixel.setLargestImagePixelValue(0);
        imagePixel.setSamplesPerPixel(1);
        imagePixel.setBitsAllocated(16);
        imagePixel.setBitsStored(n3);
        imagePixel.setHighBit(n3 - 1);
        imagePixel.setColumns(n);
        imagePixel.setRows(n2);
        imagePixel.setPixelRepresentation(bl ? 1 : 0);
        imagePixel.setPlanarConfiguration(0);
        return imagePixel;
    }

    public static IPixelDataFrame<?> createPixelDataFrame(ImagePixel imagePixel, Object object) {
        return PixelDataFrameUtilities.createPixelDataFrame((Attributes)imagePixel.toDataset(), (Object)object);
    }

    public static IPixelDataFrame<?> createPixelDataFrame(ImagePixel imagePixel, BufferedImage bufferedImage) {
        int n = PixelDataUtilities.getBufferedImageType(imagePixel);
        if (bufferedImage.getType() != n) {
            BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), n);
            bufferedImage2.getGraphics().drawImage(bufferedImage, 0, 0, null);
            bufferedImage = bufferedImage2;
        }
        switch (bufferedImage.getType()) {
            case 10: {
                return PixelDataFrameUtilities.createPixelDataFrame((Attributes)imagePixel.toDataset(), (Object)((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData());
            }
            case 11: {
                return PixelDataFrameUtilities.createPixelDataFrame((Attributes)imagePixel.toDataset(), (Object)((DataBufferUShort)bufferedImage.getRaster().getDataBuffer()).getData());
            }
            case 1: {
                return PixelDataFrameUtilities.createPixelDataFrame((Attributes)imagePixel.toDataset(), (Object)((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData());
            }
        }
        return null;
    }

    public static Object getPixelData(ImagePixel imagePixel, BufferedImage bufferedImage) {
        int n = PixelDataUtilities.getBufferedImageType(imagePixel);
        if (bufferedImage.getType() != n) {
            BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), n);
            bufferedImage2.getGraphics().drawImage(bufferedImage, 0, 0, null);
            bufferedImage = bufferedImage2;
        }
        switch (bufferedImage.getType()) {
            case 10: {
                return ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
            }
            case 11: {
                return ((DataBufferUShort)bufferedImage.getRaster().getDataBuffer()).getData();
            }
            case 1: {
                return ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
            }
        }
        return null;
    }

    public static int getBufferedImageType(ImagePixel imagePixel) {
        int n = imagePixel.getBitsAllocated();
        int n2 = imagePixel.getSamplesPerPixel();
        if (n <= 8 && n2 == 1) {
            return 10;
        }
        if (n <= 16 && n2 == 1) {
            return 11;
        }
        if (n <= 8 && n2 == 3) {
            return 1;
        }
        return -1;
    }

    public static ImagePixel createImagePixel(BufferedImage bufferedImage, String string, int n) throws PixelDataException {
        ImagePixel imagePixel = ImagePixel.create(bufferedImage);
        imagePixel.setBitsStored(n);
        imagePixel.setHighBit(n - 1);
        Object object = PixelDataUtilities.getPixelData(imagePixel, bufferedImage);
        PixelDataUtilities.encodePixelData(imagePixel, object, string);
        return imagePixel;
    }

    public static ImagePixel createImagePixel(IPixelDataFrame<?> iPixelDataFrame, String string) throws PixelDataException {
        ImagePixel imagePixel = new ImagePixel(iPixelDataFrame.getImagePixel());
        PixelDataUtilities.encodePixelData(imagePixel, iPixelDataFrame, string);
        return imagePixel;
    }

    public static void encodePixelData(ImagePixel imagePixel, Object object, IPixelDataEncoder iPixelDataEncoder) throws PixelDataException {
        byte[] byArray = iPixelDataEncoder.encode(imagePixel.imagePixel(), object);
        if (iPixelDataEncoder.isEncapsulated()) {
            imagePixel.pixelDataFragments().add(byArray);
        } else {
            imagePixel.setPixelData(byArray);
        }
    }

    public static void encodePixelData(ImagePixel imagePixel, Object object, String string) throws PixelDataException {
        IPixelDataEncoder iPixelDataEncoder = encoder.createPixelDataEncoder(string);
        PixelDataUtilities.encodePixelData(imagePixel, object, iPixelDataEncoder);
    }

    public static void encodePixelData(ImagePixel imagePixel, IPixelDataFrame<?> iPixelDataFrame, IPixelDataEncoder iPixelDataEncoder) throws PixelDataException {
        IPixelAccessor iPixelAccessor = iPixelDataFrame.getPixelAccessor();
        byte[] byArray = iPixelDataEncoder.encode(imagePixel.imagePixel(), iPixelAccessor.getData());
        iPixelAccessor.release();
        if (iPixelDataEncoder.isEncapsulated()) {
            imagePixel.pixelDataFragments().add(byArray);
        } else {
            imagePixel.setPixelData(byArray);
        }
    }

    public static void encodePixelData(ImagePixel imagePixel, IPixelDataFrame<?> iPixelDataFrame, String string) throws PixelDataException {
        IPixelDataEncoder iPixelDataEncoder = encoder.createPixelDataEncoder(string);
        PixelDataUtilities.encodePixelData(imagePixel, iPixelDataFrame, iPixelDataEncoder);
    }
}

