/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.type.print;

import com.agfa.pacs.data.shared.dicom.DicomEnum;
import java.util.List;
import java.util.Vector;

public class FilmDestination
implements DicomEnum {
    private static List<FilmDestination> values;
    public static final FilmDestination StoredPrint;
    public static final FilmDestination FilmMagazine;
    public static final FilmDestination FilmProzessor;
    public static final FilmDestination FilmSorterBIN1;
    public static final FilmDestination FilmSorterBIN2;
    public static final FilmDestination FilmSorterBIN3;
    public static final FilmDestination FilmSorterBIN4;
    public static final FilmDestination FilmSorterBIN5;
    public static final FilmDestination FilmSorterBIN6;
    public static final FilmDestination FilmSorterBIN7;
    public static final FilmDestination FilmSorterBIN8;
    public static final FilmDestination FilmSorterBIN9;
    public static final FilmDestination FilmSorterBIN10;
    private final String dicomId;
    private final boolean isBin;
    private final int binNumber;

    static {
        StoredPrint = new FilmDestination("STOREDPRINT", false, 0, true);
        FilmMagazine = new FilmDestination("MAGAZINE", false, 0, true);
        FilmProzessor = new FilmDestination("PROCESSOR", false, 0, true);
        FilmSorterBIN1 = new FilmDestination("BIN_1", true, 1, true);
        FilmSorterBIN2 = new FilmDestination("BIN_2", true, 2, true);
        FilmSorterBIN3 = new FilmDestination("BIN_3", true, 3, true);
        FilmSorterBIN4 = new FilmDestination("BIN_4", true, 4, true);
        FilmSorterBIN5 = new FilmDestination("BIN_5", true, 5, true);
        FilmSorterBIN6 = new FilmDestination("BIN_6", true, 6, true);
        FilmSorterBIN7 = new FilmDestination("BIN_7", true, 7, true);
        FilmSorterBIN8 = new FilmDestination("BIN_8", true, 8, true);
        FilmSorterBIN9 = new FilmDestination("BIN_9", true, 9, true);
        FilmSorterBIN10 = new FilmDestination("BIN_10", true, 10, true);
    }

    public FilmDestination(String string, boolean bl, int n) {
        this(string, bl, n, false);
    }

    private FilmDestination(String string, boolean bl, int n, boolean bl2) {
        this.dicomId = string;
        this.isBin = bl;
        this.binNumber = n;
        if (values == null) {
            values = new Vector<FilmDestination>();
        }
        if (bl2) {
            values.add(this);
        }
    }

    public String dicom() {
        return this.dicomId;
    }

    public int getBinNumber() {
        return this.binNumber;
    }

    public boolean isBin() {
        return this.isBin;
    }

    public static FilmDestination get(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("BIN_")) {
            return FilmDestination.getBin(Integer.parseInt(string.substring(4)));
        }
        for (FilmDestination filmDestination : values) {
            if (!filmDestination.dicom().equals(string)) continue;
            return filmDestination;
        }
        return null;
    }

    public static FilmDestination getBin(int n) {
        if (n <= 0) {
            return null;
        }
        for (FilmDestination filmDestination : values) {
            if (!filmDestination.isBin || filmDestination.binNumber != n) continue;
            return filmDestination;
        }
        return new FilmDestination("BIN_" + n, true, n, true);
    }
}

