/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.type.print;

import com.agfa.pacs.data.shared.dicom.DicomEnum;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Density
implements DicomEnum {
    public static final Density BLACK = new Density(true, false, -1);
    public static final Density WHITE = new Density(false, true, -1);
    private boolean black;
    private boolean white;
    private int opticalDensity;

    private Density(boolean bl, boolean bl2, int n) {
        this.black = bl;
        this.white = bl2;
        this.opticalDensity = n;
    }

    public boolean isBlack() {
        return this.black;
    }

    public boolean isWhite() {
        return this.white;
    }

    public double getOpticalDensity() {
        return this.opticalDensity;
    }

    public String dicom() {
        if (this.white) {
            return "WHITE";
        }
        if (this.black) {
            return "BLACK";
        }
        return Integer.toString(this.opticalDensity * 100);
    }

    public static Density get(String string) {
        if (string == null) {
            return null;
        }
        if ("WHITE".equals(string)) {
            return WHITE;
        }
        if ("BLACK".equals(string)) {
            return BLACK;
        }
        return new Density(false, false, Integer.parseInt(string));
    }

    public boolean equals(Object object) {
        if (!(object instanceof Density)) {
            return false;
        }
        Density density = (Density)object;
        return density.dicom().equals(this.dicom());
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }
}

