/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.sr.contenttree;

import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedWaveform;
import com.agfa.pacs.listtext.dicomobject.sr.content.DocumentContent;
import com.agfa.pacs.listtext.dicomobject.sr.content.SRReferencedImage;
import com.agfa.pacs.listtext.dicomobject.type.ContinuityOfContent;
import com.agfa.pacs.listtext.dicomobject.type.GraphicType;
import com.agfa.pacs.listtext.dicomobject.type.RelationshipType;
import com.agfa.pacs.listtext.dicomobject.type.TemporalRangeType;
import com.agfa.pacs.listtext.dicomobject.type.ValueType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DocumentContentTreeNode {
    private DocumentContent documentContent;
    private Date observationDateTime;
    private List<DocumentContentTreeNode> children = new ArrayList<DocumentContentTreeNode>();
    private DocumentContentTreeNode referencedNode;
    private RelationshipType relationshipType;
    private DocumentContentTreeNode parent;

    public DocumentContentTreeNode() {
    }

    public DocumentContentTreeNode(DocumentContent documentContent, RelationshipType relationshipType) {
        this();
        this.documentContent = documentContent;
        this.relationshipType = relationshipType;
    }

    public DocumentContentTreeNode(ValueType valueType, RelationshipType relationshipType) {
        this();
        this.documentContent = DocumentContent.create(valueType);
        this.relationshipType = relationshipType;
    }

    public DocumentContentTreeNode(DocumentContentTreeNode documentContentTreeNode, RelationshipType relationshipType) {
        this();
        this.referencedNode = documentContentTreeNode;
        this.relationshipType = relationshipType;
    }

    public Date getObservationDateTime() {
        return this.observationDateTime;
    }

    public void setObservationDateTime(Date date) {
        this.observationDateTime = date;
    }

    public DocumentContentTreeNode getReferencedNode() {
        return this.referencedNode;
    }

    public List<DocumentContentTreeNode> children() {
        return this.children;
    }

    public DocumentContent getDocumentContent() {
        return this.documentContent;
    }

    public RelationshipType getRelationshipType() {
        return this.relationshipType;
    }

    public DocumentContentTreeNode getParent() {
        return this.parent;
    }

    public void setReferencedNode(DocumentContentTreeNode documentContentTreeNode) {
        this.referencedNode = documentContentTreeNode;
    }

    public void setParent(DocumentContentTreeNode documentContentTreeNode) {
        this.parent = documentContentTreeNode;
    }

    public void addChild(DocumentContentTreeNode documentContentTreeNode) {
        if (documentContentTreeNode == null) {
            return;
        }
        if (this.children.contains(documentContentTreeNode)) {
            return;
        }
        this.children.add(documentContentTreeNode);
        documentContentTreeNode.setParent(this);
    }

    public static DocumentContentTreeNode createCode(Code code, Code code2, RelationshipType relationshipType) {
        return new DocumentContentTreeNode(new DocumentContent.CodeContent(code, code2), relationshipType);
    }

    public static DocumentContentTreeNode createComposite(ReferencedSOP referencedSOP, RelationshipType relationshipType) {
        return new DocumentContentTreeNode(new DocumentContent.CompositeContent(referencedSOP), relationshipType);
    }

    public static DocumentContentTreeNode createContainer(Code code, ContinuityOfContent continuityOfContent, RelationshipType relationshipType) {
        return new DocumentContentTreeNode(new DocumentContent.ContainerContent(code, continuityOfContent), relationshipType);
    }

    public static DocumentContentTreeNode createDate(Code code, Date date, RelationshipType relationshipType) {
        return new DocumentContentTreeNode(new DocumentContent.DateContent(code, date), relationshipType);
    }

    public static DocumentContentTreeNode createDateTime(Code code, Date date, RelationshipType relationshipType) {
        return new DocumentContentTreeNode(new DocumentContent.DateTimeContent(code, date), relationshipType);
    }

    public static DocumentContentTreeNode createImage(SRReferencedImage sRReferencedImage, RelationshipType relationshipType) {
        return new DocumentContentTreeNode(new DocumentContent.ImageContent(sRReferencedImage), relationshipType);
    }

    public static DocumentContentTreeNode createNumeric(Code code, DocumentContent.NumericContent.MeasuredValue measuredValue, Code code2, RelationshipType relationshipType) {
        return new DocumentContentTreeNode(new DocumentContent.NumericContent(code, measuredValue, code2), relationshipType);
    }

    public static DocumentContentTreeNode createPersonName(Code code, String string, RelationshipType relationshipType) {
        return new DocumentContentTreeNode(new DocumentContent.PersonNameContent(code, string), relationshipType);
    }

    public static DocumentContentTreeNode createSpatialCoord(Code code, float[] fArray, GraphicType graphicType, RelationshipType relationshipType) {
        return new DocumentContentTreeNode(new DocumentContent.SpatialCoordContent(code, fArray, graphicType), relationshipType);
    }

    public static DocumentContentTreeNode createTemporalCoord(Code code, TemporalRangeType temporalRangeType, int[] nArray, String[] stringArray, Date[] dateArray, RelationshipType relationshipType) {
        return new DocumentContentTreeNode(new DocumentContent.TemporalCoordContent(code, temporalRangeType, nArray, stringArray, dateArray), relationshipType);
    }

    public static DocumentContentTreeNode createText(Code code, String string, RelationshipType relationshipType) {
        return new DocumentContentTreeNode(new DocumentContent.TextContent(code, string), relationshipType);
    }

    public static DocumentContentTreeNode createTime(Code code, Date date, RelationshipType relationshipType) {
        return new DocumentContentTreeNode(new DocumentContent.TimeContent(code, date), relationshipType);
    }

    public static DocumentContentTreeNode createUIDReference(Code code, String string, RelationshipType relationshipType) {
        return new DocumentContentTreeNode(new DocumentContent.UIDReferenceContent(code, string), relationshipType);
    }

    public static DocumentContentTreeNode createWaveform(ReferencedWaveform referencedWaveform, RelationshipType relationshipType) {
        return new DocumentContentTreeNode(new DocumentContent.WaveformContent(referencedWaveform), relationshipType);
    }

    public static DocumentContentTreeNode createWaveform(Code code, ReferencedWaveform referencedWaveform, RelationshipType relationshipType) {
        return new DocumentContentTreeNode(new DocumentContent.WaveformContent(code, referencedWaveform), relationshipType);
    }
}

