/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.sr.content;

import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.data.DatasetSource;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import com.agfa.pacs.listtext.dicomobject.module.image.ImagePixel;
import org.dcm4che3.data.Attributes;

public class SRReferencedImage
extends AbstractDatasetSource {
    private String sopInstanceUID;
    private String sopClassUID;
    private int[] referencedFrameNumber;
    private ReferencedSOP softcopyPresentationState;
    private ImagePixel iconImage;
    private ReferencedSOP realWorldValueMapping;

    private SRReferencedImage(Attributes attributes) {
        this.sopClassUID = this.getString(attributes, 528720);
        this.sopInstanceUID = this.getString(attributes, 528725);
        this.referencedFrameNumber = this.getIntegers(attributes, 528736);
        this.softcopyPresentationState = ReferencedSOP.create(attributes.getNestedDataset(528793));
        this.realWorldValueMapping = ReferencedSOP.create(attributes.getNestedDataset(528715));
        this.iconImage = ImagePixel.create(attributes.getNestedDataset(0x880200), true);
    }

    public SRReferencedImage(String string, String string2, int[] nArray) {
        this.sopClassUID = string;
        this.sopInstanceUID = string2;
        this.referencedFrameNumber = nArray;
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.sopClassUID, attributes, 528720, DatasetAccessor.Type.Mandatory);
        this.set(this.sopInstanceUID, attributes, 528725, DatasetAccessor.Type.Mandatory);
        this.set(this.referencedFrameNumber, attributes, 528736, DatasetAccessor.Type.ConditionalMandatory);
        this.set((DatasetSource)this.softcopyPresentationState, attributes, 528793, DatasetAccessor.Type.Optional);
        this.set((DatasetSource)this.realWorldValueMapping, attributes, 528715, DatasetAccessor.Type.Optional);
        this.set((DatasetSource)this.iconImage, attributes, 0x880200, DatasetAccessor.Type.Optional);
        return attributes;
    }

    public static SRReferencedImage create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        if (attributes.contains(528720) && attributes.contains(528725)) {
            return new SRReferencedImage(attributes);
        }
        return null;
    }

    public ImagePixel getIconImage() {
        return this.iconImage;
    }

    public int[] getReferencedFrameNumbers() {
        return this.referencedFrameNumber;
    }

    public ReferencedSOP getSoftcopyPresentationState() {
        return this.softcopyPresentationState;
    }

    public String getSOPClassUID() {
        return this.sopClassUID;
    }

    public String getSOPInstanceUID() {
        return this.sopInstanceUID;
    }
}

