/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.visit;

import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.data.DatasetSource;
import com.agfa.pacs.listtext.dicomobject.module.AbstractModule;
import org.dcm4che3.data.Attributes;

public class VisitIdentificationModule
extends AbstractModule {
    private String institutionName;
    private String institutionAddress;
    private Code institutionCode;
    private String admissionID;
    private String issuerOfAdmissionID;

    public VisitIdentificationModule() {
        super(null);
    }

    @Override
    public boolean containsModule(Attributes attributes) {
        return attributes.contains(3670032);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void readFrom(Attributes attributes) {
        this.institutionName = this.getString(attributes, 524416);
        this.institutionAddress = this.getString(attributes, 524417);
        this.institutionCode = Code.create((Attributes)attributes, (int)524418);
        this.admissionID = this.getString(attributes, 3670032);
        this.issuerOfAdmissionID = this.getString(attributes, 3670033);
    }

    @Override
    public void writeTo(Attributes attributes) {
        this.set(this.institutionName, attributes, 524416, DatasetAccessor.Type.Optional);
        this.set(this.institutionAddress, attributes, 524417, DatasetAccessor.Type.Optional);
        this.set((DatasetSource)this.institutionCode, attributes, 524418, DatasetAccessor.Type.Optional);
        this.set(this.admissionID, attributes, 3670032, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.issuerOfAdmissionID, attributes, 3670033, DatasetAccessor.Type.Optional);
    }

    public String getAdmissionID() {
        return this.admissionID;
    }

    public String getInstitutionAddress() {
        return this.institutionAddress;
    }

    public Code getInstitutionCode() {
        return this.institutionCode;
    }

    public String getInstitutionName() {
        return this.institutionName;
    }

    public String getIssuerOfAdmissionID() {
        return this.issuerOfAdmissionID;
    }

    public void setAdmissionID(String string) {
        this.admissionID = string;
    }

    public void setInstitutionAddress(String string) {
        this.institutionAddress = string;
    }

    public void setInstitutionCode(Code code) {
        this.institutionCode = code;
    }

    public void setInstitutionName(String string) {
        this.institutionName = string;
    }

    public void setIssuerOfAdmissionID(String string) {
        this.issuerOfAdmissionID = string;
    }
}

