/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.study;

import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.listtext.dicomobject.module.AbstractModule;
import java.util.List;
import org.dcm4che3.data.Attributes;

public class PatientStudyModule
extends AbstractModule {
    private String admittingDiagnosisDescription;
    private List<Code> admittingDiagnosis;
    private String patientAge;
    private Double patientSize;
    private Double patientWeight;
    private String occupation;
    private String additionalPatientHistory;
    private String admissionID;
    private String issuerOfAdmissionID;

    public PatientStudyModule() {
        super(Level.Study);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean containsModule(Attributes attributes) {
        return true;
    }

    @Override
    public void readFrom(Attributes attributes) {
        this.admittingDiagnosisDescription = this.getString(attributes, 528512);
        this.admittingDiagnosis = Code.createList((Attributes)attributes, (int)528516);
        this.patientAge = this.getString(attributes, 0x101010);
        this.patientSize = this.getDouble(attributes, 0x101020);
        this.patientWeight = this.getDouble(attributes, 0x101030);
        this.occupation = this.getString(attributes, 1057152);
        this.additionalPatientHistory = this.getString(attributes, 1057200);
        this.admissionID = this.getString(attributes, 3670032);
        this.issuerOfAdmissionID = this.getString(attributes, 3670033);
    }

    @Override
    public void writeTo(Attributes attributes) {
        this.set(this.admittingDiagnosisDescription, attributes, 528512, DatasetAccessor.Type.Optional);
        this.set(this.admittingDiagnosis, attributes, 528516, DatasetAccessor.Type.Optional);
        this.set(this.patientAge, attributes, 0x101010, DatasetAccessor.Type.Optional);
        this.set(this.patientSize, attributes, 0x101020, DatasetAccessor.Type.Optional);
        this.set(this.patientWeight, attributes, 0x101030, DatasetAccessor.Type.Optional);
        this.set(this.occupation, attributes, 1057152, DatasetAccessor.Type.Optional);
        this.set(this.additionalPatientHistory, attributes, 1057200, DatasetAccessor.Type.Optional);
        this.set(this.admissionID, attributes, 3670032, DatasetAccessor.Type.Optional);
        this.set(this.issuerOfAdmissionID, attributes, 3670033, DatasetAccessor.Type.Optional);
    }

    public String getAdditionalPatientHistory() {
        return this.additionalPatientHistory;
    }

    public List<Code> getAdmittingDiagnosis() {
        return this.admittingDiagnosis;
    }

    public String getAdmittingDiagnosisDescription() {
        return this.admittingDiagnosisDescription;
    }

    public String getOccupation() {
        return this.occupation;
    }

    public String getPatientAge() {
        return this.patientAge;
    }

    public Double getPatientSize() {
        return this.patientSize;
    }

    public Double getPatientWeight() {
        return this.patientWeight;
    }

    public String getAdmissionID() {
        return this.admissionID;
    }

    public void setAdmissionID(String string) {
        this.admissionID = string;
    }

    public String getIssuerOfAdmissionID() {
        return this.issuerOfAdmissionID;
    }

    public void setIssuerOfAdmissionID(String string) {
        this.issuerOfAdmissionID = string;
    }

    public void setAdditionalPatientHistory(String string) {
        this.additionalPatientHistory = string;
    }

    public void setAdmittingDiagnosis(List<Code> list) {
        this.admittingDiagnosis = list;
    }

    public void setAdmittingDiagnosisDescription(String string) {
        this.admittingDiagnosisDescription = string;
    }

    public void setOccupation(String string) {
        this.occupation = string;
    }

    public void setPatientAge(String string) {
        this.patientAge = string;
    }

    public void setPatientSize(Double d) {
        this.patientSize = d;
    }

    public void setPatientWeight(Double d) {
        this.patientWeight = d;
    }
}

