/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.sr;

import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.data.DatasetSource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class VerifyingObserver
extends AbstractDatasetSource {
    private String name;
    private Code identificationCode;
    private String organization;
    private Date dateTime;

    private VerifyingObserver(Attributes attributes) {
        this.name = this.getString(attributes, 4235381);
        this.identificationCode = Code.create((Attributes)attributes, (int)4235400);
        this.organization = this.getString(attributes, 4235303);
        this.dateTime = this.getDate(attributes, 4235312);
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.name, attributes, 4235381, DatasetAccessor.Type.Mandatory);
        this.set((DatasetSource)this.identificationCode, attributes, 4235400, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.organization, attributes, 4235303, DatasetAccessor.Type.Mandatory);
        this.set(this.dateTime, attributes, 4235312, DatasetAccessor.Type.Mandatory);
        return attributes;
    }

    public static VerifyingObserver create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        if (attributes.contains(4235381) && attributes.contains(4235303) && attributes.contains(4235312)) {
            return new VerifyingObserver(attributes);
        }
        return null;
    }

    public static List<VerifyingObserver> createList(Attributes attributes, int n) {
        ArrayList<VerifyingObserver> arrayList = new ArrayList<VerifyingObserver>();
        Sequence sequence = attributes.getSequence(n);
        if (sequence == null) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < sequence.size()) {
            VerifyingObserver verifyingObserver = VerifyingObserver.create((Attributes)sequence.get(n2));
            if (verifyingObserver != null) {
                arrayList.add(verifyingObserver);
            }
            ++n2;
        }
        return arrayList;
    }

    public String getName() {
        return this.name;
    }

    public Code getIdentificationCode() {
        return this.identificationCode;
    }

    public String getOrganization() {
        return this.organization;
    }

    public Date getDataTime() {
        return this.dateTime;
    }
}

