/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.sr;

import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.data.DatasetSource;
import com.agfa.pacs.listtext.dicomobject.module.sr.IdentifiedPersonOrDevice;
import com.agfa.pacs.listtext.dicomobject.type.ParticipationType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class Participant
extends AbstractDatasetSource {
    private ParticipationType participationType;
    private Date participationDateTime;
    private IdentifiedPersonOrDevice identifiedPersonOrDevice;

    private Participant(Attributes attributes) {
        this.participationType = ParticipationType.get(this.getString(attributes, 4235392));
        this.participationDateTime = this.getDate(attributes, 4235394);
        this.identifiedPersonOrDevice = IdentifiedPersonOrDevice.create(attributes);
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.participationType, attributes, 4235392, DatasetAccessor.Type.Mandatory);
        this.set(this.participationDateTime, attributes, 4235394, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set((DatasetSource)this.identifiedPersonOrDevice, attributes);
        return attributes;
    }

    public static Participant create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        if (attributes.contains(4235392) && attributes.contains(4235394)) {
            return new Participant(attributes);
        }
        return null;
    }

    public static List<Participant> createList(Attributes attributes, int n) {
        ArrayList<Participant> arrayList = new ArrayList<Participant>();
        Sequence sequence = attributes.getSequence(n);
        if (sequence == null) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < sequence.size()) {
            Participant participant = Participant.create((Attributes)sequence.get(n2));
            if (participant != null) {
                arrayList.add(participant);
            }
            ++n2;
        }
        return arrayList;
    }

    public IdentifiedPersonOrDevice getIdentifiedPersonOrDevice() {
        return this.identifiedPersonOrDevice;
    }

    public Date getParticipationDateTime() {
        return this.participationDateTime;
    }

    public ParticipationType getParticipationType() {
        return this.participationType;
    }
}

