/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.ps;

import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.listtext.dicomobject.lut.DicomLookupTable;
import com.agfa.pacs.listtext.dicomobject.lut.ILookupTable;
import com.agfa.pacs.listtext.dicomobject.lut.ILookupTableSource;
import com.agfa.pacs.logging.ALogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;

public class VOILookupTable
extends AbstractDatasetSource
implements ILookupTableSource {
    protected String lutExplanation;
    protected int[] lutDescriptor;
    protected byte[] lutData;

    public VOILookupTable() {
    }

    private VOILookupTable(Attributes attributes) {
        this.lutDescriptor = VOILookupTable.getLUTDescriptor((Attributes)attributes);
        this.lutExplanation = this.getString(attributes, 2633731);
        try {
            this.lutData = attributes.getBytes(2633734);
        }
        catch (IOException iOException) {
            ALogger.getLogger(VOILookupTable.class).error("Bulk data error", (Throwable)iOException);
        }
    }

    public static VOILookupTable create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        if (attributes.contains(2633730)) {
            return new VOILookupTable(attributes);
        }
        return null;
    }

    public static List<VOILookupTable> createList(Attributes attributes, int n) {
        Sequence sequence = attributes.getSequence(n);
        if (sequence == null) {
            return Collections.emptyList();
        }
        ArrayList<VOILookupTable> arrayList = new ArrayList<VOILookupTable>(sequence.size());
        int n2 = 0;
        while (n2 < sequence.size()) {
            VOILookupTable vOILookupTable = VOILookupTable.create((Attributes)sequence.get(n2));
            if (vOILookupTable != null && vOILookupTable.hasLookupTable()) {
                arrayList.add(vOILookupTable);
            }
            ++n2;
        }
        return arrayList;
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.lutDescriptor, attributes, 2633730, DatasetAccessor.Type.Mandatory);
        this.set(this.lutExplanation, attributes, 2633731, DatasetAccessor.Type.Optional);
        if (this.lutDescriptor[2] == 16) {
            attributes.setBytes(2633734, VR.OW, this.lutData);
        } else {
            this.set(this.lutData, attributes, 2633734, DatasetAccessor.Type.Mandatory);
        }
        return attributes;
    }

    public void setLUTData(byte[] byArray) {
        this.lutData = byArray;
    }

    public void setLUTDescriptor(int[] nArray) {
        this.lutDescriptor = nArray;
    }

    public void setLUTExplanation(String string) {
        this.lutExplanation = string;
    }

    public String getLutExplanation() {
        return this.lutExplanation;
    }

    @Override
    public ILookupTable getLookupTable() {
        return new DicomLookupTable(this.lutDescriptor, this.lutData, null, this.lutExplanation);
    }

    @Override
    public boolean hasLookupTable() {
        return this.lutDescriptor != null && this.lutData != null;
    }
}

