/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.ps;

import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.listtext.dicomobject.module.ps.IVOILUT;
import com.agfa.pacs.listtext.dicomobject.module.ps.VOILUTFunction;
import com.agfa.pacs.listtext.dicomobject.module.ps.VOILookupTable;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.CompareUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;

public class VOILUT
extends AbstractDatasetSource
implements IVOILUT {
    private static final ALogger log = ALogger.getLogger(VOILUT.class);
    private List<VOILookupTable> voiLookupTables;
    private double[] windowCenter;
    private double[] windowWidth;
    private String[] windowExplanation;
    private VOILUTFunction voiLutFunction;
    private static final char[] infinity = new char[]{'I', 'n', 'f', 'i', 'n', 'i', 't', 'y'};
    private static double[] powerPositive10 = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22, 1.0E23, 1.0E24, 1.0E25, 1.0E26, 1.0E27, 1.0E28, 1.0E29, 1.0E30, 1.0E31, 1.0E32, 1.0E33, 1.0E34, 1.0E35, 1.0E36, 1.0E37, 1.0E38, 1.0E39, 1.0E40, 1.0E41, 1.0E42, 1.0E43, 1.0E44, 1.0E45, 1.0E46, 1.0E47, 1.0E48, 1.0E49, 1.0E50, 1.0E51, 1.0E52, 1.0E53, 1.0E54, 1.0E55, 1.0E56, 1.0E57, 1.0E58, 1.0E59, 1.0E60, 1.0E61, 1.0E62, 1.0E63, 1.0E64, 1.0E65, 1.0E66, 1.0E67, 1.0E68, 1.0E69, 1.0E70, 1.0E71, 1.0E72, 1.0E73, 1.0E74, 1.0E75, 1.0E76, 1.0E77, 1.0E78, 1.0E79, 1.0E80, 1.0E81, 1.0E82, 1.0E83, 1.0E84, 1.0E85, 1.0E86, 1.0E87, 1.0E88, 1.0E89, 1.0E90, 1.0E91, 1.0E92, 1.0E93, 1.0E94, 1.0E95, 1.0E96, 1.0E97, 1.0E98, 1.0E99, 1.0E100, 1.0E101, 1.0E102, 1.0E103, 1.0E104, 1.0E105, 1.0E106, 1.0E107, 1.0E108, 1.0E109, 1.0E110, 1.0E111, 1.0E112, 1.0E113, 1.0E114, 1.0E115, 1.0E116, 1.0E117, 1.0E118, 1.0E119, 1.0E120, 1.0E121, 1.0E122, 1.0E123, 1.0E124, 1.0E125, 1.0E126, 1.0E127, 1.0E128, 1.0E129, 1.0E130, 1.0E131, 1.0E132, 1.0E133, 1.0E134, 1.0E135, 1.0E136, 1.0E137, 1.0E138, 1.0E139, 1.0E140, 1.0E141, 1.0E142, 1.0E143, 1.0E144, 1.0E145, 1.0E146, 1.0E147, 1.0E148, 1.0E149, 1.0E150, 1.0E151, 1.0E152, 1.0E153, 1.0E154, 1.0E155, 1.0E156, 1.0E157, 1.0E158, 1.0E159, 1.0E160, 1.0E161, 1.0E162, 1.0E163, 1.0E164, 1.0E165, 1.0E166, 1.0E167, 1.0E168, 1.0E169, 1.0E170, 1.0E171, 1.0E172, 1.0E173, 1.0E174, 1.0E175, 1.0E176, 1.0E177, 1.0E178, 1.0E179, 1.0E180, 1.0E181, 1.0E182, 1.0E183, 1.0E184, 1.0E185, 1.0E186, 1.0E187, 1.0E188, 1.0E189, 1.0E190, 1.0E191, 1.0E192, 1.0E193, 1.0E194, 1.0E195, 1.0E196, 1.0E197, 1.0E198, 1.0E199, 1.0E200, 1.0E201, 1.0E202, 1.0E203, 1.0E204, 1.0E205, 1.0E206, 1.0E207, 1.0E208, 1.0E209, 1.0E210, 1.0E211, 1.0E212, 1.0E213, 1.0E214, 1.0E215, 1.0E216, 1.0E217, 1.0E218, 1.0E219, 1.0E220, 1.0E221, 1.0E222, 1.0E223, 1.0E224, 1.0E225, 1.0E226, 1.0E227, 1.0E228, 1.0E229, 1.0E230, 1.0E231, 1.0E232, 1.0E233, 1.0E234, 1.0E235, 1.0E236, 1.0E237, 1.0E238, 1.0E239, 1.0E240, 1.0E241, 1.0E242, 1.0E243, 1.0E244, 1.0E245, 1.0E246, 1.0E247, 1.0E248, 1.0E249, 1.0E250, 1.0E251, 1.0E252, 1.0E253, 1.0E254, 1.0E255, 1.0E256, 1.0E257, 1.0E258, 1.0E259, 1.0E260, 1.0E261, 1.0E262, 1.0E263, 1.0E264, 1.0E265, 1.0E266, 1.0E267, 1.0E268, 1.0E269, 1.0E270, 1.0E271, 1.0E272, 1.0E273, 1.0E274, 1.0E275, 1.0E276, 1.0E277, 1.0E278, 1.0E279, 1.0E280, 1.0E281, 1.0E282, 1.0E283, 1.0E284, 1.0E285, 1.0E286, 1.0E287, 1.0E288, 1.0E289, 1.0E290, 1.0E291, 1.0E292, 1.0E293, 1.0E294, 1.0E295, 1.0E296, 1.0E297, 1.0E298, 1.0E299, 1.0E300, 1.0E301, 1.0E302, 1.0E303, 1.0E304, 1.0E305, 1.0E306, 1.0E307, 1.0E308};
    private static double[] powerNegativ10 = new double[]{1.0, 0.1, 0.01, 0.001, 1.0E-4, 1.0E-5, 1.0E-6, 1.0E-7, 1.0E-8, 1.0E-9, 1.0E-10, 1.0E-11, 1.0E-12, 1.0E-13, 1.0E-14, 1.0E-15, 1.0E-16, 1.0E-17, 1.0E-18, 1.0E-19, 1.0E-20, 1.0E-21, 1.0E-22, 1.0E-23, 1.0E-24, 1.0E-25, 1.0E-26, 1.0E-27, 1.0E-28, 1.0E-29, 1.0E-30, 1.0E-31, 1.0E-32, 1.0E-33, 1.0E-34, 1.0E-35, 1.0E-36, 1.0E-37, 1.0E-38, 1.0E-39, 1.0E-40, 1.0E-41, 1.0E-42, 1.0E-43, 1.0E-44, 1.0E-45, 1.0E-46, 1.0E-47, 1.0E-48, 1.0E-49, 1.0E-50, 1.0E-51, 1.0E-52, 1.0E-53, 1.0E-54, 1.0E-55, 1.0E-56, 1.0E-57, 1.0E-58, 1.0E-59, 1.0E-60, 1.0E-61, 1.0E-62, 1.0E-63, 1.0E-64, 1.0E-65, 1.0E-66, 1.0E-67, 1.0E-68, 1.0E-69, 1.0E-70, 1.0E-71, 1.0E-72, 1.0E-73, 1.0E-74, 1.0E-75, 1.0E-76, 1.0E-77, 1.0E-78, 1.0E-79, 1.0E-80, 1.0E-81, 1.0E-82, 1.0E-83, 1.0E-84, 1.0E-85, 1.0E-86, 1.0E-87, 1.0E-88, 1.0E-89, 1.0E-90, 1.0E-91, 1.0E-92, 1.0E-93, 1.0E-94, 1.0E-95, 1.0E-96, 1.0E-97, 1.0E-98, 1.0E-99, 1.0E-100, 1.0E-101, 1.0E-102, 1.0E-103, 1.0E-104, 1.0E-105, 1.0E-106, 1.0E-107, 1.0E-108, 1.0E-109, 1.0E-110, 1.0E-111, 1.0E-112, 1.0E-113, 1.0E-114, 1.0E-115, 1.0E-116, 1.0E-117, 1.0E-118, 1.0E-119, 1.0E-120, 1.0E-121, 1.0E-122, 1.0E-123, 1.0E-124, 1.0E-125, 1.0E-126, 1.0E-127, 1.0E-128, 1.0E-129, 1.0E-130, 1.0E-131, 1.0E-132, 1.0E-133, 1.0E-134, 1.0E-135, 1.0E-136, 1.0E-137, 1.0E-138, 1.0E-139, 1.0E-140, 1.0E-141, 1.0E-142, 1.0E-143, 1.0E-144, 1.0E-145, 1.0E-146, 1.0E-147, 1.0E-148, 1.0E-149, 1.0E-150, 1.0E-151, 1.0E-152, 1.0E-153, 1.0E-154, 1.0E-155, 1.0E-156, 1.0E-157, 1.0E-158, 1.0E-159, 1.0E-160, 1.0E-161, 1.0E-162, 1.0E-163, 1.0E-164, 1.0E-165, 1.0E-166, 1.0E-167, 1.0E-168, 1.0E-169, 1.0E-170, 1.0E-171, 1.0E-172, 1.0E-173, 1.0E-174, 1.0E-175, 1.0E-176, 1.0E-177, 1.0E-178, 1.0E-179, 1.0E-180, 1.0E-181, 1.0E-182, 1.0E-183, 1.0E-184, 1.0E-185, 1.0E-186, 1.0E-187, 1.0E-188, 1.0E-189, 1.0E-190, 1.0E-191, 1.0E-192, 1.0E-193, 1.0E-194, 1.0E-195, 1.0E-196, 1.0E-197, 1.0E-198, 1.0E-199, 1.0E-200, 1.0E-201, 1.0E-202, 1.0E-203, 1.0E-204, 1.0E-205, 1.0E-206, 1.0E-207, 1.0E-208, 1.0E-209, 1.0E-210, 1.0E-211, 1.0E-212, 1.0E-213, 1.0E-214, 1.0E-215, 1.0E-216, 1.0E-217, 1.0E-218, 1.0E-219, 1.0E-220, 1.0E-221, 1.0E-222, 1.0E-223, 1.0E-224, 1.0E-225, 1.0E-226, 1.0E-227, 1.0E-228, 1.0E-229, 1.0E-230, 1.0E-231, 1.0E-232, 1.0E-233, 1.0E-234, 1.0E-235, 1.0E-236, 1.0E-237, 1.0E-238, 1.0E-239, 1.0E-240, 1.0E-241, 1.0E-242, 1.0E-243, 1.0E-244, 1.0E-245, 1.0E-246, 1.0E-247, 1.0E-248, 1.0E-249, 1.0E-250, 1.0E-251, 1.0E-252, 1.0E-253, 1.0E-254, 1.0E-255, 1.0E-256, 1.0E-257, 1.0E-258, 1.0E-259, 1.0E-260, 1.0E-261, 1.0E-262, 1.0E-263, 1.0E-264, 1.0E-265, 1.0E-266, 1.0E-267, 1.0E-268, 1.0E-269, 1.0E-270, 1.0E-271, 1.0E-272, 1.0E-273, 1.0E-274, 1.0E-275, 1.0E-276, 1.0E-277, 1.0E-278, 1.0E-279, 1.0E-280, 1.0E-281, 1.0E-282, 1.0E-283, 1.0E-284, 1.0E-285, 1.0E-286, 1.0E-287, 1.0E-288, 1.0E-289, 1.0E-290, 1.0E-291, 1.0E-292, 1.0E-293, 1.0E-294, 1.0E-295, 1.0E-296, 1.0E-297, 1.0E-298, 1.0E-299, 1.0E-300, 1.0E-301, 1.0E-302, 1.0E-303, 1.0E-304, 1.0E-305, 1.0E-306, 1.0E-307, 1.0E-308, 1.0E-309, 1.0E-310, 1.0E-311, 1.0E-312, 1.0E-313, 1.0E-314, 1.0E-315, 1.0E-316, 1.0E-317, 1.0E-318, 1.0E-319, 1.0E-320, 1.0E-321, 9.9E-323, 9.9E-324};

    private VOILUT() {
        this(new ArrayList<VOILookupTable>(2));
    }

    private VOILUT(double[] dArray, double[] dArray2, String[] stringArray, VOILUTFunction vOILUTFunction) {
        this();
        String[] stringArray2;
        this.voiLutFunction = vOILUTFunction;
        int n = dArray.length;
        if (n != dArray2.length) {
            log.warn("Mismatched window center/width definitions");
            n = Math.min(dArray.length, dArray2.length);
        }
        if ((stringArray2 = stringArray) == null) {
            stringArray2 = new String[n];
        } else {
            if (stringArray2.length != n) {
                log.warn("Mismatched window center/width explanation count (expected: " + n + "; was: " + stringArray2.length + ')');
            }
            stringArray2 = Arrays.copyOf(stringArray2, n);
        }
        this.setWindow(Arrays.copyOf(dArray, n), Arrays.copyOf(dArray2, n), stringArray2);
    }

    private VOILUT(List<VOILookupTable> list) {
        this.voiLookupTables = list;
    }

    public static VOILUT createEmpty() {
        return new VOILUT();
    }

    public static IVOILUT create(double d, double d2) {
        return new SimpleVOILUT(d, d2);
    }

    public static IVOILUT create(double d, double d2, VOILUTFunction vOILUTFunction) {
        if (vOILUTFunction == null) {
            return VOILUT.create(d, d2);
        }
        VOILUT vOILUT = VOILUT.createEmpty();
        vOILUT.setWindowLevelPresets(VOILUT.create(d, d2));
        vOILUT.setVoiLutFunction(vOILUTFunction);
        return vOILUT;
    }

    public static IVOILUT create(double[] dArray, double[] dArray2, String[] stringArray, VOILUTFunction vOILUTFunction) {
        return new VOILUT(dArray, dArray2, stringArray, vOILUTFunction);
    }

    public static IVOILUT create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        IVOILUT iVOILUT = VOILUT.createSimpleVOILUT(attributes);
        if (attributes.contains(2633744)) {
            try {
                VOILUT vOILUT = new VOILUT(VOILookupTable.createList(attributes, 2633744));
                vOILUT.setWindowLevelPresets(iVOILUT);
                vOILUT.setVoiLutFunction(VOILUTFunction.get(attributes.getString(2625622)));
                iVOILUT = vOILUT;
            }
            catch (Exception exception) {
                log.error("Could not parse VOI LUT", (Throwable)exception);
                return null;
            }
        }
        return iVOILUT;
    }

    private static IVOILUT createSimpleVOILUT(Attributes attributes) {
        if (attributes.containsValue(2625616) && attributes.containsValue(2625617)) {
            try {
                return VOILUT.createSimpleVOILUTBasic(attributes);
            }
            catch (Exception exception) {
                try {
                    return VOILUT.createSimpleVOILUTAdvanced(attributes);
                }
                catch (Exception exception2) {
                    log.error("Could not parse VOI LUT", (Throwable)exception2);
                    return null;
                }
            }
        }
        return null;
    }

    private static IVOILUT createSimpleVOILUTBasic(Attributes attributes) {
        double[] dArray = attributes.getDoubles(2625616);
        double[] dArray2 = attributes.getDoubles(2625617);
        VOILUTFunction vOILUTFunction = VOILUTFunction.get(attributes.getString(2625622));
        if (dArray.length == 1 && dArray2.length == 1) {
            return VOILUT.create(dArray[0], dArray2[0], vOILUTFunction);
        }
        return VOILUT.create(dArray, dArray2, VOILUT.readWindowExplanations(attributes), vOILUTFunction);
    }

    private static IVOILUT createSimpleVOILUTAdvanced(Attributes attributes) {
        String[] stringArray = attributes.getStrings(2625616);
        String[] stringArray2 = attributes.getStrings(2625617);
        VOILUTFunction vOILUTFunction = VOILUTFunction.get(attributes.getString(2625622));
        if (stringArray.length == 1 && stringArray2.length == 1) {
            return VOILUT.create(VOILUT.parseDouble(stringArray[0]), VOILUT.parseDouble(stringArray2[0]), vOILUTFunction);
        }
        int n = stringArray.length;
        if (n != stringArray2.length) {
            log.warn("Mismatched window center/width definitions");
            n = Math.min(stringArray.length, stringArray2.length);
        }
        String[] stringArray3 = VOILUT.readWindowExplanations(attributes);
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        String[] stringArray4 = new String[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            Double d = VOILUT.parseDouble(stringArray[n3]);
            Double d2 = VOILUT.parseDouble(stringArray2[n3]);
            if (d == null || d2 == null) {
                log.warn("Illegal window center/width definition: " + stringArray[n3] + '/' + stringArray2[n3]);
            } else {
                dArray[n2] = d;
                dArray2[n2] = d2;
                if (stringArray3 != null && stringArray3.length > n3) {
                    stringArray4[n2] = stringArray3[n3];
                }
                ++n2;
            }
            ++n3;
        }
        if (n2 < dArray.length) {
            dArray = Arrays.copyOf(dArray, n2);
            dArray2 = Arrays.copyOf(dArray2, n2);
            stringArray4 = Arrays.copyOf(stringArray4, n2);
        }
        return VOILUT.create(dArray, dArray2, stringArray4, vOILUTFunction);
    }

    private static String[] readWindowExplanations(Attributes attributes) {
        try {
            return attributes.getStrings(2625621);
        }
        catch (Exception exception) {
            log.error("Reading window center/width explanations failed.", (Throwable)exception);
            return null;
        }
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.toDataset(attributes);
        return attributes;
    }

    @Override
    public void toDataset(Attributes attributes) {
        this.set(this.voiLookupTables, attributes, 2633744, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.windowCenter, attributes, 2625616, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.windowWidth, attributes, 2625617, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.windowExplanation, attributes, 2625621, DatasetAccessor.Type.Optional);
        this.set(this.voiLutFunction, attributes, 2625622, DatasetAccessor.Type.Optional);
    }

    @Override
    public boolean hasWindow() {
        return this.windowCenter != null && this.windowWidth != null;
    }

    @Override
    public List<VOILookupTable> voiLookupTables() {
        return this.voiLookupTables;
    }

    @Override
    public double getWindowCenter() {
        return this.windowCenter[0];
    }

    @Override
    public double getWindowWidth() {
        return this.windowWidth[0];
    }

    @Override
    public double[] getWindowCenters() {
        return this.windowCenter;
    }

    @Override
    public double[] getWindowWidths() {
        return this.windowWidth;
    }

    @Override
    public String[] getWindowExplanations() {
        return this.windowExplanation;
    }

    @Override
    public VOILUTFunction getVoiLutFunction() {
        return this.voiLutFunction;
    }

    public void setVoiLutFunction(VOILUTFunction vOILUTFunction) {
        this.voiLutFunction = vOILUTFunction;
    }

    public void setWindowLevelPresets(IVOILUT iVOILUT) {
        if (iVOILUT != null && iVOILUT.hasWindow()) {
            this.setWindow(iVOILUT.getWindowCenters(), iVOILUT.getWindowWidths(), iVOILUT.getWindowExplanations());
        }
    }

    private void setWindow(double[] dArray, double[] dArray2, String[] stringArray) throws IllegalArgumentException {
        if (dArray.length != dArray2.length || dArray2.length != stringArray.length) {
            throw new IllegalArgumentException("Unequal array length for window definition");
        }
        if (dArray.length > 0) {
            this.windowCenter = dArray;
            this.windowWidth = dArray2;
            this.windowExplanation = stringArray;
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof VOILUT)) {
            return false;
        }
        VOILUT vOILUT = (VOILUT)object;
        return CompareUtils.equals(this.voiLookupTables, vOILUT.voiLookupTables) && Arrays.equals(this.windowCenter, vOILUT.windowCenter) && Arrays.equals(this.windowWidth, vOILUT.windowWidth) && Arrays.equals(this.windowExplanation, vOILUT.windowExplanation) && CompareUtils.equals((Object)((Object)this.voiLutFunction), (Object)((Object)vOILUT.voiLutFunction));
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        hashCodeBuilder.append(this.voiLookupTables);
        hashCodeBuilder.append(this.windowCenter);
        hashCodeBuilder.append(this.windowWidth);
        hashCodeBuilder.append((Object[])this.windowExplanation);
        hashCodeBuilder.append((Object)this.voiLutFunction);
        return hashCodeBuilder.toHashCode();
    }

    /*
     * Unable to fully structure code
     */
    public static Double parseDouble(String var0) {
        block22: {
            block23: {
                block26: {
                    block24: {
                        block25: {
                            if (var0 == null) {
                                return null;
                            }
                            var1_1 = false;
                            var3_2 = 0;
                            var4_3 = var0.length();
                            var5_4 = 0L;
                            var7_5 = 0L;
                            var9_6 = 0;
                            var10_7 = false;
                            var11_8 = 0;
                            var12_9 = 48;
                            var0 = var0.trim();
                            if (var4_3 == 0) {
                                return null;
                            }
                            var2_10 = var0.charAt(var3_2);
                            if (var2_10 == '-') {
                                var1_1 = true;
                                if (var4_3 == 1) {
                                    return null;
                                }
                                var2_10 = var0.charAt(++var3_2);
                            } else if (var2_10 == '+') {
                                if (var4_3 == 1) {
                                    return null;
                                }
                                var2_10 = var0.charAt(++var3_2);
                            }
                            if (var2_10 == 'N') {
                                if (var0.length() != 3) {
                                    return null;
                                }
                                if ((var2_10 = var0.charAt(++var3_2)) != 'a') {
                                    return null;
                                }
                                var2_10 = var0.charAt(var3_2);
                                if (var2_10 != 'N') {
                                    return null;
                                }
                                return NaN;
                            }
                            if (var2_10 != 'I') ** GOTO lbl49
                            if (var0.length() == VOILUT.infinity.length) ** GOTO lbl41
                            return null;
lbl-1000:
                            // 1 sources

                            {
                                if (var0.charAt(var3_2) != VOILUT.infinity[var3_2]) {
                                    return null;
                                }
                                ++var3_2;
lbl41:
                                // 2 sources

                                ** while (var3_2 < var0.length())
                            }
lbl42:
                            // 1 sources

                            return var1_1 != false ? -Infinity : Infinity;
lbl-1000:
                            // 1 sources

                            {
                                var5_4 *= 10L;
                                var5_4 += (long)(var2_10 - var12_9);
                                if (var3_2 < var4_3 - 1) {
                                    var2_10 = var0.charAt(++var3_2);
                                    continue;
                                }
                                return VOILUT.toDouble(var1_1 != false ? -var5_4 : var5_4, 0L, 0, 0);
lbl49:
                                // 2 sources

                                ** while (VOILUT.isDecimalDigit((char)var2_10))
                            }
lbl50:
                            // 1 sources

                            if (var2_10 == '.') {
                                if (var3_2 < var4_3 - 1) {
                                    var2_10 = var0.charAt(++var3_2);
                                    while (VOILUT.isDecimalDigit(var2_10)) {
                                        var7_5 *= 10L;
                                        var7_5 += (long)(var2_10 - var12_9);
                                        ++var11_8;
                                        if (var3_2 < var4_3 - 1) {
                                            var2_10 = var0.charAt(++var3_2);
                                            continue;
                                        }
                                        return VOILUT.toDouble(var1_1 != false ? -var5_4 : var5_4, var7_5, 0, var11_8);
                                    }
                                } else {
                                    return VOILUT.toDouble(var1_1 != false ? -var5_4 : var5_4, 0L, 0, 0);
                                }
                            }
                            if (var2_10 != 'e' && var2_10 != 'E') break block22;
                            if (var3_2 >= var4_3 - 1) break block23;
                            if ((var2_10 = var0.charAt(++var3_2)) != '-') break block24;
                            var10_7 = true;
                            if (var3_2 >= var4_3 - 1) break block25;
                            var2_10 = var0.charAt(++var3_2);
                            ** GOTO lbl86
                        }
                        return VOILUT.toDouble(var1_1 != false ? -var5_4 : var5_4, var7_5, 0, var11_8);
                    }
                    if (var2_10 != '+') ** GOTO lbl86
                    if (var3_2 >= var4_3 - 1) break block26;
                    var2_10 = var0.charAt(++var3_2);
                    if (true) ** GOTO lbl86
                }
                return VOILUT.toDouble(var1_1 != false ? -var5_4 : var5_4, var7_5, 0, var11_8);
                do {
                    var9_6 *= 10;
                    var9_6 += var2_10 - var12_9;
                    if (var3_2 < var4_3 - 1) {
                        var2_10 = var0.charAt(++var3_2);
                        continue;
                    }
                    return VOILUT.toDouble(var1_1 != false ? -var5_4 : var5_4, var7_5, var10_7 != false ? -var9_6 : var9_6, var11_8);
lbl86:
                    // 4 sources

                } while (VOILUT.isDecimalDigit(var2_10));
                break block22;
            }
            return VOILUT.toDouble(var1_1 != false ? -var5_4 : var5_4, var7_5, 0, var11_8);
        }
        return VOILUT.toDouble(var1_1 != false ? -var5_4 : var5_4, var7_5, var10_7 != false ? -var9_6 : var9_6, var11_8);
    }

    private static Double toDouble(long l, long l2, int n, int n2) {
        boolean bl = l < 0L;
        int n3 = n - n2;
        double d = n < 0 ? powerNegativ10[-n] : powerPositive10[n];
        double d2 = n3 < 0 ? powerNegativ10[-n3] : powerPositive10[n];
        if (bl) {
            l = -l;
        }
        double d3 = l2 != 0L ? (double)l * d + d2 * (double)l2 : (double)l * d;
        if (bl) {
            d3 = -d3;
        }
        return d3;
    }

    private static boolean isDecimalDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static class SimpleVOILUT
    implements IVOILUT {
        private double center;
        private double width;

        public SimpleVOILUT(double d, double d2) {
            this.center = d;
            this.width = d2;
        }

        @Override
        public double getWindowCenter() {
            return this.center;
        }

        @Override
        public double getWindowWidth() {
            return this.width;
        }

        @Override
        public void toDataset(Attributes attributes) {
            attributes.setDouble(2625616, VR.DS, new double[]{this.center});
            attributes.setDouble(2625617, VR.DS, new double[]{this.width});
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("C/W:");
            stringBuilder.append(this.center).append('/').append(this.width);
            return stringBuilder.toString();
        }

        public boolean equals(Object object) {
            if (object instanceof SimpleVOILUT) {
                SimpleVOILUT simpleVOILUT = (SimpleVOILUT)object;
                return simpleVOILUT.center == this.center && simpleVOILUT.width == this.width;
            }
            return false;
        }

        public int hashCode() {
            return Double.valueOf(this.width).hashCode() ^ Double.valueOf(this.center).hashCode();
        }

        @Override
        public boolean hasWindow() {
            return true;
        }

        @Override
        public double[] getWindowCenters() {
            return new double[]{this.center};
        }

        @Override
        public double[] getWindowWidths() {
            return new double[]{this.width};
        }

        @Override
        public String[] getWindowExplanations() {
            return new String[1];
        }

        @Override
        public VOILUTFunction getVoiLutFunction() {
            return null;
        }

        @Override
        public List<VOILookupTable> voiLookupTables() {
            return Collections.emptyList();
        }
    }
}

