/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.ps;

import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedImage;
import com.agfa.pacs.listtext.dicomobject.interfaces.IImageReferencing;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class ReferencedSeries
extends AbstractDatasetSource
implements IImageReferencing {
    private String seriesInstanceUID;
    private String retrieveAET;
    private Map<String, ReferencedImage> referencedImages;

    public ReferencedSeries() {
        this.referencedImages = new LinkedHashMap<String, ReferencedImage>();
    }

    private ReferencedSeries(Attributes attributes) {
        this.seriesInstanceUID = this.getString(attributes, 0x20000E);
        this.retrieveAET = this.getString(attributes, 524372);
        this.referencedImages = ReferencedImage.createMap(attributes, 528704);
    }

    public static ReferencedSeries create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        if (attributes.contains(0x20000E) && attributes.contains(528704)) {
            return new ReferencedSeries(attributes);
        }
        return null;
    }

    public static List<ReferencedSeries> createList(Attributes attributes, int n) {
        ArrayList<ReferencedSeries> arrayList = new ArrayList<ReferencedSeries>();
        Sequence sequence = attributes.getSequence(n);
        if (sequence != null) {
            int n2 = 0;
            while (n2 < sequence.size()) {
                ReferencedSeries referencedSeries = ReferencedSeries.create((Attributes)sequence.get(n2));
                if (referencedSeries != null) {
                    arrayList.add(referencedSeries);
                }
                ++n2;
            }
        }
        return arrayList;
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.seriesInstanceUID, attributes, 0x20000E, DatasetAccessor.Type.Mandatory);
        this.set(this.retrieveAET, attributes, 524372, DatasetAccessor.Type.Optional);
        this.set(this.referencedImages.values(), attributes, 528704, DatasetAccessor.Type.Mandatory);
        return attributes;
    }

    public String getSeriesInstanceUID() {
        return this.seriesInstanceUID;
    }

    public String getRetrieveAET() {
        return this.retrieveAET;
    }

    @Override
    public Map<String, ReferencedImage> referencedImages() {
        return this.referencedImages;
    }

    public void setSeriesInstanceUID(String string) {
        this.seriesInstanceUID = string;
    }
}

