/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.ps;

import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.listtext.dicomobject.module.AbstractModule;
import com.agfa.pacs.listtext.dicomobject.module.ps.OverlayPlane;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;

public class OverlayPlaneModule
extends AbstractModule {
    private List<OverlayPlane> overlayPlanes = new ArrayList<OverlayPlane>();

    public OverlayPlaneModule() {
        super(Level.Object);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean containsModule(Attributes attributes) {
        int n = 0;
        while (n < 16) {
            int n2 = n * 2 << 16;
            if (attributes.contains(0x60000040 + n2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public void readFrom(Attributes attributes) {
        int n = 0;
        while (n < 16) {
            OverlayPlane overlayPlane = OverlayPlane.create(attributes, n * 2 << 16);
            if (overlayPlane != null) {
                this.overlayPlanes.add(overlayPlane);
            }
            ++n;
        }
    }

    @Override
    public void writeTo(Attributes attributes) {
        int n = 0;
        for (OverlayPlane overlayPlane : this.overlayPlanes) {
            attributes.addAll(overlayPlane.writeToGroup(n << 16));
            n += 2;
        }
    }

    public List<OverlayPlane> overlayPlanes() {
        return this.overlayPlanes;
    }

    public boolean hasEmbeddedOverlays() {
        for (OverlayPlane overlayPlane : this.overlayPlanes) {
            if (overlayPlane.getOverlayBitPosition() <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean hasOverlays(Attributes attributes) {
        return attributes.contains(0x60000040);
    }
}

