/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.print;

import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.listtext.dicomobject.module.print.ImageFormat;
import com.agfa.pacs.listtext.dicomobject.module.print.Media;
import com.agfa.pacs.listtext.dicomobject.type.print.DecimateCropResult;
import com.agfa.pacs.listtext.dicomobject.type.print.MagnificationType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class PrinterConfigurationItem
extends AbstractDatasetSource {
    private String[] sopClassesSupported;
    private Integer maximumMemoryAllocation;
    private Integer printingBitDepth;
    private Integer memoryBitDepth;
    private List<Media> otherMediaAvailable;
    private List<Media> installedMedia;
    private List<ImageFormat> supportedImageFormats;
    private Integer defaultPrinterDPI = null;
    private MagnificationType defaultMagnificationType;
    private List<MagnificationType> otherMagnificationTypesAvailable;
    private String defaultSmoothingType;
    private String[] otherSmoothingTypesAvailable;
    private String configurationInformation;
    private Integer maximumCollatedFilms;
    private DecimateCropResult decimateCropResult;
    private Map<Integer, String> annotationBoxes;
    private String annotationID;
    private boolean setCharacterSet = true;

    public PrinterConfigurationItem() {
        this.otherMediaAvailable = new ArrayList<Media>();
        this.installedMedia = new ArrayList<Media>();
        this.supportedImageFormats = new ArrayList<ImageFormat>();
        this.otherMagnificationTypesAvailable = new ArrayList<MagnificationType>();
        this.decimateCropResult = DecimateCropResult.FailIfReqDCNotSupp;
    }

    protected PrinterConfigurationItem(Attributes attributes) {
        this.sopClassesSupported = this.getStrings(attributes, 528730);
        this.maximumMemoryAllocation = this.getInteger(attributes, 536871009);
        this.memoryBitDepth = this.getInteger(attributes, 0x200000A0);
        this.printingBitDepth = this.getInteger(attributes, 536871073);
        this.installedMedia = Media.createList(attributes, 0x200000A2);
        this.otherMediaAvailable = Media.createList(attributes, 536871076);
        this.supportedImageFormats = ImageFormat.createList(attributes, 536871080);
        this.defaultMagnificationType = MagnificationType.get(this.getString(attributes, 537919654));
        this.otherMagnificationTypesAvailable = MagnificationType.getList(this.getStrings(attributes, 537919655));
        this.defaultSmoothingType = this.getString(attributes, 537919656);
        this.otherSmoothingTypesAvailable = this.getStrings(attributes, 537919657);
        this.configurationInformation = this.getString(attributes, 537919826);
        this.maximumCollatedFilms = this.getInteger(attributes, 537919828);
        this.decimateCropResult = DecimateCropResult.get(this.getString(attributes, 0x202000A2));
    }

    public static PrinterConfigurationItem create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        return new PrinterConfigurationItem(attributes);
    }

    public static List<PrinterConfigurationItem> createList(Attributes attributes, int n) {
        ArrayList<PrinterConfigurationItem> arrayList = new ArrayList<PrinterConfigurationItem>();
        Sequence sequence = attributes.getSequence(n);
        if (sequence == null) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < sequence.size()) {
            PrinterConfigurationItem printerConfigurationItem = PrinterConfigurationItem.create((Attributes)sequence.get(n2));
            if (printerConfigurationItem != null) {
                arrayList.add(printerConfigurationItem);
            }
            ++n2;
        }
        return arrayList;
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.sopClassesSupported, attributes, 528730, DatasetAccessor.Type.Mandatory);
        this.set(this.maximumMemoryAllocation, attributes, 536871009, DatasetAccessor.Type.Mandatory);
        this.set(this.memoryBitDepth, attributes, 0x200000A0, DatasetAccessor.Type.Mandatory);
        this.set(this.printingBitDepth, attributes, 536871073, DatasetAccessor.Type.Mandatory);
        this.set(this.installedMedia, attributes, 0x200000A2, DatasetAccessor.Type.Mandatory);
        this.set(this.otherMediaAvailable, attributes, 536871076, DatasetAccessor.Type.Mandatory);
        this.set(this.supportedImageFormats, attributes, 536871080, DatasetAccessor.Type.Mandatory);
        this.set(this.defaultMagnificationType, attributes, 537919654, DatasetAccessor.Type.Mandatory);
        this.set(this.otherMagnificationTypesAvailable, attributes, 537919655, DatasetAccessor.Type.Mandatory);
        this.set(this.defaultSmoothingType, attributes, 537919656, DatasetAccessor.Type.Mandatory);
        this.set(this.otherSmoothingTypesAvailable, attributes, 537919657, DatasetAccessor.Type.Mandatory);
        this.set(this.configurationInformation, attributes, 537919826, DatasetAccessor.Type.Mandatory);
        this.set(this.maximumCollatedFilms, attributes, 537919828, DatasetAccessor.Type.Mandatory);
        this.set(this.decimateCropResult, attributes, 0x202000A2, DatasetAccessor.Type.Mandatory);
        return attributes;
    }

    public boolean isSetCharacterSet() {
        return this.setCharacterSet;
    }

    public void setSetCharacterSet(boolean bl) {
        this.setCharacterSet = bl;
    }

    public String getConfigurationInformation() {
        return this.configurationInformation;
    }

    public void setConfigurationInformation(String string) {
        this.configurationInformation = string;
    }

    public DecimateCropResult getDecimateCropResult() {
        return this.decimateCropResult;
    }

    public void setDecimateCropResult(DecimateCropResult decimateCropResult) {
        this.decimateCropResult = decimateCropResult;
    }

    public MagnificationType getDefaultMagnificationType() {
        return this.defaultMagnificationType;
    }

    public void setDefaultMagnificationType(MagnificationType magnificationType) {
        this.defaultMagnificationType = magnificationType;
    }

    public Integer getPrinterDPI() {
        return this.defaultPrinterDPI;
    }

    public void setPrinterDPI(Integer n) {
        this.defaultPrinterDPI = n;
    }

    public String getDefaultSmoothingType() {
        return this.defaultSmoothingType;
    }

    public void setDefaultSmoothingType(String string) {
        this.defaultSmoothingType = string;
    }

    public Integer getMaximumCollatedFilms() {
        return this.maximumCollatedFilms;
    }

    public void setMaximumCollatedFilms(Integer n) {
        this.maximumCollatedFilms = n;
    }

    public Integer getMaximumMemoryAllocation() {
        return this.maximumMemoryAllocation;
    }

    public void setMaximumMemoryAllocation(Integer n) {
        this.maximumMemoryAllocation = n;
    }

    public Integer getMemoryBitDepth() {
        return this.memoryBitDepth;
    }

    public void setMemoryBitDepth(Integer n) {
        this.memoryBitDepth = n;
    }

    public String[] getOtherSmoothingTypesAvailable() {
        return this.otherSmoothingTypesAvailable;
    }

    public void setOtherSmoothingTypesAvailable(String[] stringArray) {
        this.otherSmoothingTypesAvailable = stringArray;
    }

    public Integer getPrintingBitDepth() {
        return this.printingBitDepth;
    }

    public void setPrintingBitDepth(Integer n) {
        this.printingBitDepth = n;
    }

    public String[] getSopClassesSupported() {
        return this.sopClassesSupported;
    }

    public void setSopClassesSupported(String[] stringArray) {
        this.sopClassesSupported = stringArray;
    }

    public Map<Integer, String> getAnnotationBoxes() {
        if (this.annotationBoxes == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.annotationBoxes);
    }

    public void setAnnotationBoxes(Map<Integer, String> map) {
        this.annotationBoxes = map;
    }

    public List<Media> installedMedia() {
        return this.installedMedia;
    }

    public List<MagnificationType> otherMagnificationTypesAvailable() {
        return this.otherMagnificationTypesAvailable;
    }

    public List<Media> otherMediaAvailable() {
        return this.otherMediaAvailable;
    }

    public List<ImageFormat> supportedImageFormats() {
        return this.supportedImageFormats;
    }

    public String getAnnotationID() {
        return this.annotationID;
    }

    public void setAnnotationID(String string) {
        this.annotationID = string;
    }
}

