/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.print;

import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.dicom.DicomEnum;
import com.agfa.pacs.data.shared.dicom.YesNo;
import com.agfa.pacs.listtext.dicomobject.type.print.FilmOrientation;
import com.agfa.pacs.listtext.dicomobject.type.print.FilmSizeID;
import com.agfa.pacs.listtext.dicomobject.type.print.ResolutionID;
import com.agfa.pacs.listtext.dicomobject.type.print.imagedisplayformat.ImageDisplayFormat;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class ImageFormat
extends AbstractDatasetSource {
    private Integer rows;
    private Integer columns;
    private ImageDisplayFormat imageDisplayFormat;
    private FilmOrientation filmOrientation;
    private FilmSizeID filmSizeID;
    private ResolutionID printerResolutionID;
    private double[] printerPixelSpacing = null;
    private YesNo requestedImageSizeFlag;

    public ImageFormat() {
    }

    public ImageFormat(ImageDisplayFormat imageDisplayFormat, FilmOrientation filmOrientation, FilmSizeID filmSizeID, YesNo yesNo) {
        this.imageDisplayFormat = imageDisplayFormat;
        this.filmOrientation = filmOrientation;
        this.filmSizeID = filmSizeID;
        this.printerResolutionID = ResolutionID.Standard;
        this.requestedImageSizeFlag = yesNo;
    }

    private ImageFormat(Attributes attributes) {
        this.rows = this.getInteger(attributes, 2621456);
        this.columns = this.getInteger(attributes, 2621457);
        this.imageDisplayFormat = ImageDisplayFormat.get(this.getString(attributes, 0x20100010));
        this.filmOrientation = FilmOrientation.get(this.getString(attributes, 537919552));
        this.filmSizeID = FilmSizeID.get(this.getString(attributes, 537919568));
        this.printerResolutionID = ResolutionID.get(this.getString(attributes, 537919570));
        this.printerPixelSpacing = this.getDoubles(attributes, 537920374);
        this.requestedImageSizeFlag = YesNo.get((String)this.getString(attributes, 0x202000A0));
    }

    public static ImageFormat create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        return new ImageFormat(attributes);
    }

    public static List<ImageFormat> createList(Attributes attributes, int n) {
        ArrayList<ImageFormat> arrayList = new ArrayList<ImageFormat>();
        Sequence sequence = attributes.getSequence(n);
        if (sequence == null) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < sequence.size()) {
            ImageFormat imageFormat = ImageFormat.create((Attributes)sequence.get(n2));
            if (imageFormat != null) {
                arrayList.add(imageFormat);
            }
            ++n2;
        }
        return arrayList;
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.rows, attributes, 2621456, DatasetAccessor.Type.Mandatory);
        this.set(this.columns, attributes, 2621457, DatasetAccessor.Type.Mandatory);
        this.set(this.imageDisplayFormat.dicom(), attributes, 0x20100010, DatasetAccessor.Type.Mandatory);
        this.set(this.filmOrientation, attributes, 537919552, DatasetAccessor.Type.Mandatory);
        this.set(this.filmSizeID, attributes, 537919568, DatasetAccessor.Type.Mandatory);
        this.set(this.printerResolutionID, attributes, 537919570, DatasetAccessor.Type.Mandatory);
        this.set(this.printerPixelSpacing, attributes, 537920374, DatasetAccessor.Type.Mandatory);
        this.set((DicomEnum)this.requestedImageSizeFlag, attributes, 0x202000A0, DatasetAccessor.Type.Mandatory);
        return attributes;
    }

    public Integer getColumns() {
        return this.columns;
    }

    public void setColumns(Integer n) {
        this.columns = n;
    }

    public FilmOrientation getFilmOrientation() {
        return this.filmOrientation;
    }

    public void setFilmOrientation(FilmOrientation filmOrientation) {
        this.filmOrientation = filmOrientation;
    }

    public FilmSizeID getFilmSizeID() {
        return this.filmSizeID;
    }

    public void setFilmSizeID(FilmSizeID filmSizeID) {
        this.filmSizeID = filmSizeID;
    }

    public ImageDisplayFormat getImageDisplayFormat() {
        return this.imageDisplayFormat;
    }

    public void setImageDisplayFormat(ImageDisplayFormat imageDisplayFormat) {
        this.imageDisplayFormat = imageDisplayFormat;
    }

    public double[] getPrinterPixelSpacing() {
        return this.printerPixelSpacing;
    }

    public void setPrinterPixelSpacing(double[] dArray) {
        this.printerPixelSpacing = dArray;
    }

    public ResolutionID getPrinterResolutionID() {
        return this.printerResolutionID;
    }

    public void setPrinterResolutionID(ResolutionID resolutionID) {
        this.printerResolutionID = resolutionID;
    }

    public YesNo getRequestedImageSizeFlag() {
        return this.requestedImageSizeFlag;
    }

    public void setRequestedImageSizeFlag(YesNo yesNo) {
        this.requestedImageSizeFlag = yesNo;
    }

    public Integer getRows() {
        return this.rows;
    }

    public void setRows(Integer n) {
        this.rows = n;
    }
}

