/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.patient;

import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.listtext.dicomobject.module.AbstractModule;
import com.agfa.pacs.listtext.dicomobject.module.patient.PertinentDocument;
import java.util.Date;
import java.util.List;
import org.dcm4che3.data.Attributes;

public class PatientMedicalModule
extends AbstractModule {
    private String[] medicalAlerts;
    private String[] contrastAllergies;
    private String smokingStatus;
    private String additionalPatientHistory;
    private String pregnancyStatus;
    private String[] specialNeeds;
    private String[] patientState;
    private Date lastMenstrualDate;
    private List<PertinentDocument> pertinentDocuments;

    public PatientMedicalModule() {
        super(Level.Patient);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean containsModule(Attributes attributes) {
        return true;
    }

    @Override
    public void readFrom(Attributes attributes) {
        this.medicalAlerts = this.getStrings(attributes, 0x102000);
        this.contrastAllergies = this.getStrings(attributes, 0x102110);
        this.smokingStatus = this.getString(attributes, 1057184);
        this.additionalPatientHistory = this.getString(attributes, 1057200);
        this.pregnancyStatus = this.getString(attributes, 1057216);
        this.lastMenstrualDate = this.getDate(attributes, 1057232);
        this.specialNeeds = this.getStrings(attributes, 3670096);
        this.patientState = this.getStrings(attributes, 3671296);
        this.pertinentDocuments = PertinentDocument.createList(attributes, 3670272);
    }

    @Override
    public void writeTo(Attributes attributes) {
        this.set(this.medicalAlerts, attributes, 0x102000, DatasetAccessor.Type.Mandatory);
        this.set(this.contrastAllergies, attributes, 0x102110, DatasetAccessor.Type.Mandatory);
        this.set(this.smokingStatus, attributes, 1057184, DatasetAccessor.Type.Mandatory);
        this.set(this.additionalPatientHistory, attributes, 1057200, DatasetAccessor.Type.Mandatory);
        this.set(this.pregnancyStatus, attributes, 1057216, DatasetAccessor.Type.Mandatory);
        this.set(this.lastMenstrualDate, attributes, 1057232, DatasetAccessor.Type.Mandatory);
        this.set(this.specialNeeds, attributes, 3670096, DatasetAccessor.Type.Mandatory);
        this.set(this.patientState, attributes, 3671296, DatasetAccessor.Type.Mandatory);
        this.set(this.pertinentDocuments, attributes, 3670272, DatasetAccessor.Type.Mandatory);
    }

    public String getAdditionalPatientHistory() {
        return this.additionalPatientHistory;
    }

    public void setAdditionalPatientHistory(String string) {
        this.additionalPatientHistory = string;
    }

    public String[] getContrastAllergies() {
        return this.contrastAllergies;
    }

    public void setContrastAllergies(String[] stringArray) {
        this.contrastAllergies = stringArray;
    }

    public Date getLastMenstrualDate() {
        return this.lastMenstrualDate;
    }

    public void setLastMenstrualDate(Date date) {
        this.lastMenstrualDate = date;
    }

    public String[] getMedicalAlerts() {
        return this.medicalAlerts;
    }

    public void setMedicalAlerts(String[] stringArray) {
        this.medicalAlerts = stringArray;
    }

    public String[] getPatientState() {
        return this.patientState;
    }

    public void setPatientState(String[] stringArray) {
        this.patientState = stringArray;
    }

    public String getPregnancyStatus() {
        return this.pregnancyStatus;
    }

    public void setPregnancyStatus(String string) {
        this.pregnancyStatus = string;
    }

    public String getSmokingStatus() {
        return this.smokingStatus;
    }

    public void setSmokingStatus(String string) {
        this.smokingStatus = string;
    }

    public String[] getSpecialNeeds() {
        return this.specialNeeds;
    }

    public void setSpecialNeeds(String[] stringArray) {
        this.specialNeeds = stringArray;
    }

    public List<PertinentDocument> pertinentDocuments() {
        return this.pertinentDocuments;
    }
}

