/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.patient;

import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.data.DatasetSource;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.listtext.dicomobject.module.AbstractModule;
import com.agfa.pacs.listtext.dicomobject.module.patient.LanguageCode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.dcm4che3.data.Attributes;

public class PatientDemographicModule
extends AbstractModule {
    private String patientAge;
    private String occupation;
    private String confidentialityPatientData;
    private Date patientBirthTime;
    private String patientSex;
    private Date patientBirthDate;
    private List<Code> patientInsurancePlan;
    private String patientSize;
    private String[] patientWeight;
    private String[] patientAddress;
    private String militaryRank;
    private String branchOfService;
    private String countryOfResidence;
    private String regionOfResidence;
    private String[] patientPhoneNumbers;
    private String ethnicGroup;
    private String patientReligiousPreference;
    private String patientComments;
    private List<LanguageCode> patientPrimaryLanguage = new ArrayList<LanguageCode>();
    private String responsiblePerson;
    private String responsiblePersonRole;
    private String responsibleOrganization;
    private String patientSpeciesDescription;
    private String patientBreedDescription;
    private Code patientSpecies;
    private Code patientBreed;

    public PatientDemographicModule() {
        super(Level.Patient);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean containsModule(Attributes attributes) {
        return true;
    }

    @Override
    public void readFrom(Attributes attributes) {
        this.patientAge = this.getString(attributes, 0x101010);
        this.occupation = this.getString(attributes, 1057152);
        this.confidentialityPatientData = this.getString(attributes, 4206593);
        this.patientBirthDate = this.getDate(attributes, 0x100030);
        this.patientBirthTime = this.getDate(attributes, 1048626);
        this.patientSex = this.getString(attributes, 0x100040);
        this.patientInsurancePlan = Code.createList((Attributes)attributes, (int)0x100050);
        this.patientPrimaryLanguage = LanguageCode.createList(attributes, 0x100101);
        this.patientSize = this.getString(attributes, 0x101020);
        this.patientWeight = this.getStrings(attributes, 0x101030);
        this.patientAddress = this.getStrings(attributes, 0x101040);
        this.militaryRank = this.getString(attributes, 0x101080);
        this.branchOfService = this.getString(attributes, 0x101081);
        this.countryOfResidence = this.getString(attributes, 1057104);
        this.regionOfResidence = this.getString(attributes, 1057106);
        this.patientPhoneNumbers = this.getStrings(attributes, 1057108);
        this.ethnicGroup = this.getString(attributes, 1057120);
        this.patientReligiousPreference = this.getString(attributes, 1057264);
        this.patientComments = this.getString(attributes, 0x104000);
        this.responsiblePerson = this.getString(attributes, 1057431);
        this.responsiblePersonRole = this.getString(attributes, 1057432);
        this.responsibleOrganization = this.getString(attributes, 1057433);
        this.patientSpeciesDescription = this.getString(attributes, 0x102201);
        this.patientSpecies = Code.create((Attributes)attributes, (int)0x102202);
        this.patientBreedDescription = this.getString(attributes, 1057431);
        this.patientBreed = Code.create((Attributes)attributes, (int)1057427);
    }

    @Override
    public void writeTo(Attributes attributes) {
        this.set(this.patientAge, attributes, 0x101010, DatasetAccessor.Type.Mandatory);
        this.set(this.occupation, attributes, 1057152, DatasetAccessor.Type.Mandatory);
        this.set(this.confidentialityPatientData, attributes, 4206593, DatasetAccessor.Type.Mandatory);
        this.set(this.patientBirthDate, attributes, 0x100030, DatasetAccessor.Type.Mandatory);
        this.set(this.patientBirthTime, attributes, 1048626, DatasetAccessor.Type.Mandatory);
        this.set(this.patientSex, attributes, 0x100040, DatasetAccessor.Type.Mandatory);
        this.set(this.patientInsurancePlan, attributes, 0x100050, DatasetAccessor.Type.Mandatory);
        this.set(this.patientPrimaryLanguage, attributes, 0x100101, DatasetAccessor.Type.Mandatory);
        this.set(this.patientSize, attributes, 0x101020, DatasetAccessor.Type.Mandatory);
        this.set(this.patientWeight, attributes, 0x101030, DatasetAccessor.Type.Mandatory);
        this.set(this.patientAddress, attributes, 0x101040, DatasetAccessor.Type.Mandatory);
        this.set(this.militaryRank, attributes, 0x101080, DatasetAccessor.Type.Mandatory);
        this.set(this.branchOfService, attributes, 0x101081, DatasetAccessor.Type.Mandatory);
        this.set(this.countryOfResidence, attributes, 1057104, DatasetAccessor.Type.Mandatory);
        this.set(this.regionOfResidence, attributes, 1057106, DatasetAccessor.Type.Mandatory);
        this.set(this.patientPhoneNumbers, attributes, 1057108, DatasetAccessor.Type.Mandatory);
        this.set(this.ethnicGroup, attributes, 1057120, DatasetAccessor.Type.Mandatory);
        this.set(this.patientReligiousPreference, attributes, 1057264, DatasetAccessor.Type.Mandatory);
        this.set(this.patientComments, attributes, 0x104000, DatasetAccessor.Type.Mandatory);
        this.set(this.responsiblePerson, attributes, 1057431, DatasetAccessor.Type.Optional);
        this.set(this.responsiblePersonRole, attributes, 1057432, DatasetAccessor.Type.Optional);
        this.set(this.responsibleOrganization, attributes, 1057433, DatasetAccessor.Type.Optional);
        this.set(this.patientSpeciesDescription, attributes, 0x102201, DatasetAccessor.Type.Optional);
        this.set((DatasetSource)this.patientSpecies, attributes, 0x102202, DatasetAccessor.Type.Optional);
        this.set(this.patientBreedDescription, attributes, 1057431, DatasetAccessor.Type.Optional);
        this.set((DatasetSource)this.patientBreed, attributes, 1057427, DatasetAccessor.Type.Optional);
    }

    public String getBranchOfService() {
        return this.branchOfService;
    }

    public void setBranchOfService(String string) {
        this.branchOfService = string;
    }

    public String getConfidentialityPatientData() {
        return this.confidentialityPatientData;
    }

    public void setConfidentialityPatientData(String string) {
        this.confidentialityPatientData = string;
    }

    public String getCountryOfResidence() {
        return this.countryOfResidence;
    }

    public void setCountryOfResidence(String string) {
        this.countryOfResidence = string;
    }

    public String getEthnicGroup() {
        return this.ethnicGroup;
    }

    public void setEthnicGroup(String string) {
        this.ethnicGroup = string;
    }

    public String getMilitaryRank() {
        return this.militaryRank;
    }

    public void setMilitaryRank(String string) {
        this.militaryRank = string;
    }

    public String getOccupation() {
        return this.occupation;
    }

    public void setOccupation(String string) {
        this.occupation = string;
    }

    public String[] getPatientAddress() {
        return this.patientAddress;
    }

    public void setPatientAddress(String[] stringArray) {
        this.patientAddress = stringArray;
    }

    public String getPatientAge() {
        return this.patientAge;
    }

    public void setPatientAge(String string) {
        this.patientAge = string;
    }

    public Date getPatientBirthDate() {
        return this.patientBirthDate;
    }

    public void setPatientBirthDate(Date date) {
        this.patientBirthDate = date;
    }

    public Date getPatientBirthTime() {
        return this.patientBirthTime;
    }

    public void setPatientBirthTime(Date date) {
        this.patientBirthTime = date;
    }

    public String getPatientComments() {
        return this.patientComments;
    }

    public void setPatientComments(String string) {
        this.patientComments = string;
    }

    public List<Code> getPatientInsurancePlan() {
        return this.patientInsurancePlan;
    }

    public void setPatientInsurancePlan(List<Code> list) {
        this.patientInsurancePlan = list;
    }

    public String[] getPatientPhoneNumbers() {
        return this.patientPhoneNumbers;
    }

    public void setPatientPhoneNumbers(String[] stringArray) {
        this.patientPhoneNumbers = stringArray;
    }

    public String getPatientReligiousPreference() {
        return this.patientReligiousPreference;
    }

    public void setPatientReligiousPreference(String string) {
        this.patientReligiousPreference = string;
    }

    public String getPatientSex() {
        return this.patientSex;
    }

    public void setPatientSex(String string) {
        this.patientSex = string;
    }

    public String getPatientSize() {
        return this.patientSize;
    }

    public void setPatientSize(String string) {
        this.patientSize = string;
    }

    public String[] getPatientWeight() {
        return this.patientWeight;
    }

    public void setPatientWeight(String[] stringArray) {
        this.patientWeight = stringArray;
    }

    public String getRegionOfResidence() {
        return this.regionOfResidence;
    }

    public void setRegionOfResidence(String string) {
        this.regionOfResidence = string;
    }

    public List<LanguageCode> patientPrimaryLanguage() {
        return this.patientPrimaryLanguage;
    }
}

