/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.mwl;

import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.listtext.dicomobject.type.print.FilmSizeID;
import com.agfa.pacs.listtext.dicomobject.type.print.MediumType;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class FilmConsumption
extends AbstractDatasetSource {
    private Integer numberOfFilms;
    private FilmSizeID filmSizeID;
    private MediumType mediumType;

    public FilmConsumption() {
    }

    private FilmConsumption(Attributes attributes) {
        this.numberOfFilms = this.getInteger(attributes, 553648496);
        this.mediumType = MediumType.get(this.getString(attributes, 0x20000030));
        this.filmSizeID = FilmSizeID.get(this.getString(attributes, 537919568));
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.numberOfFilms, attributes, 553648496, DatasetAccessor.Type.Mandatory);
        this.set(this.mediumType, attributes, 0x20000030, DatasetAccessor.Type.Mandatory);
        this.set(this.filmSizeID, attributes, 537919568, DatasetAccessor.Type.Mandatory);
        return attributes;
    }

    public static FilmConsumption create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        return new FilmConsumption(attributes);
    }

    public static FilmConsumption create(Attributes attributes, int n) {
        try {
            return FilmConsumption.create(attributes.getNestedDataset(n));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static List<FilmConsumption> createList(Attributes attributes, int n) {
        ArrayList<FilmConsumption> arrayList = new ArrayList<FilmConsumption>();
        Sequence sequence = attributes.getSequence(n);
        if (sequence == null) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < sequence.size()) {
            FilmConsumption filmConsumption = FilmConsumption.create((Attributes)sequence.get(n2));
            if (filmConsumption != null) {
                arrayList.add(filmConsumption);
            }
            ++n2;
        }
        return arrayList;
    }

    public FilmSizeID getFilmSizeID() {
        return this.filmSizeID;
    }

    public void setFilmSizeID(FilmSizeID filmSizeID) {
        this.filmSizeID = filmSizeID;
    }

    public MediumType getMediumType() {
        return this.mediumType;
    }

    public void setMediumType(MediumType mediumType) {
        this.mediumType = mediumType;
    }

    public Integer getNumberOfFilms() {
        return this.numberOfFilms;
    }

    public void setNumberOfFilms(Integer n) {
        this.numberOfFilms = n;
    }
}

