/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.mwl;

import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.listtext.dicomobject.module.mwl.RadiationMode;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class ExposureDose
extends AbstractDatasetSource {
    private Double kvp;
    private RadiationMode radiationMode;
    private Integer xRayTubeCurrent_uA;
    private Integer exposureTime;
    private String filterType;
    private String filterMaterial;
    private String commentsOnRadiationDose;

    public ExposureDose() {
    }

    private ExposureDose(Attributes attributes) {
        this.radiationMode = RadiationMode.get(this.getString(attributes, 1577306));
        this.kvp = this.getDouble(attributes, 1572960);
        this.xRayTubeCurrent_uA = this.getInteger(attributes, 0x188151);
        this.exposureTime = this.getInteger(attributes, 1577296);
        this.filterType = this.getString(attributes, 1577312);
        this.filterMaterial = this.getString(attributes, 1601616);
        this.commentsOnRadiationDose = this.getString(attributes, 4195088);
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.radiationMode, attributes, 1577306, DatasetAccessor.Type.Optional);
        this.set(this.kvp, attributes, 1572960, DatasetAccessor.Type.Optional);
        this.set(this.xRayTubeCurrent_uA, attributes, 0x188151, DatasetAccessor.Type.Optional);
        this.set(this.exposureTime, attributes, 1577296, DatasetAccessor.Type.Optional);
        this.set(this.filterType, attributes, 1577312, DatasetAccessor.Type.Optional);
        this.set(this.filterMaterial, attributes, 1601616, DatasetAccessor.Type.Optional);
        this.set(this.commentsOnRadiationDose, attributes, 4195088, DatasetAccessor.Type.Optional);
        return attributes;
    }

    public static ExposureDose create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        return new ExposureDose(attributes);
    }

    public static List<ExposureDose> createList(Attributes attributes, int n) {
        ArrayList<ExposureDose> arrayList = new ArrayList<ExposureDose>();
        Sequence sequence = attributes.getSequence(n);
        if (sequence == null) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < sequence.size()) {
            ExposureDose exposureDose = ExposureDose.create((Attributes)sequence.get(n2));
            if (exposureDose != null) {
                arrayList.add(exposureDose);
            }
            ++n2;
        }
        return arrayList;
    }

    public String getCommentsOnRadiationDose() {
        return this.commentsOnRadiationDose;
    }

    public void setCommentsOnRadiationDose(String string) {
        this.commentsOnRadiationDose = string;
    }

    public Integer getExposureTime() {
        return this.exposureTime;
    }

    public void setExposureTime(Integer n) {
        this.exposureTime = n;
    }

    public String getFilterMaterial() {
        return this.filterMaterial;
    }

    public void setFilterMaterial(String string) {
        this.filterMaterial = string;
    }

    public String getFilterType() {
        return this.filterType;
    }

    public void setFilterType(String string) {
        this.filterType = string;
    }

    public Double getKvp() {
        return this.kvp;
    }

    public void setKvp(Double d) {
        this.kvp = d;
    }

    public RadiationMode getRadiationMode() {
        return this.radiationMode;
    }

    public void setRadiationMode(RadiationMode radiationMode) {
        this.radiationMode = radiationMode;
    }

    public Integer getXRayTubeCurrent_uA() {
        return this.xRayTubeCurrent_uA;
    }

    public void setXRayTubeCurrent_uA(Integer n) {
        this.xRayTubeCurrent_uA = n;
    }
}

