/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.ko;

import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.listtext.dicomobject.general.SOPInstanceReference;
import com.agfa.pacs.listtext.dicomobject.module.AbstractModule;
import com.agfa.pacs.listtext.dicomobject.module.IModule;
import com.agfa.pacs.listtext.dicomobject.module.general.SOPCommonModule;
import com.agfa.pacs.listtext.dicomobject.module.ko.ReferencedRequest;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.dcm4che3.data.Attributes;

public class KeyObjectDocumentModule
extends AbstractModule {
    private Integer instanceNumber;
    private List<SOPInstanceReference> currentRequestedProcedureEvidences = new ArrayList<SOPInstanceReference>();
    private List<ReferencedRequest> referencedRequests = new ArrayList<ReferencedRequest>();
    private List<SOPInstanceReference> identicalDocuments = new ArrayList<SOPInstanceReference>();
    private Date contentDate;
    private Date contentTime;

    public KeyObjectDocumentModule() {
        super(Level.Object);
    }

    @Override
    public Class<? extends IModule>[] specializationOf() {
        return new Class[]{SOPCommonModule.class};
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean containsModule(Attributes attributes) {
        return attributes.contains(2097171) && attributes.contains(524323) && attributes.contains(524339);
    }

    @Override
    public void readFrom(Attributes attributes) {
        this.instanceNumber = this.getInteger(attributes, 2097171);
        this.contentDate = this.getDate(attributes, 524323);
        this.contentTime = this.getDate(attributes, 524339);
        this.identicalDocuments = SOPInstanceReference.createList(attributes, 4236581);
        this.referencedRequests = ReferencedRequest.createList(attributes, 4236144);
        this.currentRequestedProcedureEvidences = SOPInstanceReference.createList(attributes, 4236149);
    }

    @Override
    public void writeTo(Attributes attributes) {
        this.set(this.instanceNumber, attributes, 2097171, DatasetAccessor.Type.Mandatory);
        this.set(this.contentDate, attributes, 524323, DatasetAccessor.Type.Mandatory);
        this.set(this.contentTime, attributes, 524339, DatasetAccessor.Type.Mandatory);
        this.set(this.identicalDocuments, attributes, 4236581, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.referencedRequests, attributes, 4236144, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.currentRequestedProcedureEvidences, attributes, 4236149, DatasetAccessor.Type.Mandatory);
    }

    public List<SOPInstanceReference> currentRequestedProcedureEvidences() {
        return this.currentRequestedProcedureEvidences;
    }

    public List<SOPInstanceReference> identicalDocuments() {
        return this.identicalDocuments;
    }

    public Integer getInstanceNumber() {
        return this.instanceNumber;
    }

    public List<ReferencedRequest> referencedRequests() {
        return this.referencedRequests;
    }

    public void setInstanceNumber(Integer n) {
        this.instanceNumber = n;
    }

    public Date getContentDate() {
        return this.contentDate;
    }

    public void setContentDate(Date date) {
        this.contentDate = date;
    }

    public Date getContentTime() {
        return this.contentTime;
    }

    public void setContentTime(Date date) {
        this.contentTime = date;
    }
}

