/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.equipment;

import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.listtext.dicomobject.module.AbstractModule;
import com.agfa.pacs.listtext.dicomobject.module.equipment.ConversionType;
import org.dcm4che3.data.Attributes;

public class SCEquipmentModule
extends AbstractModule {
    private String digitalImageFormatAcquired;
    private String videoImageFormatAcquired;
    private String deviceManufacturerModelName;
    private String deviceSoftwareVersion;
    private String deviceManufacturer;
    private String deviceID;
    private ConversionType conversionType;

    public SCEquipmentModule() {
        super(Level.Series);
    }

    @Override
    public boolean isValid() {
        return this.conversionType != null;
    }

    @Override
    public boolean containsModule(Attributes attributes) {
        return attributes.contains(524388);
    }

    @Override
    public void readFrom(Attributes attributes) {
        this.conversionType = ConversionType.get(this.getString(attributes, 524388));
        this.deviceID = this.getString(attributes, 0x181010);
        this.deviceManufacturer = this.getString(attributes, 1576982);
        this.deviceManufacturerModelName = this.getString(attributes, 0x181018);
        this.deviceSoftwareVersion = this.getString(attributes, 1576985);
        this.videoImageFormatAcquired = this.getString(attributes, 1576994);
        this.digitalImageFormatAcquired = this.getString(attributes, 1576995);
    }

    @Override
    public void writeTo(Attributes attributes) {
        this.set(this.conversionType, attributes, 524388, DatasetAccessor.Type.Mandatory);
        this.set(this.deviceID, attributes, 0x181010, DatasetAccessor.Type.Optional);
        this.set(this.deviceManufacturer, attributes, 1576982, DatasetAccessor.Type.Optional);
        this.set(this.deviceManufacturerModelName, attributes, 0x181018, DatasetAccessor.Type.Optional);
        this.set(this.deviceSoftwareVersion, attributes, 1576985, DatasetAccessor.Type.Optional);
        this.set(this.videoImageFormatAcquired, attributes, 1576994, DatasetAccessor.Type.Optional);
        this.set(this.digitalImageFormatAcquired, attributes, 1576995, DatasetAccessor.Type.Optional);
    }

    public ConversionType getConversionType() {
        return this.conversionType;
    }

    public void setConversionType(ConversionType conversionType) {
        this.conversionType = conversionType;
    }

    public String getDeviceID() {
        return this.deviceID;
    }

    public void setDeviceID(String string) {
        this.deviceID = string;
    }

    public String getDeviceManufacturer() {
        return this.deviceManufacturer;
    }

    public void setDeviceManufacturer(String string) {
        this.deviceManufacturer = string;
    }

    public String getDeviceManufacturerModelName() {
        return this.deviceManufacturerModelName;
    }

    public void setDeviceManufacturerModelName(String string) {
        this.deviceManufacturerModelName = string;
    }

    public String getDeviceSoftwareVersion() {
        return this.deviceSoftwareVersion;
    }

    public void setDeviceSoftwareVersion(String string) {
        this.deviceSoftwareVersion = string;
    }

    public String getDigitalImageFormatAcquired() {
        return this.digitalImageFormatAcquired;
    }

    public void setDigitalImageFormatAcquired(String string) {
        this.digitalImageFormatAcquired = string;
    }

    public String getVideoImageFormatAcquired() {
        return this.videoImageFormatAcquired;
    }

    public void setVideoImageFormatAcquired(String string) {
        this.videoImageFormatAcquired = string;
    }
}

